/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.publisher;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfigs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;
import org.aton.cache.LRUCacheContainer;

public class FolderPublishConfigCacheMgr {
    private static Logger logger = Logger.getLogger(FolderPublishConfigCacheMgr.class);
    private LRUCacheContainer m_lruCache = null;
    public static int MAX_CACHE_SIZE = 30000;

    private synchronized void initCache() {
        if (this.m_lruCache != null) {
            return;
        }
        this.m_lruCache = new LRUCacheContainer();
        this.m_lruCache.setMaxSize(MAX_CACHE_SIZE);
        WCMFilter wCMFilter = new WCMFilter("", "FolderType != 605", "FolderId desc");
        wCMFilter.setMaxRowNumber(MAX_CACHE_SIZE);
        try {
            FolderPublishConfigs folderPublishConfigs = FolderPublishConfigs.openWCMObjs(User.getSystem(), wCMFilter);
            int n = folderPublishConfigs.size();
            for (int i = 0; i < n; ++i) {
                FolderPublishConfig folderPublishConfig = (FolderPublishConfig)folderPublishConfigs.getAt(i);
                if (folderPublishConfig == null) continue;
                String string = this.makeKey(folderPublishConfig.getFolderType(), folderPublishConfig.getFolderId());
                this.m_lruCache.put((Object)string, (Object)folderPublishConfig);
            }
        }
        catch (Exception exception) {
            logger.error((Object)I18NMessage.get(FolderPublishConfigCacheMgr.class, "FolderPublishConfigCacheMgr.label1", "\u521d\u59cb\u5316\u9891\u9053\u7684\u53d1\u5e03\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01"), (Throwable)exception);
        }
    }

    protected void notifyOnRemoveConfig(FolderPublishConfig folderPublishConfig) {
        if (this.m_lruCache == null) {
            this.initCache();
        }
        this.m_lruCache.remove((Object)this.makeKey(folderPublishConfig.getFolderType(), folderPublishConfig.getFolderId()));
    }

    protected FolderPublishConfig findConfig(int n, int n2) throws WCMException {
        Object object;
        if (this.m_lruCache == null) {
            this.initCache();
        }
        if ((object = this.m_lruCache.get((Object)this.makeKey(n, n2))) != null) {
            return (FolderPublishConfig)object;
        }
        return this.loadConfig(n, n2);
    }

    private synchronized FolderPublishConfig loadConfig(int n, int n2) throws WCMException {
        String string = this.makeKey(n, n2);
        Object object = this.m_lruCache.get((Object)string);
        if (object != null) {
            return (FolderPublishConfig)object;
        }
        String string2 = "FolderType=? and FolderId=?";
        WCMFilter wCMFilter = new WCMFilter("", string2, "");
        wCMFilter.addSearchValues(0, n);
        wCMFilter.addSearchValues(1, n2);
        wCMFilter.setMaxRowNumber(1);
        FolderPublishConfigs folderPublishConfigs = FolderPublishConfigs.openWCMObjs(User.getSystem(), wCMFilter);
        if (folderPublishConfigs.isEmpty()) {
            return null;
        }
        FolderPublishConfig folderPublishConfig = (FolderPublishConfig)folderPublishConfigs.getAt(0);
        if (folderPublishConfig == null) {
            return null;
        }
        this.m_lruCache.put((Object)string, (Object)folderPublishConfig);
        return folderPublishConfig;
    }

    private String makeKey(int n, int n2) {
        return n + "_" + n2;
    }
}

