/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.notify.NotificationServer;
import com.trs.components.common.message.notify.Notifier;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.taskdispatch.ILaborResourceMgr;
import com.trs.components.common.publish.domain.taskdispatch.IPageTask;
import com.trs.components.common.publish.domain.taskdispatch.IPageTaskDispatcher;
import com.trs.components.common.publish.domain.taskdispatch.IPublishProgressMonitor;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.domain.taskdispatch.PageTaskWorker;
import com.trs.components.common.publish.domain.taskdispatch.ProgressMonitorImpl;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskAnalyzer;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskDispatcherImpl;
import com.trs.components.common.publish.domain.taskdispatch.ThreadPool;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;
import org.aton.util.Counter;

public class PublishTaskWorker
implements Runnable,
IPageTaskDispatcher,
IClearable {
    private static final Logger logger = Logger.getLogger(PublishTaskWorker.class);
    public static final int RUN_INTERVAL = 100;
    private static int threadInitNumber = 1;
    private boolean m_bCanceled = false;
    private PublishTaskAnalyzer m_taskAnalyzer;
    private PublishTaskContext m_taskContext = null;
    private ILaborResourceMgr m_laborResourceMgr;
    private ThreadPool m_oThreadPool;
    private Counter m_busyWorkerCounter;
    private PublishTask m_task = null;
    private int m_nPriority;
    private CMyDateTime m_dtStart = null;
    PageTaskWorker[] m_workers = null;
    private int m_nLaborsApplied;
    private int m_nWorkersCreated;
    private int m_nResult = 10;
    private boolean m_bHasWarnings = false;
    private boolean m_bTaskUpdatedAfterStarted = false;
    private String m_sException = null;
    private IPublishProgressMonitor m_oProgressMonitor = null;
    private PublishTaskDispatcherImpl m_oDispatcherImpl = null;
    private String m_sWorkerName = "PublishTaskWorker-" + PublishTaskWorker.nextThreadNum();
    private boolean m_zStarted;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public PublishTaskWorker() {
        this(null);
    }

    PublishTaskWorker(PublishTaskDispatcherImpl publishTaskDispatcherImpl) {
        this.m_oThreadPool = (ThreadPool)DreamFactory.createObjectById("PublishThreadPool");
        this.m_laborResourceMgr = (ILaborResourceMgr)DreamFactory.createObjectById("ILaborResourceMgr.Publish");
        this.m_taskAnalyzer = new PublishTaskAnalyzer();
        this.m_taskAnalyzer.setTaskWorker(this);
        this.m_busyWorkerCounter = new Counter();
        this.m_oProgressMonitor = this.newProgressMonitor();
        this.m_oDispatcherImpl = publishTaskDispatcherImpl;
    }

    public synchronized void clear() {
        this.m_taskAnalyzer.clear();
        if (this.m_taskContext != null) {
            this.m_taskContext.clear();
            this.m_taskContext = null;
        }
        this.m_busyWorkerCounter.reset();
        if (this.m_workers != null) {
            for (int i = 0; i < this.m_workers.length; ++i) {
                if (this.m_workers[i] == null) continue;
                this.m_workers[i].clear();
            }
            this.m_workers = null;
        }
        if (this.m_oProgressMonitor != null) {
            this.m_oProgressMonitor.clear();
        }
    }

    public void setTask(PublishTask publishTask) {
        this.m_task = publishTask;
        this.m_nPriority = this.m_task.getPriority();
        this.m_bTaskUpdatedAfterStarted = false;
        this.m_sException = null;
        this.m_nLaborsApplied = 1;
        this.m_nWorkersCreated = 0;
    }

    public PublishTask getTask() {
        return this.m_task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyzerCanceled() {
        PublishTaskWorker publishTaskWorker = this;
        synchronized (publishTaskWorker) {
            this.m_bCanceled = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        logger.debug((Object)"to cacnel this task ...");
        IClearable iClearable = this;
        synchronized (iClearable) {
            this.m_bCanceled = true;
            this.m_taskAnalyzer.cancel();
            this.notifyAll();
        }
        iClearable = this.m_busyWorkerCounter;
        synchronized (iClearable) {
            this.m_busyWorkerCounter.notifyAll();
        }
        iClearable = this.m_laborResourceMgr;
        synchronized (iClearable) {
            this.m_laborResourceMgr.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block76: {
            block75: {
                block74: {
                    block73: {
                        block71: {
                            block72: {
                                this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label1", "\u7ebf\u7a0b\u542f\u52a8"));
                                this.m_dtStart = CMyDateTime.now();
                                this.m_nResult = 10;
                                try {
                                    try {
                                        if (this.m_bCanceled) {
                                            Object var5_1 = null;
                                            if (this.m_nLaborsApplied > this.m_nWorkersCreated) {
                                                this.m_laborResourceMgr.releaseLabor(this.m_nLaborsApplied - this.m_nWorkersCreated, this.m_nPriority);
                                            }
                                            if (this.m_bCanceled) {
                                                this.m_sException = this.m_taskAnalyzer.getErrors();
                                            }
                                            if (!this.m_bCanceled) break block71;
                                            break block72;
                                        }
                                        logger.debug((Object)("Task[" + this.m_task.getId() + "] is started ..."));
                                        if (this.m_oDispatcherImpl != null) {
                                            this.m_oDispatcherImpl.onWorkerStartup(this);
                                        }
                                        ContextHelper.setLoginUser(User.getSystem());
                                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label2", "\u5f00\u59cb\u5206\u89e3\u4efb\u52a1"));
                                        this.m_taskAnalyzer.start(this.m_task);
                                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label3", "\u4efb\u52a1\u5206\u89e3\u7ed3\u675f"));
                                        int n = this.m_taskAnalyzer.getPageTaskCount();
                                        if (n == 0) {
                                            this.m_nResult = 7;
                                            break block73;
                                        }
                                        if (this.m_bCanceled) {
                                            break block74;
                                        }
                                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label4", "\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u6b63\u5728\u6267\u884c"));
                                        this.updateTaskWhenStarted();
                                        int n2 = this.m_laborResourceMgr.calMaxLaborNeeded(n, this.m_nPriority);
                                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label5", "\u9700\u8981\u6267\u884c\u7ebf\u7a0b") + n2 + I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label6", "\u4e2a"));
                                        if (n2 > this.m_nLaborsApplied) {
                                            this.m_nLaborsApplied += this.m_laborResourceMgr.applyForLabor(n2 - this.m_nLaborsApplied, this.m_nPriority);
                                        }
                                        logger.debug((Object)("Task[" + this.m_task.getId() + "] applied labors total: " + this.m_nLaborsApplied));
                                        this.m_workers = new PageTaskWorker[n2];
                                        this.m_busyWorkerCounter.reset();
                                        this.createWorkers(this.m_nLaborsApplied);
                                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label7", "\u521b\u5efa\u6267\u884c\u7ebf\u7a0b") + this.m_nWorkersCreated + I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label6", "\u4e2a"));
                                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label8", "\u7b49\u5f85\u6267\u884c\u7ebf\u7a0b\u7ed3\u675f"));
                                        while (this.m_busyWorkerCounter.value() > 0) {
                                            if (this.m_bCanceled) {
                                                break block75;
                                            }
                                            if (this.m_nLaborsApplied > 0 && n2 <= this.m_nLaborsApplied * 2 || this.m_taskAnalyzer.getWaitingPageTaskCount() <= this.m_nLaborsApplied * 2) {
                                                PublishTaskWorker.waitOn(this.m_busyWorkerCounter);
                                                continue;
                                            }
                                            int n3 = this.m_laborResourceMgr.applyForLabor(n2 - this.m_nLaborsApplied, this.m_nPriority);
                                            if (n3 <= 0) {
                                                PublishTaskWorker.waitOn(this.m_laborResourceMgr);
                                                continue;
                                            }
                                            this.m_nLaborsApplied += n3;
                                            logger.debug((Object)("Task[" + this.m_task.getId() + "] new applied labors: " + n3));
                                            this.createWorkers(n3);
                                            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label9", "\u8865\u5145\u521b\u5efa\u6267\u884c\u7ebf\u7a0b\u81f3") + this.m_nWorkersCreated + I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label6", "\u4e2a"));
                                        }
                                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label10", "\u6267\u884c\u7ebf\u7a0b\u5168\u90e8\u7ed3\u675f"));
                                        if (!this.m_bCanceled) {
                                            this.m_sException = this.m_taskAnalyzer.getErrors();
                                            this.m_nResult = this.m_sException != null ? 9 : (this.m_bHasWarnings ? 6 : 7);
                                        }
                                        break block76;
                                    }
                                    catch (Exception exception) {
                                        logger.error((Object)"failed to execute publish task!", (Throwable)exception);
                                        this.m_sException = CMyException.getStackTraceText(exception);
                                        this.m_nResult = exception instanceof CMyException && ((CMyException)exception).getErrNo() == 10 ? 11 : 9;
                                        Object var5_6 = null;
                                        if (this.m_nLaborsApplied > this.m_nWorkersCreated) {
                                            this.m_laborResourceMgr.releaseLabor(this.m_nLaborsApplied - this.m_nWorkersCreated, this.m_nPriority);
                                        }
                                        if (this.m_bCanceled) {
                                            this.m_sException = this.m_taskAnalyzer.getErrors();
                                        }
                                        if (this.m_bCanceled && this.m_busyWorkerCounter.value() > 0) {
                                            logger.debug((Object)("Task[" + this.m_task.getId() + "] is canceled."));
                                            for (int i = 0; i < this.m_nWorkersCreated; ++i) {
                                                this.m_workers[i].cancel();
                                            }
                                        }
                                        if (this.m_busyWorkerCounter.value() > 0) {
                                            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label11", "\u7b49\u5f85\u5168\u90e8\u6267\u884c\u7ebf\u7a0b\u7ed3\u675f"));
                                            while (this.m_busyWorkerCounter.value() > 0) {
                                                try {
                                                    this.m_busyWorkerCounter.wait(400L);
                                                }
                                                catch (Throwable throwable) {}
                                            }
                                        }
                                        if (this.m_oDispatcherImpl != null) {
                                            this.m_oDispatcherImpl.onWorkerCleanup(this);
                                        }
                                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label12", "\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210"));
                                        this.updateTaskWhenFinished();
                                        this.sendNotificationAfterTaskExecuted();
                                        this.clear();
                                        if (!logger.isDebugEnabled()) return;
                                        logger.debug((Object)("Task[" + this.m_task.getId() + "] has finished with result " + this.m_nResult));
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var5_7 = null;
                                    if (this.m_nLaborsApplied > this.m_nWorkersCreated) {
                                        this.m_laborResourceMgr.releaseLabor(this.m_nLaborsApplied - this.m_nWorkersCreated, this.m_nPriority);
                                    }
                                    if (this.m_bCanceled) {
                                        this.m_sException = this.m_taskAnalyzer.getErrors();
                                    }
                                    if (this.m_bCanceled && this.m_busyWorkerCounter.value() > 0) {
                                        logger.debug((Object)("Task[" + this.m_task.getId() + "] is canceled."));
                                        for (int i = 0; i < this.m_nWorkersCreated; ++i) {
                                            this.m_workers[i].cancel();
                                        }
                                    }
                                    if (this.m_busyWorkerCounter.value() > 0) {
                                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label11", "\u7b49\u5f85\u5168\u90e8\u6267\u884c\u7ebf\u7a0b\u7ed3\u675f"));
                                        while (this.m_busyWorkerCounter.value() > 0) {
                                            try {}
                                            catch (Throwable throwable2) {}
                                            this.m_busyWorkerCounter.wait(400L);
                                        }
                                    }
                                    if (this.m_oDispatcherImpl != null) {
                                        this.m_oDispatcherImpl.onWorkerCleanup(this);
                                    }
                                    this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label12", "\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210"));
                                    this.updateTaskWhenFinished();
                                    this.sendNotificationAfterTaskExecuted();
                                    this.clear();
                                    if (!logger.isDebugEnabled()) throw throwable;
                                    logger.debug((Object)("Task[" + this.m_task.getId() + "] has finished with result " + this.m_nResult));
                                    throw throwable;
                                }
                            }
                            if (this.m_busyWorkerCounter.value() > 0) {
                                logger.debug((Object)("Task[" + this.m_task.getId() + "] is canceled."));
                                for (int i = 0; i < this.m_nWorkersCreated; ++i) {
                                    this.m_workers[i].cancel();
                                }
                            }
                        }
                        if (this.m_busyWorkerCounter.value() > 0) {
                            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label11", "\u7b49\u5f85\u5168\u90e8\u6267\u884c\u7ebf\u7a0b\u7ed3\u675f"));
                            while (this.m_busyWorkerCounter.value() > 0) {
                                try {}
                                catch (Throwable throwable) {}
                                this.m_busyWorkerCounter.wait(400L);
                            }
                        }
                        if (this.m_oDispatcherImpl != null) {
                            this.m_oDispatcherImpl.onWorkerCleanup(this);
                        }
                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label12", "\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210"));
                        this.updateTaskWhenFinished();
                        this.sendNotificationAfterTaskExecuted();
                        this.clear();
                        if (!logger.isDebugEnabled()) return;
                        logger.debug((Object)("Task[" + this.m_task.getId() + "] has finished with result " + this.m_nResult));
                        return;
                    }
                    Object var5_2 = null;
                    if (this.m_nLaborsApplied > this.m_nWorkersCreated) {
                        this.m_laborResourceMgr.releaseLabor(this.m_nLaborsApplied - this.m_nWorkersCreated, this.m_nPriority);
                    }
                    if (this.m_bCanceled) {
                        this.m_sException = this.m_taskAnalyzer.getErrors();
                    }
                    if (this.m_bCanceled && this.m_busyWorkerCounter.value() > 0) {
                        logger.debug((Object)("Task[" + this.m_task.getId() + "] is canceled."));
                        for (int i = 0; i < this.m_nWorkersCreated; ++i) {
                            this.m_workers[i].cancel();
                        }
                    }
                    if (this.m_busyWorkerCounter.value() > 0) {
                        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label11", "\u7b49\u5f85\u5168\u90e8\u6267\u884c\u7ebf\u7a0b\u7ed3\u675f"));
                        while (this.m_busyWorkerCounter.value() > 0) {
                            try {}
                            catch (Throwable throwable) {}
                            this.m_busyWorkerCounter.wait(400L);
                        }
                    }
                    if (this.m_oDispatcherImpl != null) {
                        this.m_oDispatcherImpl.onWorkerCleanup(this);
                    }
                    this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label12", "\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210"));
                    this.updateTaskWhenFinished();
                    this.sendNotificationAfterTaskExecuted();
                    this.clear();
                    if (!logger.isDebugEnabled()) return;
                    logger.debug((Object)("Task[" + this.m_task.getId() + "] has finished with result " + this.m_nResult));
                    return;
                }
                Object var5_3 = null;
                if (this.m_nLaborsApplied > this.m_nWorkersCreated) {
                    this.m_laborResourceMgr.releaseLabor(this.m_nLaborsApplied - this.m_nWorkersCreated, this.m_nPriority);
                }
                if (this.m_bCanceled) {
                    this.m_sException = this.m_taskAnalyzer.getErrors();
                }
                if (this.m_bCanceled && this.m_busyWorkerCounter.value() > 0) {
                    logger.debug((Object)("Task[" + this.m_task.getId() + "] is canceled."));
                    for (int i = 0; i < this.m_nWorkersCreated; ++i) {
                        this.m_workers[i].cancel();
                    }
                }
                if (this.m_busyWorkerCounter.value() > 0) {
                    this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label11", "\u7b49\u5f85\u5168\u90e8\u6267\u884c\u7ebf\u7a0b\u7ed3\u675f"));
                    while (this.m_busyWorkerCounter.value() > 0) {
                        try {}
                        catch (Throwable throwable) {}
                        this.m_busyWorkerCounter.wait(400L);
                    }
                }
                if (this.m_oDispatcherImpl != null) {
                    this.m_oDispatcherImpl.onWorkerCleanup(this);
                }
                this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label12", "\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210"));
                this.updateTaskWhenFinished();
                this.sendNotificationAfterTaskExecuted();
                this.clear();
                if (!logger.isDebugEnabled()) return;
                logger.debug((Object)("Task[" + this.m_task.getId() + "] has finished with result " + this.m_nResult));
                return;
            }
            Object var5_4 = null;
            if (this.m_nLaborsApplied > this.m_nWorkersCreated) {
                this.m_laborResourceMgr.releaseLabor(this.m_nLaborsApplied - this.m_nWorkersCreated, this.m_nPriority);
            }
            if (this.m_bCanceled) {
                this.m_sException = this.m_taskAnalyzer.getErrors();
            }
            if (this.m_bCanceled && this.m_busyWorkerCounter.value() > 0) {
                logger.debug((Object)("Task[" + this.m_task.getId() + "] is canceled."));
                for (int i = 0; i < this.m_nWorkersCreated; ++i) {
                    this.m_workers[i].cancel();
                }
            }
            if (this.m_busyWorkerCounter.value() > 0) {
                this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label11", "\u7b49\u5f85\u5168\u90e8\u6267\u884c\u7ebf\u7a0b\u7ed3\u675f"));
                while (this.m_busyWorkerCounter.value() > 0) {
                    try {}
                    catch (Throwable throwable) {}
                    this.m_busyWorkerCounter.wait(400L);
                }
            }
            if (this.m_oDispatcherImpl != null) {
                this.m_oDispatcherImpl.onWorkerCleanup(this);
            }
            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label12", "\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210"));
            this.updateTaskWhenFinished();
            this.sendNotificationAfterTaskExecuted();
            this.clear();
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Task[" + this.m_task.getId() + "] has finished with result " + this.m_nResult));
            return;
        }
        Object var5_5 = null;
        if (this.m_nLaborsApplied > this.m_nWorkersCreated) {
            this.m_laborResourceMgr.releaseLabor(this.m_nLaborsApplied - this.m_nWorkersCreated, this.m_nPriority);
        }
        if (this.m_bCanceled) {
            this.m_sException = this.m_taskAnalyzer.getErrors();
        }
        if (this.m_bCanceled && this.m_busyWorkerCounter.value() > 0) {
            logger.debug((Object)("Task[" + this.m_task.getId() + "] is canceled."));
            for (int i = 0; i < this.m_nWorkersCreated; ++i) {
                this.m_workers[i].cancel();
            }
        }
        if (this.m_busyWorkerCounter.value() > 0) {
            this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label11", "\u7b49\u5f85\u5168\u90e8\u6267\u884c\u7ebf\u7a0b\u7ed3\u675f"));
            while (this.m_busyWorkerCounter.value() > 0) {
                try {}
                catch (Throwable throwable) {}
                this.m_busyWorkerCounter.wait(400L);
            }
        }
        if (this.m_oDispatcherImpl != null) {
            this.m_oDispatcherImpl.onWorkerCleanup(this);
        }
        this.log2Monitor(I18NMessage.get(PublishTaskWorker.class, "PublishTaskWorker.label12", "\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u5b8c\u6210"));
        this.updateTaskWhenFinished();
        this.sendNotificationAfterTaskExecuted();
        this.clear();
        if (!logger.isDebugEnabled()) return;
        logger.debug((Object)("Task[" + this.m_task.getId() + "] has finished with result " + this.m_nResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitOn(Object object) {
        Object object2 = object;
        synchronized (object2) {
            try {
                object.wait(400L);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    private void createWorkers(int n) {
        for (int i = 0; i < n; ++i) {
            PageTaskWorker pageTaskWorker;
            if (this.m_bCanceled) {
                return;
            }
            if (this.m_taskContext == null) {
                this.m_taskContext = new PublishTaskContext(this.m_task, this.m_taskAnalyzer.getFolder());
            }
            if (!this.m_oThreadPool.runIt(pageTaskWorker = new PageTaskWorker(this, this.m_taskContext, this.newProgressMonitor()))) {
                pageTaskWorker.start();
            }
            this.m_workers[this.m_nWorkersCreated++] = pageTaskWorker;
            this.m_busyWorkerCounter.add(1);
        }
    }

    private void updateTaskWhenStarted() {
        try {
            IPublishTaskMgr iPublishTaskMgr = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");
            this.m_task.canEdit(ContextHelper.getLoginUser());
            this.m_task.setPageTaskCount(this.m_taskAnalyzer.getPageTaskCount());
            this.m_task.setStartTime(this.m_dtStart);
            this.m_task.setStatus(5);
            iPublishTaskMgr.save(this.m_task);
            this.m_bTaskUpdatedAfterStarted = true;
        }
        catch (Exception exception) {
            logger.error((Object)("Task[" + this.m_task.getId() + "]: failed to update task record when started."), (Throwable)exception);
        }
    }

    private void updateTaskWhenFinished() {
        try {
            IPublishTaskMgr iPublishTaskMgr = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");
            this.m_task.canEdit(ContextHelper.getLoginUser());
            CMyDateTime cMyDateTime = CMyDateTime.now();
            if (!this.m_bTaskUpdatedAfterStarted) {
                this.m_task.setPageTaskCount(this.m_taskAnalyzer.getPageTaskCount());
                this.m_task.setStartTime(this.m_dtStart);
            }
            this.m_task.setEndTime(cMyDateTime);
            this.m_task.setTimeUsed((int)(cMyDateTime.getTimeInMillis() - this.m_dtStart.getTimeInMillis()));
            this.m_task.setStatus(this.m_nResult);
            this.m_task.setHasWarnings(this.m_bHasWarnings);
            if (this.m_sException != null) {
                this.m_task.setAnalyzeError(this.m_sException);
            }
            if (this.m_nResult == 7 || this.m_nResult == 6) {
                try {
                    this.m_task.setURL(PublishTaskWorker.getTaskPreviewURL(this.m_task));
                }
                catch (Exception exception) {
                    this.m_task.setURL(new String[0]);
                }
            }
            this.m_task.setDetailPageCount(this.getDetailPageCount());
            this.m_task.setOutlinePageCount(this.getOutlinePageCount());
            iPublishTaskMgr.save(this.m_task);
        }
        catch (Exception exception) {
            logger.error((Object)("Task[" + this.m_task.getId() + "]: failed to update task when finished."), (Throwable)exception);
        }
    }

    private void sendNotificationAfterTaskExecuted() {
        try {
            String string;
            switch (this.m_nResult) {
                case 7: {
                    string = "Publish.WhenTaskFinished";
                    break;
                }
                case 6: {
                    string = "Publish.WhenTaskFinishedWithWarning";
                    break;
                }
                default: {
                    string = "Publish.WhenTaskFailed";
                }
            }
            if (NotificationServer.getInstance().needNotifyForEvent(string)) {
                Notifier notifier = new Notifier();
                notifier.setParameter("title", this.m_task.getTitle());
                notifier.setParameter("Id", String.valueOf(this.m_task.getId()));
                notifier.setParameter("Submitter", this.m_task.getCrUserName());
                notifier.executeOnEvent(string);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Task[" + this.m_task.getId() + "]: failed to send notification after task is executed."), (Throwable)exception);
        }
    }

    public IPageTask getNextPageTask() {
        return this.m_taskAnalyzer.getNextPageTask();
    }

    public void notifyPageTaskFinished(IPageTask iPageTask) {
        this.m_taskAnalyzer.notifyPageTaskFinished(iPageTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPageTaskWorkerFinished(int n) {
        this.m_busyWorkerCounter.minus(1);
        this.m_laborResourceMgr.releaseLabor(1, this.m_nPriority);
        IClearable iClearable = this;
        synchronized (iClearable) {
            --this.m_nLaborsApplied;
        }
        if (n == 9) {
            this.m_nResult = 9;
            this.cancel();
        } else {
            if (n == 6 && !this.m_bHasWarnings) {
                this.m_bHasWarnings = true;
            }
            if (this.m_busyWorkerCounter.value() <= 0) {
                iClearable = this.m_busyWorkerCounter;
                synchronized (iClearable) {
                    this.m_busyWorkerCounter.notifyAll();
                    logger.debug((Object)"m_busyWorkerCounter.notifyAll");
                }
                iClearable = this.m_laborResourceMgr;
                synchronized (iClearable) {
                    this.m_laborResourceMgr.notifyAll();
                    logger.debug((Object)"m_laborResourceMgr.notifyAll");
                }
            }
        }
        logger.debug((Object)("TaskId=" + this.m_task.getId() + ", Result=" + n + "->" + this.m_nResult + ", busyWorkerCount=" + this.m_busyWorkerCounter.value()));
    }

    private static String[] getTaskPreviewURL(PublishTask publishTask) throws WCMException {
        String[] stringArray;
        block6: {
            PublishPathCompass publishPathCompass;
            IPublishFolder iPublishFolder;
            block5: {
                iPublishFolder = publishTask.getFolder();
                if (iPublishFolder == null) {
                    throw new WCMException(200006, "Publish folder is not found: Type=" + publishTask.getFolderType() + ", Id=" + publishTask.getFolderId());
                }
                stringArray = null;
                publishPathCompass = new PublishPathCompass();
                if (!publishTask.isPublishContent()) break block5;
                IPublishElements iPublishElements = publishTask.getContents();
                if (iPublishElements == null) break block6;
                stringArray = new String[iPublishElements.size()];
                int n = iPublishElements.size();
                for (int i = 0; i < n; ++i) {
                    IPublishContent iPublishContent = (IPublishContent)iPublishElements.get(i);
                    if (iPublishContent == null) continue;
                    iPublishContent.setFolder(iPublishFolder);
                    stringArray[i] = publishPathCompass.getPublishHttpUrl(iPublishContent, 0);
                }
                break block6;
            }
            Templates templates = iPublishFolder.getOutlineTemplates();
            if (templates == null || templates.isEmpty()) {
                throw new WCMException(230, "Outline templates required for current folder: " + iPublishFolder.getInfo());
            }
            stringArray = new String[templates.size()];
            TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            int n = templates.size();
            for (int i = 0; i < n; ++i) {
                String string;
                Template template = (Template)templates.getAt(i);
                String string2 = template.getOutputFileName();
                if (!template.equals(templateEmployMgr.getDefaultOutlineTemplate(iPublishFolder)) && !"true".equals((string = ConfigServer.getServer().getSysConfigValue("NAME_BY_TEMPLATE_FILE", "false")).toLowerCase())) {
                    string2 = string2 + "_" + template.getId();
                }
                stringArray[i] = publishPathCompass.getPublishHttpPath(iPublishFolder) + string2 + '.' + template.getOutputFileExt();
            }
        }
        return stringArray;
    }

    public void log2Monitor(String string) {
        if (this.m_oProgressMonitor != null) {
            this.m_oProgressMonitor.info(string);
        }
    }

    private IPublishProgressMonitor newProgressMonitor() {
        return new ProgressMonitorImpl();
    }

    public IPublishProgressMonitor getProgressMonitor() {
        return this.m_oProgressMonitor;
    }

    public Iterator allProgressMonitor() {
        Iterator iterator = new Iterator(){
            private int m_iIndex = -1;

            public boolean hasNext() {
                return this.m_iIndex < PublishTaskWorker.this.m_nWorkersCreated;
            }

            public Object next() {
                if (this.m_iIndex < PublishTaskWorker.this.m_nWorkersCreated) {
                    IPublishProgressMonitor iPublishProgressMonitor = null;
                    iPublishProgressMonitor = this.m_iIndex < 0 ? PublishTaskWorker.this.m_oProgressMonitor : PublishTaskWorker.this.m_workers[this.m_iIndex].getProgressMonitor();
                    ++this.m_iIndex;
                    return iPublishProgressMonitor;
                }
                return null;
            }

            public void remove() {
            }
        };
        return iterator;
    }

    public int getDetailPageCount() {
        return this.m_taskContext == null ? 0 : this.m_taskContext.getDetailPageCount();
    }

    public int getOutlinePageCount() {
        return this.m_taskContext == null ? 0 : this.m_taskContext.getOutlinePageCount();
    }

    public String getName() {
        return this.m_sWorkerName;
    }

    public void start() {
        if (!this.m_zStarted) {
            new Thread(this).start();
            this.m_zStarted = true;
        }
    }
}

