/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.DreamFactory;
import com.trs.cluster.ClusterConfigHelper;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.config.persistent.LaborResourceConfig;
import com.trs.components.common.publish.domain.taskdispatch.ILaborResourceMgr;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskDispatcher;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskRuntime;
import com.trs.components.common.publish.domain.taskdispatch.PublishTaskWorker;
import com.trs.components.common.publish.domain.taskdispatch.ThreadPool;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTasks;
import com.trs.infra.I18NMessage;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.ContainerUtil;
import org.aton.container.IClearable;
import org.aton.container.IQueue;

public class PublishTaskDispatcherImpl
extends Thread
implements IPublishTaskDispatcher,
IClearable,
IObjectLCListenerOnAdd,
IObjectLCListenerOnDel {
    private static final boolean LOAD_UNFINISH_TASK = false;
    private Logger logger = Logger.getLogger((String)PublishTaskDispatcherImpl.class.getName());
    public static int RUN_INTERVAL = 100;
    private ThreadPool m_oThreadPool;
    private IPublishTaskMgr m_publishTaskMgr = null;
    private HashMap m_hTaskRecs = null;
    private HashMap m_hRunningWorkers = null;
    private IQueue m_waitingQueue = null;
    private ILaborResourceMgr m_laborResourceMgr = null;
    private boolean m_bEnabled = false;
    private boolean m_bRunning = false;
    private boolean m_bSlaveNode = false;

    public boolean isRunning() {
        return this.m_bRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Object object;
        if (this.m_bRunning) {
            throw new InternalError("Task dispatcher can not be cleared when running!");
        }
        if (this.m_waitingQueue != null) {
            object = this.m_waitingQueue;
            synchronized (object) {
                this.m_waitingQueue.notifyAll();
            }
            this.m_waitingQueue.clear();
        }
        if (this.m_laborResourceMgr != null) {
            object = this.m_laborResourceMgr;
            synchronized (object) {
                this.m_laborResourceMgr.notifyAll();
            }
            this.m_laborResourceMgr.clear();
        }
        if (this.m_hTaskRecs != null) {
            ContainerUtil.clearContainer((Map)this.m_hTaskRecs);
        }
        if (this.m_hRunningWorkers != null) {
            ContainerUtil.clearContainer((Map)this.m_hRunningWorkers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeDeadLock() {
        Object object;
        if (this.m_waitingQueue != null) {
            object = this.m_waitingQueue;
            synchronized (object) {
                this.m_waitingQueue.notifyAll();
            }
        }
        if (this.m_laborResourceMgr != null) {
            object = this.m_laborResourceMgr;
            synchronized (object) {
                this.m_laborResourceMgr.notifyAll();
            }
        }
    }

    public synchronized void startup() throws WCMException {
        if (this.m_bRunning) {
            return;
        }
        ClusterConfig clusterConfig = ClusterConfigHelper.getConfig();
        boolean bl = this.m_bSlaveNode = clusterConfig.isEnabled() && !clusterConfig.isMaster();
        if (this.m_bSlaveNode) {
            return;
        }
        try {
            if (this.m_hTaskRecs == null) {
                this.m_hTaskRecs = new HashMap();
            }
            if (this.m_hRunningWorkers == null) {
                this.m_hRunningWorkers = new HashMap();
            }
            if (this.m_waitingQueue == null) {
                this.m_waitingQueue = (IQueue)DreamFactory.createObjectById("IQueue.Publish");
            }
            LaborResourceConfig laborResourceConfig = PublishServerConfigMapper.getLaborResourceConfig();
            if (this.m_laborResourceMgr == null) {
                this.m_laborResourceMgr = (ILaborResourceMgr)DreamFactory.createObjectById("ILaborResourceMgr.Publish");
                this.m_laborResourceMgr.configure(laborResourceConfig);
            }
            if (this.m_oThreadPool == null) {
                this.m_oThreadPool = (ThreadPool)DreamFactory.createObjectById("PublishThreadPool");
                this.m_oThreadPool.startup(laborResourceConfig.getHighPriorityLaborsMax() + laborResourceConfig.getLowPriorityLaborsMax());
            }
            if (this.m_publishTaskMgr == null) {
                this.m_publishTaskMgr = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");
            }
            this.updateUnfinishedTasks();
            this.m_bEnabled = true;
            this.start();
            this.logger.info((Object)"Publish task dispatcher has been started!");
        }
        catch (Exception exception) {
            this.logger.error((Object)"Failed to startup the publish task dispatcher!", (Throwable)exception);
            throw new WCMException(1100, I18NMessage.get(PublishTaskDispatcherImpl.class, "PublishTaskDispatcherImpl.label1", "\u542f\u52a8\u53d1\u5e03\u4efb\u52a1\u8c03\u5ea6\u8005\u5931\u8d25"), exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadUnfinishedTasks() throws Exception {
        PublishTasks publishTasks = null;
        PublishTask publishTask = null;
        try {
            try {
                this.logger.debug((Object)"to load unfinished publish tasks...");
                publishTasks = this.m_publishTaskMgr.getUnfinishedTasks();
                for (int i = 0; i < publishTasks.size(); ++i) {
                    publishTask = (PublishTask)publishTasks.getAt(i);
                    this.pushTaskRec(publishTask);
                    this.logger.debug((Object)("OK to load unfinished publish task: [" + i + "] Id=" + publishTask.getId() + "; Title=" + publishTask.getTitle()));
                }
                this.logger.debug((Object)"All unfinished publish tasks have been loaded!");
            }
            catch (Exception exception) {
                throw new WCMException(1100, "Failed to load the unfinished publish tasks!", exception);
            }
            Object var5_5 = null;
            if (publishTasks == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (publishTasks == null) throw throwable;
            publishTasks.clear();
            throw throwable;
        }
        publishTasks.clear();
    }

    private void updateUnfinishedTasks() throws Exception {
        DBManager.getDBManager().sqlExecuteUpdate("update WCMPUBLISHTASK set TASKSTATUS=10 where TASKSTATUS<7");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.m_bRunning || this.m_bSlaveNode) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"to shutdown ...");
        }
        this.m_bEnabled = false;
        Object object = this.m_waitingQueue;
        synchronized (object) {
            this.m_waitingQueue.notifyAll();
        }
        object = this.m_laborResourceMgr;
        synchronized (object) {
            this.m_laborResourceMgr.notifyAll();
        }
        try {
            this.cancelAllRunningTasks();
        }
        catch (Exception exception) {
            this.logger.error((Object)"Failed to cancel all running tasks!", (Throwable)exception);
        }
        this.m_bRunning = false;
        this.clear();
        this.logger.info((Object)"Publish task dispatcher has been shut down.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        boolean bl = false;
        this.m_bRunning = true;
        try {
            ContextHelper.setLoginUser(User.getSystem());
            while (this.m_bEnabled) {
                Object object = this.m_waitingQueue;
                // MONITORENTER : object
                while (this.m_waitingQueue.isEmpty() && this.m_bEnabled) {
                    try {
                        this.m_waitingQueue.wait(400L);
                    }
                    catch (Exception exception) {
                        try {
                            Thread.sleep(RUN_INTERVAL);
                        }
                        catch (Exception exception2) {}
                    }
                }
                // MONITOREXIT : object
                if (!this.m_bEnabled) {
                    Object var9_11 = null;
                    this.m_bRunning = false;
                    return;
                }
                TTaskRec tTaskRec = this.popTaskRec();
                if (tTaskRec == null) continue;
                object = this.m_laborResourceMgr;
                // MONITORENTER : object
                while (this.m_bEnabled && this.m_laborResourceMgr.applyForLabor(1, tTaskRec.getPriority()) <= 0) {
                    try {
                        bl = true;
                        this.logger.debug((Object)"to wait for free labor ...");
                        this.m_laborResourceMgr.wait();
                        this.logger.debug((Object)"awaked by free labor.");
                    }
                    catch (Exception exception) {
                        try {
                            Thread.sleep(RUN_INTERVAL);
                        }
                        catch (Exception exception3) {}
                    }
                }
                // MONITOREXIT : object
                if (!this.m_bEnabled) {
                    Object var9_12 = null;
                    this.m_bRunning = false;
                    return;
                }
                if (bl) {
                    try {
                        this.logger.debug((Object)"System is overloaded. Let me have a rest.");
                        PublishTaskDispatcherImpl.sleep(RUN_INTERVAL);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bl = false;
                }
                if (!this.m_bEnabled) {
                    Object var9_13 = null;
                    this.m_bRunning = false;
                    return;
                }
                this.runTask(tTaskRec);
            }
            Object var9_14 = null;
            this.m_bRunning = false;
            return;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            this.m_bRunning = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushTaskRec(PublishTask publishTask) {
        Integer n = new Integer(publishTask.getId());
        HashMap hashMap = this.m_hTaskRecs;
        synchronized (hashMap) {
            this.m_hTaskRecs.put(n, new TTaskRec(publishTask));
        }
        hashMap = this.m_waitingQueue;
        synchronized (hashMap) {
            this.m_waitingQueue.push((Object)n);
            this.m_waitingQueue.notifyAll();
        }
        this.logger.debug((Object)("task[" + publishTask.getId() + "] is pushed into waiting queue(Total: " + this.m_waitingQueue.size() + ")"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TTaskRec popTaskRec() {
        IQueue iQueue = this.m_waitingQueue;
        synchronized (iQueue) {
            Object object = this.m_waitingQueue.pop();
            if (object == null) {
                return null;
            }
            return (TTaskRec)this.m_hTaskRecs.get(object);
        }
    }

    private void runTask(TTaskRec tTaskRec) {
        PublishTaskWorker publishTaskWorker = new PublishTaskWorker(this);
        publishTaskWorker.setTask(tTaskRec.task);
        if (!this.m_oThreadPool.runIt(publishTaskWorker)) {
            publishTaskWorker.start();
        }
        tTaskRec.worker = publishTaskWorker;
        this.logger.debug((Object)(": start to run task[" + tTaskRec.task.getId() + "]: " + tTaskRec.task.getDesc()));
    }

    private void cancelAllRunningTasks() {
        Iterator iterator = this.m_hTaskRecs.entrySet().iterator();
        while (iterator.hasNext()) {
            TTaskRec tTaskRec = (TTaskRec)iterator.next().getValue();
            PublishTaskWorker publishTaskWorker = tTaskRec.worker;
            if (publishTaskWorker == null) continue;
            publishTaskWorker.cancel();
        }
    }

    public void pushTask(PublishTask publishTask) {
        if (this.m_bSlaveNode) {
            return;
        }
        this.pushTaskRec(publishTask);
    }

    public boolean cancelTask(int n) throws WCMException {
        if (this.m_bSlaveNode) {
            try {
                IClusterMsgCenter iClusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
                iClusterMsgCenter.send(-1676813972, n, 3, null);
            }
            catch (Exception exception) {
                throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u6d88\u606f\u5931\u8d25\uff01", exception);
            }
            return true;
        }
        return this.cancelTask0(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelTask0(int n) throws WCMException {
        TTaskRec tTaskRec = null;
        Integer n2 = new Integer(n);
        try {
            Object object = this.m_hTaskRecs;
            synchronized (object) {
                tTaskRec = (TTaskRec)this.m_hTaskRecs.remove(n2);
            }
            if (tTaskRec == null) {
                return true;
            }
            object = tTaskRec.worker;
            if (object == null) {
                IQueue iQueue = this.m_waitingQueue;
                synchronized (iQueue) {
                    this.m_waitingQueue.remove((Object)n2);
                }
            } else {
                ((PublishTaskWorker)object).cancel();
            }
            tTaskRec = null;
            return true;
        }
        catch (Exception exception) {
            if (tTaskRec != null) {
                HashMap hashMap = this.m_hTaskRecs;
                synchronized (hashMap) {
                    this.m_hTaskRecs.put(n2, tTaskRec);
                }
            }
            throw new WCMException(225, I18NMessage.get(PublishTaskDispatcherImpl.class, "PublishTaskDispatcherImpl.label2", "\u53d6\u6d88\u53d1\u5e03\u4efb\u52a1[ID=") + n + I18NMessage.get(PublishTaskDispatcherImpl.class, "PublishTaskDispatcherImpl.label3", "]\u5931\u8d25"), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWorkerStartup(PublishTaskWorker publishTaskWorker) {
        if (publishTaskWorker == null) {
            return;
        }
        PublishTask publishTask = publishTaskWorker.getTask();
        if (publishTask == null) {
            return;
        }
        if (publishTask.getId() <= 0) {
            return;
        }
        PublishTaskDispatcherImpl publishTaskDispatcherImpl = this;
        synchronized (publishTaskDispatcherImpl) {
            this.m_hRunningWorkers.put(new Integer(publishTask.getId()), publishTaskWorker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWorkerCleanup(PublishTaskWorker publishTaskWorker) {
        if (publishTaskWorker == null) {
            return;
        }
        PublishTask publishTask = publishTaskWorker.getTask();
        if (publishTask == null) {
            return;
        }
        if (publishTask.getId() <= 0) {
            return;
        }
        Integer n = new Integer(publishTask.getId());
        Object object = this;
        synchronized (object) {
            this.m_hRunningWorkers.remove(n);
        }
        object = this.m_hTaskRecs;
        synchronized (object) {
            this.m_hTaskRecs.remove(n);
        }
    }

    public PublishTaskWorker getRunningWorker(int n) {
        if (this.m_bSlaveNode) {
            return null;
        }
        return (PublishTaskWorker)this.m_hRunningWorkers.get(new Integer(n));
    }

    public Iterator getRunningMonitors(int n) {
        PublishTaskWorker publishTaskWorker = this.getRunningWorker(n);
        if (publishTaskWorker != null) {
            return publishTaskWorker.allProgressMonitor();
        }
        return null;
    }

    public PublishTask getRunningTask(int n) {
        return null;
    }

    public Iterator getRunningTasks() {
        return null;
    }

    public PublishTaskRuntime getTaskRuntime(int n) {
        return null;
    }

    public boolean pauseTask(int n) throws WCMException {
        return false;
    }

    public boolean resumeTask(int n) throws WCMException {
        return false;
    }

    public boolean changeTaskPriority(int n, int n2) {
        return false;
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        this.pushTask((PublishTask)baseObj);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!this.m_bSlaveNode) {
            this.cancelTask0(baseObj.getId());
        }
    }

    private class TTaskRec
    implements IClearable {
        public PublishTask task;
        public PublishTaskWorker worker;

        public TTaskRec(PublishTask publishTask, PublishTaskWorker publishTaskWorker) {
            this.task = publishTask;
            this.worker = publishTaskWorker;
        }

        public TTaskRec(PublishTask publishTask) {
            this.task = publishTask;
            this.worker = null;
        }

        public int getPriority() {
            return this.task.getPriority();
        }

        public void clear() {
            this.task = null;
            this.worker = null;
        }
    }
}

