/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.LoopException;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TagParserNestedTemplate
implements ITagParser {
    private TagItem m_tagItem = null;
    private static TagBeanInfo s_TagBeanInfo = null;

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tagBeanAttrInfo = null;
            TBI tBI = new TBI();
            tBI.setName("TRS_TEMPLATE");
            tBI.setDesc("TRS_TEMPLATE");
            tBI.setType(TagBeanInfo.BodyType.IGNORE);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("TEMPNAME");
            tagBeanAttrInfo.setDesc(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label8", "\u88ab\u5d4c\u5957\u6a21\u677f\u7684\u540d\u79f0(TEMPNAME)"));
            tagBeanAttrInfo.setRequired(true);
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("IDENTITY");
            tagBeanAttrInfo.setDesc(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label9", "\u88ab\u5d4c\u5957\u7684\u6a21\u677f\u5728\u4e3b\u6a21\u677f\u4e2d\u552f\u4e00\u6807\u8bc6(IDENTITY)"));
            tagBeanAttrInfo.setRequired(false);
            tagBeanAttrInfo.setVariable(false);
            tagBeanAttrInfo.setType(TagBeanAttrInfo.Type.STRING);
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    public void setTagItem(TagItem tagItem) {
        this.m_tagItem = tagItem;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    public TemplateQuote[] analyzeQuotes(IPublishFolder iPublishFolder) {
        return null;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        int n = 8;
        ArrayList<String> arrayList = (ArrayList<String>)ContextParameters.get(n, true);
        if (arrayList == null) {
            arrayList = new ArrayList<String>(4);
            ContextParameters.set(n, arrayList);
        }
        try {
            Template template = TagParseHelper.findNestedTemplate(publishTagContext);
            TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            if (arrayList.contains(template.getName())) {
                throw new WCMException(220, I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label10", "\u5d4c\u5957\u6a21\u677f\u5b58\u5728\u5d4c\u5957\u73af\u8def\uff01"));
            }
            arrayList.add(template.getName());
            TagDocument tagDocument = templateParseMgr.parse(template);
            if (tagDocument == null || tagDocument.getItemCount() == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            publishTagContext.setPrefixOfArgument(publishTagContext.getAttribute("IDENTITY"));
            String[] stringArray = TagParseHelper.parseItems(tagDocument.getItems(), publishTagContext);
            publishTagContext.setPrefixOfArgument(null);
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label11", "\u89e3\u6790\u5d4c\u5957\u7f6e\u6807\u5931\u8d25\uff01\u5d4c\u5957\u7f6e\u6807\u5185\u5bb9\u4e3a: ") + this.m_tagItem.toString(), exception);
        }
        finally {
            arrayList.clear();
            arrayList = null;
            ContextParameters.get(n);
        }
    }

    private class TBI
    extends TagBeanInfo {
        private TBI() {
        }

        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer) {
            this.checkSemantic(iPublishFolder, tagItem, stringBuffer, null);
        }

        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer, String string) {
            String string2 = tagItem.getAttribute("TEMPNAME");
            if (TagItem.isVariableParameter(string2)) {
                return;
            }
            try {
                TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
                Template template = templateCacheMgr.lookupByName(iPublishFolder, string2);
                if (template == null) {
                    stringBuffer.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label1", "\u7f6e\u6807"));
                    stringBuffer.append(tagItem.getDescWithPos());
                    stringBuffer.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label2", "\u6307\u5b9a\u7684\u5d4c\u5957\u6a21\u677f["));
                    stringBuffer.append(string2);
                    stringBuffer.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label3", "]\u4e0d\u5b58\u5728\n"));
                    return;
                }
                ArrayList arrayList = new ArrayList(3);
                try {
                    this.checkNested(template, arrayList, templateCacheMgr, iPublishFolder);
                }
                catch (LoopException loopException) {
                    stringBuffer.append(CMyString.format(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label12", "\u7f6e\u6807{0}\u6307\u5b9a\u7684\u5d4c\u5957\u6a21\u677f[{1}]\u4e0e\u5176\u5b83\u6a21\u677f\u95f4\u5b58\u5728\u5d4c\u5957\u73af\u8def.\n"), new String[]{tagItem.getDescWithPos(), string2}));
                    stringBuffer.append(tagItem).append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label5", "\u73af\u8def\u4e3a\uff1a"));
                    stringBuffer.append(arrayList);
                    return;
                }
                catch (Exception exception) {
                    stringBuffer.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label1", "\u7f6e\u6807"));
                    stringBuffer.append(tagItem.getDescWithPos());
                    stringBuffer.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label2", "\u6307\u5b9a\u7684\u5d4c\u5957\u6a21\u677f["));
                    stringBuffer.append(string2);
                    stringBuffer.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label6", "]\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff01\n"));
                    stringBuffer.append(exception.getMessage());
                    stringBuffer.append(tagItem);
                    return;
                }
                arrayList.clear();
            }
            catch (Exception exception) {
                stringBuffer.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label1", "\u7f6e\u6807"));
                stringBuffer.append(tagItem.getDescWithPos());
                stringBuffer.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label2", "\u6307\u5b9a\u7684\u5d4c\u5957\u6a21\u677f["));
                stringBuffer.append(string2);
                stringBuffer.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label7", "]\u67e5\u627e\u51fa\u9519:"));
                stringBuffer.append(exception.getMessage());
                stringBuffer.append("\n");
            }
        }

        private void checkNested(Template template, List list, TemplateCacheMgr templateCacheMgr, IPublishFolder iPublishFolder) throws Exception {
            list.add(template.getName());
            TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            TagDocument tagDocument = templateParseMgr.parse(template);
            Iterator iterator = tagDocument.findItems("TRS_TEMPLATE");
            TagItem tagItem = null;
            String string = null;
            while (iterator.hasNext()) {
                tagItem = (TagItem)iterator.next();
                string = tagItem.getAttribute("TEMPNAME");
                if (list.indexOf(string) != -1) {
                    list.add(string);
                    throw new LoopException();
                }
                template = templateCacheMgr.lookupByName(iPublishFolder, string);
                if (template == null) continue;
                this.checkNested(template, list, templateCacheMgr, iPublishFolder);
            }
            list.remove(list.size() - 1);
        }
    }
}

