/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.tagparser.WCMTagParserDocument;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TagParserDetailPages
extends BaseTagParser4List {
    private static final String DETAIL_PAGENAME = "__DETAIL_PAGENAME__";
    private static TagBeanInfo s_TagBeanInfo = null;
    protected TagItem m_tagItem;
    Logger m_logger = Logger.getLogger(TagParserDetailPages.class);

    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TBI tBI = new TBI();
            tBI.setName("TRS_DetailPages");
            tBI.setDesc("TRS_DetailPages");
            TagBeanAttrInfo tagBeanAttrInfo = new TagBeanAttrInfo();
            tagBeanAttrInfo.setName("jslinked");
            tagBeanAttrInfo.setDesc("\u662f\u5426\u4f7f\u7528JS\u8df3\u8f6c\u5206\u9875");
            tagBeanAttrInfo.setRequired(false);
            tBI.addAttrInfo(tagBeanAttrInfo);
            s_TagBeanInfo = tBI;
        }
        return s_TagBeanInfo;
    }

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        String[] stringArray = super.parse(publishTagContext);
        if (publishTagContext.getAttribute("jslinked", false) && stringArray != null && stringArray.length == 1) {
            String string = publishTagContext.getPageContext().getExtraAttribute(DETAIL_PAGENAME);
            stringArray[0] = stringArray[0] + this.makeGotoPage(string);
        }
        return stringArray;
    }

    private String makeGotoPage(String string) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<script>");
        stringBuffer.append("function gotoPage(_pageIndex){");
        stringBuffer.append("if(_pageIndex==${PAGE_INDEX}){return false;}");
        stringBuffer.append("var sUrl=(_pageIndex==0)?'");
        stringBuffer.append(string);
        stringBuffer.append("':'");
        int n = string.lastIndexOf(46);
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append("_'+_pageIndex+'");
        stringBuffer.append(string.substring(n));
        stringBuffer.append("';");
        stringBuffer.append("window.location.href=sUrl;return false;");
        stringBuffer.append("}");
        stringBuffer.append("</script>");
        return stringBuffer.toString();
    }

    protected CMSBaseObjs findObjects(PublishTagContext publishTagContext) throws WCMException {
        CMSObj cMSObj = this.findHost(publishTagContext);
        if (!(cMSObj instanceof Document)) {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(this.m_tagItem.getDescWithPos()).append(I18NMessage.get(WCMTagParserDocument.class, "TagParserDetailPages.label1", "\u7f6e\u6807\u4f7f\u7528\u7684\u573a\u666f\u4e0d\u5bf9,"));
            publishTagContext.addWarning(stringBuffer.toString());
            return new DefaultObjs(null);
        }
        Document document = (Document)cMSObj;
        String[] stringArray = this.separatePages(publishTagContext, document.getHtmlContent());
        if (stringArray == null || stringArray.length == 0) {
            return new DefaultObjs(null);
        }
        IPublishContent iPublishContent = (IPublishContent)publishTagContext.getUpperHost();
        String string = publishTagContext.getPathCompass().getHttpUrl(iPublishContent, 0);
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        publishTagContext.getPageContext().setExtraAttribute(DETAIL_PAGENAME, string2);
        boolean bl = publishTagContext.getAttribute("jslinked", false);
        DefaultObjs defaultObjs = new DefaultObjs(null, stringArray.length, 1);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            DefaultObj defaultObj = new DefaultObj();
            defaultObj.setProperty("Title", stringArray[i], false);
            defaultObj.setProperty("_RECURL", this.makeUrl(string2, i, bl), false);
            defaultObj.setId(1000 + i);
            defaultObj.setAddMode(false);
            defaultObjs.addElement(defaultObj);
        }
        return defaultObjs;
    }

    private Object makeUrl(String string, int n, boolean bl) {
        if (bl) {
            return "javascript:return gotoPage(" + n + ");";
        }
        if (n == 0) {
            return string;
        }
        int n2 = string.lastIndexOf(46);
        return string.substring(0, n2) + '_' + n + string.substring(n2);
    }

    public String[] separatePages(PublishTagContext publishTagContext, String string) {
        if (CMyString.isEmpty(string)) {
            return new String[0];
        }
        HtmlElementFinder htmlElementFinder = new HtmlElementFinder(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        HtmlElement htmlElement = null;
        boolean bl = true;
        while ((htmlElement = htmlElementFinder.findNextElement("TRS_PAGE_SEPARATOR", true)) != null) {
            if (bl) {
                bl = false;
                arrayList.add(CMyString.showEmpty(htmlElement.getAttributeValue("firstPageTitle")));
            }
            arrayList.add(CMyString.showEmpty(htmlElement.getAttributeValue("pageTitle")));
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    protected boolean isValidate(PublishTagContext publishTagContext) throws WCMException {
        return true;
    }

    protected CMSObj findHost(PublishTagContext publishTagContext) throws WCMException {
        IPublishElement iPublishElement = publishTagContext.getUpperHost();
        if (iPublishElement == null) {
            throw new WCMException(234, "Upper host object required in tag context!");
        }
        return iPublishElement.getSubstance();
    }

    private class TBI
    extends TagBeanInfo {
        private TBI() {
        }

        public void checkSemantic(IPublishFolder iPublishFolder, TagItem tagItem, StringBuffer stringBuffer) {
        }
    }
}

