/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.html.HtmlUtil;

public abstract class BaseTagParser4List
extends BaseTagParser
implements ITagParser4List {
    protected IPublishFolder m_oCurrFolder;
    private IPublishElements m_contents;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;

    protected abstract CMSBaseObjs findObjects(PublishTagContext var1) throws WCMException;

    protected abstract boolean isValidate(PublishTagContext var1) throws WCMException;

    public String[] parse(PublishTagContext publishTagContext) throws WCMException {
        String string;
        if (!publishTagContext.getTagItem().hasChildren()) {
            return null;
        }
        if (!this.isValidate(publishTagContext)) {
            return null;
        }
        CMSBaseObjs cMSBaseObjs = this.findObjects(publishTagContext);
        this.m_contents = PublishElementFactory.makeElementsFrom(cMSBaseObjs);
        this.m_nextRecordContext = new PublishTagContext(publishTagContext, publishTagContext.getTagItem(), this);
        String[] stringArray = TagParseHelper.parse4List(publishTagContext.getTagItem(), publishTagContext, this);
        if (stringArray != null && stringArray.length == 1 && publishTagContext.getAttribute("AUTOMORE", false) && (string = this.parseAutoMore(this.m_oCurrFolder, publishTagContext)) != null) {
            stringArray[0] = stringArray[0] + string;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseAutoMore(IPublishFolder iPublishFolder, PublishTagContext publishTagContext) throws WCMException {
        String string = publishTagContext.getAttribute("BEGINMORE");
        String string2 = publishTagContext.getAttribute("ENDMORE");
        String string3 = publishTagContext.getAttribute("MORETEXT");
        String string4 = publishTagContext.getAttribute("MORETARGET");
        String string5 = publishTagContext.getAttribute("MOREEXTRA");
        if (string3 == null || (string3 = string3.trim()).length() == 0) {
            string3 = I18NMessage.get(BaseTagParser4List.class, "BaseTagParser4List.label1", "\u66f4\u591a\u5185\u5bb9...");
        }
        if (string4 == null || (string4 = string4.trim()).length() == 0) {
            string4 = "_blank";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string6 = publishTagContext.getPathCompass().getAbsoluteHttpPath(iPublishFolder);
            string6 = HtmlUtil.calRelativePath(string6, publishTagContext.getPageHttpPath());
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append("<A href=\"").append(string6);
            stringBuffer.append("\" target=\"").append(string4).append("\" ");
            if (string5 != null) {
                stringBuffer.append(string5);
            }
            stringBuffer.append('>').append(string3).append("</A>");
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
            }
            String string7 = stringBuffer.toString();
            return string7;
        }
        finally {
            stringBuffer.setLength(0);
        }
    }

    public int getRecordSize() {
        return this.getObjectsSize();
    }

    private int getObjectsSize() {
        if (this.m_contents == null) {
            return 0;
        }
        return this.m_contents.size();
    }

    public void setStartPos(int n) {
        this.m_nCurrPos = n;
    }

    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            IPublishElement iPublishElement = this.m_contents.get(this.m_nCurrPos++);
            int n = this.m_contents.size();
            while (iPublishElement == null && this.m_nCurrPos < n) {
                iPublishElement = this.m_contents.get(this.m_nCurrPos++);
            }
            if (iPublishElement == null) {
                return null;
            }
            if (iPublishElement instanceof IPublishContent) {
                IPublishContent iPublishContent = (IPublishContent)iPublishElement;
                iPublishContent.setFolder(this.m_oCurrFolder);
            }
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(iPublishElement);
            return this.m_nextRecordContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }

    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    public PublishTagContext substantiateContext(PublishTagContext publishTagContext) throws WCMException {
        try {
            IPublishElement iPublishElement = this.m_contents.get(this.m_nCurrPos++);
            if (iPublishElement == null) {
                return this.substantiateContext(publishTagContext);
            }
            if (iPublishElement instanceof IPublishContent) {
                IPublishContent iPublishContent = (IPublishContent)iPublishElement;
                iPublishContent.setFolder(this.m_oCurrFolder);
            }
            publishTagContext.setSequenceNumber(this.m_nCurrNumber++);
            publishTagContext.setUpperHost(iPublishElement);
            return publishTagContext;
        }
        catch (Exception exception) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, exception);
        }
    }
}

