/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.DreamFactory;
import com.trs.components.common.publish.OrignHomePublishException;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.IPublishEventServer;
import com.trs.components.common.publish.domain.publisher.PageNavHelper;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsListImpl;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PageGenerator {
    private static final int RETRYTIMES_ON_WRITEFILE_ERROR = 5;
    private static Logger s_logger = Logger.getLogger(PageGenerator.class);
    private static final HashMap m_oGenerating = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] generateOutlines(PublishPageContext publishPageContext) throws WCMException {
        IPublishFolder iPublishFolder = (IPublishFolder)publishPageContext.getPageElement();
        if (iPublishFolder.isLink()) {
            String[] stringArray = new String[]{iPublishFolder.getLinkUrl()};
            return stringArray;
        }
        Templates templates = null;
        if (publishPageContext.getTemplate() != null) {
            templates = new Templates(null);
            templates.addElement(publishPageContext.getTemplate());
        } else {
            templates = iPublishFolder.getOutlineTemplates();
            if (templates == null || templates.isEmpty()) {
                throw new WCMDatainvalidException(230, iPublishFolder.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label1", "]\u9700\u8981\u8bbe\u5b9a\u6982\u89c8\u6a21\u677f"));
            }
        }
        publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label2", "\u751f\u6210\u6982\u89c8\u6587\u4ef6:") + iPublishFolder.getInfo());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            if (template == null) {
                s_logger.error((Object)("Get template #[" + i + "] failed."));
                continue;
            }
            String string = PageGenerator.generatePage(publishPageContext, template);
            if (string != null) {
                arrayList.add(string);
                continue;
            }
            s_logger.error((Object)("Generate page for template [" + template + "] failed."));
        }
        try {
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            arrayList.clear();
        }
    }

    public static String generateDetail(PublishPageContext publishPageContext) throws Exception {
        IPublishContent iPublishContent = (IPublishContent)publishPageContext.getPageElement();
        IPublishFolder iPublishFolder = iPublishContent.getFolder();
        if (iPublishFolder == null) {
            throw new WCMException(10, "FolderTypeConfig of current content to publish required (plz call IPublishContent.setFolder())!");
        }
        String string = null;
        string = iPublishContent.getModal() == 2 ? PageGenerator.generateDetailOfLinkModalContent(publishPageContext, iPublishContent, iPublishFolder) : PageGenerator.generateDetailOfNotLinkCotent(publishPageContext, iPublishContent, iPublishFolder);
        if (!publishPageContext.isPreview()) {
            s_logger.debug((Object)("update status of " + iPublishContent + "..."));
            String string2 = publishPageContext.getPageHttpURL();
            iPublishContent.setPublishTimeAndURL(CMyDateTime.now(), string2);
            PageGenerator.updateContentStatus(iPublishContent, publishPageContext);
            if (iPublishContent.getModal() == 1) {
                IPublishEventServer iPublishEventServer = (IPublishEventServer)DreamFactory.createObjectById("IPublishEventServer");
                iPublishEventServer.onSuccess(iPublishContent, string2, publishPageContext);
            }
        }
        return string;
    }

    private static String generateDetailOfNotLinkCotent(PublishPageContext publishPageContext, IPublishContent iPublishContent, IPublishFolder iPublishFolder) throws Exception {
        boolean bl = publishPageContext.isPreview();
        if (iPublishContent.isLink()) {
            if (bl) {
                return iPublishContent.getLinkUrl();
            }
            publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label3", "\u5728[") + iPublishFolder.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label4", "]\u4e2d\u94fe\u63a5\u6587\u6863[") + iPublishContent.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label5", "]\u6570\u636e\u751f\u6210\u5b8c\u6210\uff01"));
            return null;
        }
        if (iPublishContent.isFile()) {
            String string = PageGenerator.publishDocFile(publishPageContext);
            if (bl) {
                return string;
            }
            publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label3", "\u5728[") + iPublishFolder.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label6", "]\u4e2d\u5916\u90e8\u6587\u4ef6[") + iPublishContent.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label5", "]\u6570\u636e\u751f\u6210\u5b8c\u6210\uff01"));
            return null;
        }
        Template template = null;
        if (publishPageContext.isPreview()) {
            template = publishPageContext.getTemplate();
            if (template == null) {
                template = iPublishContent.getDetailTemplate();
            }
        } else {
            template = iPublishContent.getDetailTemplate();
            if (template == null) {
                template = publishPageContext.getTemplate();
            }
        }
        if (template == null) {
            throw new WCMException(iPublishContent.getSubstance() + I18NMessage.get(PageGenerator.class, "PageGenerator.label7", "\u6ca1\u6709\u8bbe\u7f6e\u7ec6\u89c8\u6a21\u677f\uff01"));
        }
        publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label8", "\u751f\u6210\u7ec6\u89c8\u6587\u4ef6:") + iPublishContent.getInfo());
        return PageGenerator.generatePage(publishPageContext, template);
    }

    private static String generateDetailOfLinkModalContent(PublishPageContext publishPageContext, IPublishContent iPublishContent, IPublishFolder iPublishFolder) throws Exception {
        boolean bl = publishPageContext.isPreview();
        if (PublishServerConfigMapper.isAutoPublishDocInHomeWhenNeeded() && (bl || !iPublishContent.isPublishedInHome())) {
            IPublishFolder iPublishFolder2 = iPublishContent.getFolder();
            iPublishContent.setFolder(iPublishContent.getOriginalHome());
            try {
                if (bl) {
                    iPublishContent.validateCanDoPreview();
                } else {
                    iPublishContent.validateCanDoPub();
                }
            }
            catch (Throwable throwable) {
                throw new OrignHomePublishException(I18NMessage.get(PageGenerator.class, "PageGenerator.label9", "\u539f\u59cb\u6587\u6863[") + iPublishContent.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label10", "]\u4e0d\u80fd\u6b63\u5e38\u53d1\u5e03\u5bfc\u81f4\u5728\u680f\u76ee[[") + iPublishFolder2.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label11", "]]\u4e2d\u7684\u5f15\u7528\u53d1\u5e03\u5931\u8d25\uff01"), throwable);
            }
            PublishPageContext publishPageContext2 = new PublishPageContext(iPublishContent, publishPageContext.getTaskContext(), publishPageContext.getProgressMonitor());
            publishPageContext2.setRoot(iPublishContent.getOriginalHome().getRoot());
            try {
                publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label12", "\u89e6\u53d1\u53d1\u5e03\u7ec6\u89c8:") + iPublishContent.getInfo());
                String string = PageGenerator.generateDetail(publishPageContext2);
                iPublishContent.setFolder(iPublishFolder2);
                String string2 = string;
                return string2;
            }
            catch (Exception exception) {
                throw new WCMException(220, "Failed to generate the content detail page in its home folder!", exception);
            }
            finally {
                publishPageContext2.clear();
            }
        }
        if (bl) {
            return publishPageContext.getPathCompass().getPreviewHttpUrl(iPublishContent, 0);
        }
        publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label3", "\u5728[") + iPublishFolder.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label13", "]\u4e2d\u94fe\u63a5\u5f15\u7528[") + iPublishContent.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label5", "]\u6570\u636e\u751f\u6210\u5b8c\u6210\uff01"));
        return null;
    }

    private static void updateContentStatus(IPublishContent iPublishContent, PublishPageContext publishPageContext) throws WCMException, Exception {
        iPublishContent.setPublishStatus(50);
        PublishTask publishTask = publishPageContext.getTaskContext().getTask();
        if (publishTask.getPublishType() != 10) {
            return;
        }
        if (iPublishContent.getModal() != 1) {
            return;
        }
        PublishElementsListImpl publishElementsListImpl = new PublishElementsListImpl();
        if (iPublishContent.getType() == 605) {
            PageGenerator.makeFoldersUseContent(iPublishContent, publishElementsListImpl);
            for (int i = publishElementsListImpl.size() - 1; i >= 0; --i) {
                IPublishFolder iPublishFolder = (IPublishFolder)publishElementsListImpl.get(i);
                IPublishContent iPublishContent2 = PublishElementFactory.makeContentFrom(iPublishContent.getSubstance(), iPublishFolder);
                if (iPublishContent2.getModal() != 2) continue;
                iPublishContent2.setPublishStatus(50);
            }
        }
    }

    private static void makeFoldersUseContent(IPublishContent iPublishContent, IPublishElements iPublishElements) throws WCMException, Exception {
        Document document = (Document)iPublishContent.getSubstance();
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Channels channels = documentMgr.getChannels(document, 0, null);
        int n = channels.size();
        for (int i = 0; i < n; ++i) {
            IPublishFolder iPublishFolder;
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || !(iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel)).canDoOutlinePageTask()) continue;
            iPublishElements.add(iPublishFolder);
        }
    }

    public static String generatePage(PublishPageContext publishPageContext, Template template) throws WCMException {
        return PageGenerator.generatePage(publishPageContext, template, false);
    }

    public static String generatePage(PublishPageContext publishPageContext, Template template, boolean bl) throws WCMException {
        if (template == null) {
            throw new WCMException(I18NMessage.get(PageGenerator.class, "PageGenerator.label14", "\u6ca1\u6709\u6307\u5b9a\u6a21\u677f\uff01"));
        }
        HashMap<String, String> hashMap = null;
        try {
            TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label15", "\u89e3\u6790\u6a21\u677f:") + template.getInfo());
            TagDocument tagDocument = templateParseMgr.parse(template);
            if (tagDocument == null) {
                s_logger.fatal((Object)("Parse _template[" + template + "]failed"));
                String string = null;
                return string;
            }
            IPublishElement iPublishElement = publishPageContext.getPageElement();
            PublishTagContext publishTagContext = new PublishTagContext(publishPageContext);
            publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label16", "\u5e94\u7528\u6a21\u677f\u751f\u6210\u6587\u4ef6"));
            boolean bl2 = false;
            if (publishPageContext.getTemplate() == null && template != null) {
                publishPageContext.setTemplate(template);
                bl2 = true;
            }
            String[] stringArray = TagParseHelper.parseItems(tagDocument.getItems(), publishTagContext);
            if (bl2) {
                publishPageContext.setTemplate(null);
            }
            if (stringArray == null) {
                s_logger.fatal((Object)("Parse _template[" + template + "]failed"));
                String string = null;
                return string;
            }
            boolean bl3 = publishPageContext.isPreview();
            PublishPathCompass publishPathCompass = publishPageContext.getPathCompass();
            String string = publishPathCompass.getRootHttpPathFrom(iPublishElement);
            String string2 = iPublishElement.getEncoding();
            String string3 = publishPathCompass.getLocalPath(iPublishElement, bl3);
            PublishSyncGlobalTuner.insureLocalPathExists(string3);
            String string4 = null;
            String string5 = template.getOutputFileExt();
            String string6 = null;
            String string7 = null;
            FileDistributeShip fileDistributeShip = null;
            String string8 = null;
            TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            boolean bl4 = ConfigServer.getServer().getSysConfigValue("NAME_BY_TEMPLATE_FILE", "false").equalsIgnoreCase("true");
            boolean bl5 = "true".equalsIgnoreCase(publishPageContext.getExtraAttribute("OnlyTemplateName"));
            List list = null;
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl6;
                String string9;
                if (iPublishElement.isFolder()) {
                    if (string4 == null) {
                        string4 = template.getOutputFileName();
                        if (!(bl5 || bl4 || template.equals(templateEmployMgr.getDefaultOutlineTemplate((IPublishFolder)iPublishElement)))) {
                            string4 = string4 + "_" + template.getId();
                        }
                    }
                    string6 = PublishPathCompass.makePageFileName(string4, string5, i);
                    publishPageContext.incOutlinePageCount();
                } else {
                    if (string4 == null) {
                        string4 = PublishPathCompass.makeDetailPageFileName((IPublishContent)iPublishElement);
                        if (bl) {
                            string9 = publishPageContext.getExtraAttribute("EXT");
                            if (string9 == null || "".equalsIgnoreCase(string9)) {
                                string9 = "ext";
                            } else if ("templateid".equalsIgnoreCase(string9)) {
                                string9 = template.getId() + "";
                            }
                            string4 = string4 + "_" + string9;
                        }
                        publishPageContext.setFileName(string4 + '.' + string5);
                    }
                    string6 = PublishPathCompass.makePageFileName(string4, string5, i);
                    publishPageContext.incDetailPageCount();
                }
                string7 = string3 + string6;
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>(6);
                    hashMap.put("ROOT_PATH", string);
                    hashMap.put("PAGE_COUNT", String.valueOf(stringArray.length));
                    hashMap.put("PAGE_NAME", string4);
                    hashMap.put("PAGE_EXT", string5);
                    hashMap.put("RECORD_COUNT", publishPageContext.getExtraAttribute("RECORD_COUNT"));
                    hashMap.put("TOTAL_COUNT", publishPageContext.getExtraAttribute("TOTAL_COUNT"));
                }
                hashMap.put("PAGE_INDEX", String.valueOf(i));
                string9 = publishPageContext.getExtraAttribute("NAV_SHOWWHENONEPAGE");
                boolean bl7 = bl6 = string9 == null ? true : string9.equalsIgnoreCase("true");
                if (bl6) {
                    hashMap.put("OUTLINE_NAV", PageNavHelper.makeNav(publishPageContext, string4, string5, stringArray.length, i));
                } else if (stringArray.length == 1) {
                    hashMap.put("OUTLINE_NAV", "");
                }
                if (list == null) {
                    list = PageGenerator.makeWmlImg(publishPageContext);
                }
                if (!list.isEmpty()) {
                    int n = i >= list.size() ? 0 : i;
                    hashMap.putAll((Map)list.get(n));
                }
                String string10 = CMyString.parsePageVariables(stringArray[i], hashMap);
                publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label17", "\u8f93\u51fa\u672c\u5730\u6587\u4ef6:") + string7);
                PageGenerator.generateFile(string7, string10, string2);
                if (!bl3) {
                    if (fileDistributeShip == null) {
                        fileDistributeShip = publishPageContext.getFileDistributeShip();
                    }
                    publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label18", "\u5206\u53d1\u6587\u4ef6:") + string7);
                    fileDistributeShip.distributeFile(string7, iPublishElement);
                }
                if (i != 0) continue;
                if (bl3) {
                    string8 = publishPathCompass.getPreviewHttpPath(iPublishElement) + string6;
                    string8 = string8 + "?randid=" + Math.random();
                    continue;
                }
                string8 = string7;
            }
            String string11 = string8;
            return string11;
        }
        catch (Exception exception) {
            throw new WCMException(237, I18NMessage.get(PageGenerator.class, "PageGenerator.label19", "\u751f\u6210'") + publishPageContext.getPageElement().getInfo() + "(Template[" + template.getId() + "]:" + template.getName() + I18NMessage.get(PageGenerator.class, "PageGenerator.label20", ")'\u7684\u6587\u4ef6\u5931\u8d25"), exception);
        }
        finally {
            if (hashMap != null) {
                hashMap.clear();
            }
        }
    }

    private static List makeWmlImg(PublishPageContext publishPageContext) {
        String string = publishPageContext.getExtraAttribute("PGVAR_WCMIMG");
        if (string == null) {
            return new ArrayList(0);
        }
        String[] stringArray = string.split("\\|");
        ArrayList arrayList = new ArrayList(stringArray.length);
        String[] stringArray2 = null;
        HashMap<String, String> hashMap = null;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray2 = stringArray[i].split(",");
            hashMap = new HashMap<String, String>(2);
            hashMap.put("PAGVAR_WMLIMG", stringArray2[0]);
            hashMap.put("PAGVAR_WMIMGDESC", stringArray2[1]);
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private static final String publishDocFile(PublishPageContext publishPageContext) throws WCMException {
        boolean bl = publishPageContext.isPreview();
        IPublishContent iPublishContent = (IPublishContent)publishPageContext.getPageElement();
        String string = iPublishContent.getFileName();
        if (string == null) {
            throw new WCMException(I18NMessage.get(PageGenerator.class, "PageGenerator.label21", "\u6587\u4ef6\u7c7b\u578b\u7684\u6587\u6863(") + iPublishContent.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label22", ")\u6ca1\u6709\u8bbe\u7f6e\u5916\u90e8\u6587\u4ef6."));
        }
        String string2 = FilesMan.getFilesMan().mapFilePath(string, 0);
        String string3 = string2 + string;
        if (!CMyFile.fileExists(string3)) {
            publishPageContext.addWarning(I18NMessage.get(PageGenerator.class, "PageGenerator.label24", "\u5916\u90e8\u6587\u4ef6"), iPublishContent.getId(), I18NMessage.get(PageGenerator.class, "PageGenerator.label25", "\u6ca1\u6709\u627e\u5230\u6587\u4ef6\u7c7b\u578b ") + iPublishContent.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label26", " \u7684\u5916\u90e8\u6587\u4ef6[") + string + "]");
            return null;
        }
        String string4 = publishPageContext.getPathCompass().getLocalPath(iPublishContent, bl);
        String string5 = string4 + string;
        PublishSyncGlobalTuner.insureLocalPathExists(string4);
        try {
            if (!CMyFile.fileExists(string5)) {
                CMyFile.copyFile(string3, string5);
            }
        }
        catch (CMyException cMyException) {
            throw new WCMException(I18NMessage.get(PageGenerator.class, "PageGenerator.label27", "\u62f7\u8d1d\u6587\u4ef6\u5931\u8d25\uff01") + string3 + "-->" + string5);
        }
        if (bl) {
            return publishPageContext.getPathCompass().getPreviewHttpPath(iPublishContent) + string;
        }
        publishPageContext.setFileName(string);
        publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label18", "\u5206\u53d1\u6587\u4ef6:") + string3);
        publishPageContext.getFileDistributeShip().distributeFile(string3, iPublishContent, null, true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void generateFile(String string, String string2, String string3) throws CMyException {
        if (!PageGenerator.testAndRegister(string)) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("File '" + string + "' generating."));
            }
            return;
        }
        CMyException cMyException = null;
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    CMyFile.writeFile(string, string2, string3);
                    cMyException = null;
                    break;
                }
                catch (CMyException cMyException2) {
                    cMyException = cMyException2;
                    s_logger.error((Object)("Failed to write file, retry: " + i), (Throwable)cMyException2);
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        finally {
            PageGenerator.unregister(string);
        }
        if (cMyException != null) {
            throw cMyException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean testAndRegister(String string) {
        if (string == null) {
            return false;
        }
        HashMap hashMap = m_oGenerating;
        synchronized (hashMap) {
            if (m_oGenerating.get(string) != null) {
                return false;
            }
            m_oGenerating.put(string, string);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized void unregister(String string) {
        if (string == null) {
            return;
        }
        HashMap hashMap = m_oGenerating;
        synchronized (hashMap) {
            m_oGenerating.remove(string);
        }
    }

    private PageGenerator() {
    }

    private static String getPageNavigator(int n, int n2, String string, String string2) {
        if (n2 <= 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<DIV style='display:none' id='idTRSNavigator' class='clsTRSNavigatorDIV'>");
        stringBuffer.append(PageGenerator.getListNavigator(n, n2, string, string2));
        stringBuffer.append("</DIV>");
        return stringBuffer.toString();
    }

    private static String getListNavigator(int n, int n2, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(255);
        if (n != 0) {
            stringBuffer.append("<A id='idTRSListLink' class='clsTRSListLink' href='");
            stringBuffer.append(PageGenerator.getSlaveFilePath(0, string, string2));
            stringBuffer.append("'>1</A>");
        } else {
            stringBuffer.append("1");
        }
        for (int i = 1; i < n2; ++i) {
            if (n != i) {
                stringBuffer.append(",<A id='idTRSListLink' class='idTRSListLink' href='");
                stringBuffer.append(PageGenerator.getSlaveFilePath(i, string, string2));
                stringBuffer.append("'>");
                stringBuffer.append(i + 1);
                stringBuffer.append("</A>");
                continue;
            }
            stringBuffer.append(",");
            stringBuffer.append(i + 1);
        }
        return stringBuffer.toString();
    }

    private static String getSlaveFilePath(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(255);
        stringBuffer.append(string);
        if (n != 0) {
            stringBuffer.append("_");
            stringBuffer.append(n);
        }
        stringBuffer.append(".");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static String[] generateContent(PublishPageContext publishPageContext, Template template) throws WCMException {
        try {
            TemplateParseMgr templateParseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label28", "\u89e3\u6790\u6a21\u7248:") + template.getInfo());
            TagDocument tagDocument = templateParseMgr.parse(template);
            if (tagDocument == null) {
                s_logger.fatal((Object)("Parse _template[" + template + "]failed"));
                return null;
            }
            PublishTagContext publishTagContext = new PublishTagContext(publishPageContext);
            publishPageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label29", "\u5e94\u7528\u6a21\u7248\u53d6\u5f97\u6587\u4ef6\u5185\u5bb9"));
            String[] stringArray = TagParseHelper.parseItems(tagDocument.getItems(), publishTagContext);
            if (stringArray == null) {
                s_logger.fatal((Object)("Parse _template[" + template + "]failed"));
                return null;
            }
            return stringArray;
        }
        catch (Exception exception) {
            throw new WCMException(237, I18NMessage.get(PageGenerator.class, "PageGenerator.label30", "\u83b7\u5f97\u5e94\u7528\u6a21\u677f\u53d6\u5f97\u6587\u4ef6\u5185\u5bb9\u5931\u8d25:'") + publishPageContext.getPageElement().getInfo() + "(Template[" + template.getId() + "]:" + template.getName() + ")'", exception);
        }
    }
}

