/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.cluster.ClusterConfigHelper;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;

public class PageDestroyer {
    private static boolean m_bInited = false;
    private static boolean m_bSlaveNode = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withdraw(IPublishFolder iPublishFolder, PublishTaskContext publishTaskContext) throws Exception {
        Object object;
        if (iPublishFolder == null) {
            return;
        }
        String string = null;
        try {
            object = new PublishPathCompass();
            string = ((PublishPathCompass)object).getLocalPath(iPublishFolder, false);
        }
        catch (Exception exception) {
            return;
        }
        PageDestroyer.initIfNeed();
        object = new File(string);
        if (!((File)object).exists() || !((File)object).isDirectory()) {
            return;
        }
        boolean bl = ((File)object).renameTo(new File(((File)object).getParentFile(), PublishConstants.makeDeletedPathName(((File)object).getName())));
        if (!bl) {
            throw new Exception("Failed to withdraw folder.");
        }
        FileDistributeShip fileDistributeShip = publishTaskContext == null ? new FileDistributeShip() : publishTaskContext.getFileDistributeShip();
        try {
            fileDistributeShip.withdrawFolder(iPublishFolder);
        }
        finally {
            if (publishTaskContext == null) {
                fileDistributeShip.clear();
            }
        }
    }

    private static void initIfNeed() {
        if (!m_bInited) {
            ClusterConfig clusterConfig = ClusterConfigHelper.getConfig();
            m_bSlaveNode = clusterConfig.isEnabled() && !clusterConfig.isMaster();
            m_bInited = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withdraw(IPublishContent iPublishContent, PublishTaskContext publishTaskContext) throws Exception {
        FileDistributeShip fileDistributeShip;
        PublishPathCompass publishPathCompass;
        if (iPublishContent == null) {
            return;
        }
        if (publishTaskContext == null) {
            publishPathCompass = new PublishPathCompass();
            fileDistributeShip = new FileDistributeShip(publishPathCompass);
        } else {
            publishPathCompass = publishTaskContext.getPathCompass();
            fileDistributeShip = publishTaskContext.getFileDistributeShip();
        }
        try {
            Template template = iPublishContent.getDetailTemplate();
            if (template == null) {
                throw new WCMException(225, CMyString.format(I18NMessage.get(PageDestroyer.class, "PageDestroyer.label1", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u7ec6\u89c8\u6a21\u677f,\u64a4\u9500\u53d1\u5e03\u5931\u8d25."), new Object[]{iPublishContent}), null);
            }
            String string = template.getOutputFileExt();
            String string2 = publishPathCompass.getLocalPath(iPublishContent, false);
            int n = 0;
            String string3 = PublishPathCompass.makeDetailPageFileName(iPublishContent, string, n);
            if (iPublishContent.isFile()) {
                string3 = iPublishContent.getFileName();
            }
            PageDestroyer.initIfNeed();
            do {
                CMyFile.deleteFile(string2 + string3);
                fileDistributeShip.withdrawFile(string3, iPublishContent);
                string3 = PublishPathCompass.makeDetailPageFileName(iPublishContent, string, ++n);
            } while (CMyFile.fileExists(string2 + string3));
            Iterator iterator = iPublishContent.getRelatedResources();
            if (iterator != null) {
                String string4 = publishPathCompass.getLocalPath(iPublishContent, false);
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    if (!CMyFile.deleteFile(string4 + string5)) continue;
                    fileDistributeShip.withdrawFile(string5, iPublishContent);
                }
            }
        }
        finally {
            if (publishTaskContext == null) {
                publishPathCompass.clear();
                fileDistributeShip.clear();
            }
        }
    }

    public static synchronized void reinit() {
        m_bInited = false;
    }

    public static class FileFilterForContentPath
    implements FileFilter {
        private CMyDateTime m_dtStart = null;
        private CMyDateTime m_dtEnd = null;

        public FileFilterForContentPath(CMyDateTime cMyDateTime, CMyDateTime cMyDateTime2) {
            this.m_dtStart = cMyDateTime;
            this.m_dtEnd = cMyDateTime2;
        }

        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            String string = file.getName();
            CMyDateTime cMyDateTime = new CMyDateTime();
            try {
                cMyDateTime.setDateTimeWithString(string, PublishServerConfigMapper.getDirDividedByDateFormat(true));
            }
            catch (CMyException cMyException) {
                return false;
            }
            return cMyDateTime.compareTo(this.m_dtStart) >= 0L && cMyDateTime.compareTo(this.m_dtEnd) <= 0L;
        }
    }
}

