/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.components.common.message.notify.NotificationServer;
import com.trs.components.common.message.notify.Notifier;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.uftp.FtpConfig;
import com.trs.infra.util.uftp.FtpConnection;
import com.trs.infra.util.uftp.FtpConnectionCache;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.ContainerUtil;
import org.aton.container.IClearable;

public class UftpConnectionCacheManager
implements IClearable {
    private static final Logger s_logger = Logger.getLogger(UftpConnectionCacheManager.class);
    private Map m_oCacheMap = new HashMap();

    public FtpConnectionCache getConnectionCache(PublishDistribution publishDistribution) throws WCMException {
        FtpConnectionCache ftpConnectionCache = (FtpConnectionCache)this.m_oCacheMap.get(publishDistribution.getKey());
        if (ftpConnectionCache != null) {
            return ftpConnectionCache;
        }
        this.insertFtpCache(publishDistribution, this.m_oCacheMap);
        return (FtpConnectionCache)this.m_oCacheMap.get(publishDistribution.getKey());
    }

    private FtpConnectionCache createFtpCache(PublishDistribution publishDistribution) throws WCMException {
        FtpConfig ftpConfig = new FtpConfig();
        ftpConfig.setProtocol(publishDistribution.getTargetType());
        ftpConfig.setHost(publishDistribution.getTargetServer());
        ftpConfig.setPort(publishDistribution.getTargetPort());
        ftpConfig.setAnonymous(publishDistribution.isAnonymous());
        ftpConfig.setUserName(publishDistribution.getLoginUser());
        ftpConfig.setPassWord(publishDistribution.getLoginPassword());
        ftpConfig.setRootPath(publishDistribution.getDataPath());
        ftpConfig.setPassive(publishDistribution.getPassiveMode());
        ftpConfig.setMaxClient(60);
        try {
            FtpConnectionCache ftpConnectionCache = new FtpConnectionCache(ftpConfig);
            FtpConnection ftpConnection = ftpConnectionCache.getConnectionWrapper();
            if (ftpConnection.isReadOnly()) {
                ftpConnectionCache.clear();
                throw new WCMException("[" + ftpConfig + I18NMessage.get(UftpConnectionCacheManager.class, "UftpConnectionCacheManager.label1", "]\u662f\u53ea\u8bfb\u7684\uff01"));
            }
            ftpConnectionCache.initialize();
            return ftpConnectionCache;
        }
        catch (Exception exception) {
            Object object;
            if (NotificationServer.getInstance().needNotifyForEvent("Publish.WhenMakeFTPConnectionError")) {
                object = new Notifier();
                ((Notifier)object).setParameter("FTPDistributionInfo", publishDistribution.toString());
                ((Notifier)object).setParameter("Message", I18NMessage.get(UftpConnectionCacheManager.class, "UftpConnectionCacheManager.label2", "\u5efa\u7acbFTP\u8fde\u63a5\u5931\u8d25!\n\u5206\u53d1\u4fe1\u606f\u4e3a\uff1a") + publishDistribution);
                try {
                    ((Notifier)object).executeOnEvent("Publish.WhenMakeFTPConnectionError");
                }
                catch (WCMException wCMException) {
                    wCMException.printStackTrace();
                }
            }
            object = null;
            object = exception instanceof WCMException ? (WCMException)exception : new WCMException(I18NMessage.get(UftpConnectionCacheManager.class, "UftpConnectionCacheManager.label3", "\u521d\u59cb\u5316\u5206\u53d1\u76ee\u5f55\u7684FTP\u5931\u8d25\uff01") + publishDistribution, exception);
            throw object;
        }
    }

    private synchronized void insertFtpCache(PublishDistribution publishDistribution, Map map) throws WCMException {
        Object object = publishDistribution.getKey();
        if (map.get(object) != null) {
            return;
        }
        FtpConnectionCache ftpConnectionCache = this.createFtpCache(publishDistribution);
        if (ftpConnectionCache == null) {
            return;
        }
        map.put(object, ftpConnectionCache);
    }

    private synchronized void deleteFtpCache(PublishDistribution publishDistribution) {
        FtpConnectionCache ftpConnectionCache = (FtpConnectionCache)this.m_oCacheMap.remove(publishDistribution.getKey());
        if (ftpConnectionCache != null) {
            ftpConnectionCache.clear();
        }
    }

    private boolean isSupported(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toUpperCase()).equals("FTP") || string.equals("SFTP") || string.equals("FTPS") || string.equals("GFTP");
    }

    public void clear() {
        if (this.m_oCacheMap == null) {
            return;
        }
        ContainerUtil.clearContainer((Map)this.m_oCacheMap);
        this.m_oCacheMap = null;
    }

    public void deleteDistribution(PublishDistribution publishDistribution) throws WCMException {
        if (publishDistribution != null && this.isSupported(publishDistribution.getTargetType())) {
            this.deleteFtpCache(publishDistribution);
        }
    }
}

