/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.domain.distribute.DistributionChangeListener;
import com.trs.components.common.publish.domain.distribute.FileDistributorImpUnion;
import com.trs.components.common.publish.domain.distribute.PublishDistributionList;
import com.trs.components.common.publish.domain.distribute.UftpConnectionCacheManager;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.distribute.PublishDistributions;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.ContainerUtil;

public class PublishDistributionCacheMgr
implements ICacheMgr {
    private static final Logger s_logger = Logger.getLogger(PublishDistributionCacheMgr.class);
    private HashMap m_oCacheMap;
    private HashMap m_mListener = new HashMap();
    UftpConnectionCacheManager m_oFtpCache = (UftpConnectionCacheManager)DreamFactory.createObjectById("UftpConnectionCacheManager");

    public static final String makeCaheKey(int n, int n2) {
        return new StringBuffer(32).append(n).append(',').append(n2).toString();
    }

    public PublishDistributionList getPublishDistributionList(int n, int n2) throws WCMException {
        return (PublishDistributionList)this.getCacheMap().get(PublishDistributionCacheMgr.makeCaheKey(n, n2));
    }

    public FileDistributorImpUnion getDistributorUnion(IPublishFolder iPublishFolder) throws WCMException {
        if (iPublishFolder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.getDistributorUnion(iPublishFolder.getType(), iPublishFolder.getId());
    }

    public FileDistributorImpUnion getDistributorUnion(int n, int n2) throws WCMException {
        PublishDistributionList publishDistributionList = this.getPublishDistributionList(n, n2);
        if (publishDistributionList != null) {
            return publishDistributionList.getDistributorUnion();
        }
        return null;
    }

    public PublishDistributionList getPublishDistributionList(String string) throws WCMException {
        return (PublishDistributionList)this.getCacheMap().get(string);
    }

    public synchronized boolean init() throws WCMException {
        if (this.m_oCacheMap != null) {
            return true;
        }
        this.m_oCacheMap = new HashMap(64);
        PublishDistributions publishDistributions = new PublishDistributions(ContextHelper.getLoginUser());
        WCMFilter wCMFilter = new WCMFilter("", "", "");
        publishDistributions.open(wCMFilter);
        for (int i = 0; i < publishDistributions.size(); ++i) {
            PublishDistribution publishDistribution = (PublishDistribution)publishDistributions.getAt(i);
            if (publishDistribution == null) continue;
            this.putDistribution(publishDistribution, this.m_oCacheMap);
        }
        return true;
    }

    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    public synchronized void clear() {
        if (this.m_oCacheMap != null) {
            ContainerUtil.clearContainer((Map)this.m_mListener);
            ContainerUtil.clearContainer((Map)this.m_oCacheMap);
            this.m_oCacheMap = null;
        }
    }

    private HashMap getCacheMap() throws WCMException {
        if (this.m_oCacheMap == null) {
            this.init();
        }
        return this.m_oCacheMap;
    }

    private synchronized void putDistribution(PublishDistribution publishDistribution, HashMap hashMap) throws WCMException {
        String string = PublishDistributionCacheMgr.makeCaheKey(publishDistribution.getFolderType(), publishDistribution.getFolderId());
        PublishDistributionList publishDistributionList = (PublishDistributionList)hashMap.get(string);
        if (publishDistributionList == null) {
            publishDistributionList = new PublishDistributionList();
            hashMap.put(string, publishDistributionList);
        }
        publishDistributionList.putDistribution(publishDistribution);
    }

    private synchronized void delDistribution(PublishDistribution publishDistribution, HashMap hashMap) throws WCMException {
        String string = PublishDistributionCacheMgr.makeCaheKey(publishDistribution.getFolderType(), publishDistribution.getFolderId());
        PublishDistributionList publishDistributionList = (PublishDistributionList)hashMap.get(string);
        if (publishDistributionList != null) {
            publishDistributionList.delDistribution(publishDistribution);
        }
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        if (!(baseObj instanceof PublishDistribution)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        PublishDistribution publishDistribution = (PublishDistribution)baseObj;
        this.putDistribution(publishDistribution, this.getCacheMap());
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof PublishDistribution)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        PublishDistribution publishDistribution = (PublishDistribution)baseObj;
        this.delDistribution(publishDistribution, this.getCacheMap());
        this.fireDeleteEvent(publishDistribution.getId());
        this.m_oFtpCache.deleteDistribution(publishDistribution);
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        if (!(baseObj instanceof PublishDistribution)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + baseObj.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label4", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        if (!baseObj.isModified(true)) {
            return;
        }
        PublishDistribution publishDistribution = (PublishDistribution)baseObj;
        this.putDistribution(publishDistribution, this.getCacheMap());
        if (publishDistribution.isEnabled() && publishDistribution.isChangeProperty("ENABLED")) {
            this.fireDeleteEvent(publishDistribution.getId());
        } else {
            this.fireChangeEvent(publishDistribution.getId());
        }
        this.m_oFtpCache.deleteDistribution(publishDistribution);
    }

    private void fireChangeEvent(int n) {
        if (this.m_mListener.size() <= 0) {
            return;
        }
        try {
            for (DistributionChangeListener distributionChangeListener : this.m_mListener.values()) {
                if (distributionChangeListener == null) continue;
                distributionChangeListener.onChange(n);
            }
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label5", "\u5e7f\u64ad\u5206\u53d1\u914d\u7f6e\u4fe1\u606f\u6539\u53d8\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef"), (Throwable)exception);
        }
    }

    private void fireDeleteEvent(int n) {
        if (this.m_mListener.size() <= 0) {
            return;
        }
        try {
            for (DistributionChangeListener distributionChangeListener : this.m_mListener.values()) {
                if (distributionChangeListener == null) continue;
                distributionChangeListener.onDelete(n);
            }
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label6", "\u5e7f\u64ad\u5206\u53d1\u914d\u7f6e\u4fe1\u606f\u5220\u9664\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef"), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(DistributionChangeListener distributionChangeListener) {
        if (distributionChangeListener != null) {
            HashMap hashMap = this.m_mListener;
            synchronized (hashMap) {
                this.m_mListener.put(distributionChangeListener, distributionChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(DistributionChangeListener distributionChangeListener) {
        if (distributionChangeListener != null) {
            HashMap hashMap = this.m_mListener;
            synchronized (hashMap) {
                this.m_mListener.remove(distributionChangeListener);
            }
        }
    }
}

