/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import org.apache.log4j.Logger;

public class FileDistributorLocalImpl
implements IFileDistristributor {
    private static final Logger logger = Logger.getLogger((String)FileDistributorLocalImpl.class.getName());
    private String m_sRootDir;
    private static Object s_locker = new Object();

    public int getConfigID() {
        return 0;
    }

    public void setTargetRoot(PublishDistribution publishDistribution) throws Exception {
        this.m_sRootDir = CMyString.setStrEndWith(publishDistribution.getDataPath(), File.separatorChar);
        if (this.m_sRootDir == null) {
            throw new Exception("Root directory of local distribution target [ID=" + publishDistribution.getId() + "] not set!");
        }
    }

    public void distributeFile(String string, String string2, boolean bl) throws Exception {
        String string3 = this.calFullPath(string2);
        this.insurePathExists(string3);
        string3 = string3 + CMyFile.extractFileName(string);
        if (bl) {
            if (!CMyFile.fileExists(string3)) {
                CMyFile.copyFile(string, string3);
            }
        } else {
            CMyFile.copyFile(string, string3);
        }
    }

    public boolean withdrawFile(String string, String string2) {
        String string3 = this.calFullPath(string2) + string;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("to delete file [" + string3 + "]"));
        }
        return CMyFile.deleteFile(string3);
    }

    public boolean withdrawPath(String string) {
        String string2 = this.calFullPath(string);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("to delete path [" + string2 + "]"));
        }
        return CMyFile.deleteDir(string2);
    }

    private String calFullPath(String string) {
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        return this.m_sRootDir + CMyString.setStrEndWith(string, File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File insurePathExists(String string) throws WCMException {
        File file = new File(string);
        if (!file.exists()) {
            try {
                Object object = s_locker;
                synchronized (object) {
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                }
            }
            catch (Exception exception) {
                throw new WCMException(50, "Failed to create directroy [" + string + "] on disk!", exception);
            }
            if (!file.exists()) {
                throw new WCMException(50, "Failed to create directroy [" + string + "] on disk!");
            }
        }
        return file;
    }

    public boolean renameFile(String string, String string2, String string3) throws Exception {
        throw new RuntimeException("Not supported method");
    }
}

