/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.domain.distribute.UftpConnectionCacheManager;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.uftp.FtpConnection;
import com.trs.infra.util.uftp.FtpConnectionCache;
import org.apache.log4j.Logger;

public class FileDistributorImpFtpByTRS
implements IFileDistristributor {
    private static final Logger s_logger = Logger.getLogger(FileDistributorImpFtpByTRS.class);
    private int m_iDistributionID = 0;
    private String m_sRootDirectory = null;
    private FtpConnection m_oFtpConnection = null;

    private void assertReady() throws WCMException {
        if (this.m_oFtpConnection != null) {
            return;
        }
        s_logger.error((Object)I18NMessage.get(FileDistributorImpFtpByTRS.class, "FileDistributorImpFtpByTRS.label1", "\u5f53\u524d\u5206\u53d1\u76ee\u6807\u7684FTP\u7ba1\u7406\u5668\u6709\u8bef\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u4ee5\u53caFTP\u670d\u52a1\u5668\u4e0a\u7684\u6743\u9650\u8bbe\u7f6e\uff01"));
        throw new WCMException(I18NMessage.get(FileDistributorImpFtpByTRS.class, "FileDistributorImpFtpByTRS.label1", "\u5f53\u524d\u5206\u53d1\u76ee\u6807\u7684FTP\u7ba1\u7406\u5668\u6709\u8bef\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u4ee5\u53caFTP\u670d\u52a1\u5668\u4e0a\u7684\u6743\u9650\u8bbe\u7f6e\uff01"));
    }

    public int getConfigID() {
        return this.m_iDistributionID;
    }

    public void setTargetRoot(PublishDistribution publishDistribution) throws Exception {
        this.m_iDistributionID = publishDistribution.getId();
        this.m_sRootDirectory = publishDistribution.getDataPath();
        UftpConnectionCacheManager uftpConnectionCacheManager = (UftpConnectionCacheManager)DreamFactory.createObjectById("UftpConnectionCacheManager");
        FtpConnectionCache ftpConnectionCache = uftpConnectionCacheManager.getConnectionCache(publishDistribution);
        this.m_oFtpConnection = ftpConnectionCache.getConnectionWrapper();
        this.reviseRootPath();
    }

    private void reviseRootPath() throws Exception {
        String string;
        if (this.m_sRootDirectory.charAt(0) != '/') {
            string = this.m_oFtpConnection.toAbsolutePath(this.m_sRootDirectory);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("[" + this.m_sRootDirectory + "] revised to[" + string + "]"));
            }
            this.m_sRootDirectory = string;
        }
        if (this.m_sRootDirectory.charAt(this.m_sRootDirectory.length() - 1) != '/') {
            string = this.m_sRootDirectory + '/';
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("[" + this.m_sRootDirectory + "] revised to[" + string + "]"));
            }
            this.m_sRootDirectory = string;
        }
    }

    private String returnFullPath(String string) {
        string = string.replace('\\', '/');
        return this.m_sRootDirectory + CMyString.setStrEndWith(string, '/');
    }

    public void distributeFile(String string, String string2, boolean bl) throws Exception {
        StringBuffer stringBuffer;
        this.assertReady();
        String string3 = this.returnFullPath(string2) + CMyFile.extractFileName(string);
        if (s_logger.isDebugEnabled()) {
            stringBuffer = new StringBuffer(512);
            stringBuffer.append("to upload file [");
            stringBuffer.append(string);
            stringBuffer.append("] to [");
            stringBuffer.append(string3);
            stringBuffer.append("] in ");
            stringBuffer.append(this.m_oFtpConnection.getFtpConfig());
            s_logger.debug((Object)stringBuffer.toString());
        }
        if (bl && this.m_oFtpConnection.hasTheFile(string3)) {
            if (s_logger.isDebugEnabled()) {
                stringBuffer = new StringBuffer(512);
                stringBuffer.append("The file [");
                stringBuffer.append(string3);
                stringBuffer.append("] has exists!");
                s_logger.debug((Object)stringBuffer.toString());
            }
            return;
        }
        boolean bl2 = false;
        int n = 0;
        int n2 = 4;
        while (!bl2) {
            ++n;
            try {
                bl2 = this.m_oFtpConnection.uploadFile(string, string3);
                if (s_logger.isDebugEnabled()) {
                    StringBuffer stringBuffer2 = new StringBuffer(512);
                    stringBuffer2.append("Upload file [");
                    stringBuffer2.append(string3);
                    stringBuffer2.append("] end!");
                    s_logger.debug((Object)stringBuffer2.toString());
                }
            }
            catch (Exception exception) {
                bl2 = false;
                if (n >= n2) {
                    throw exception;
                }
                StringBuffer stringBuffer3 = new StringBuffer(512);
                stringBuffer3.append("Try to upload file [");
                stringBuffer3.append(string);
                stringBuffer3.append("] to [");
                stringBuffer3.append(string3);
                stringBuffer3.append("] in ");
                stringBuffer3.append(this.m_oFtpConnection.getFtpConfig());
                stringBuffer3.append("again");
                s_logger.error((Object)stringBuffer3);
                s_logger.error((Object)"Error Info", (Throwable)exception);
            }
            if (n < n2) continue;
            break;
        }
    }

    public boolean renameFile(String string, String string2, String string3) throws Exception {
        this.assertReady();
        String string4 = this.returnFullPath(string3);
        String string5 = string4 + string;
        String string6 = string4 + string2;
        if (s_logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append("to rename file [");
            stringBuffer.append(string5);
            stringBuffer.append("] to [");
            stringBuffer.append(string6);
            stringBuffer.append("] on ");
            stringBuffer.append(this.m_oFtpConnection.getFtpConfig());
            s_logger.debug((Object)stringBuffer.toString());
        }
        return this.m_oFtpConnection.renameFile(string5, string2);
    }

    public boolean withdrawFile(String string, String string2) throws Exception {
        this.assertReady();
        String string3 = this.returnFullPath(string2) + string;
        if (s_logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append("to remove file [");
            stringBuffer.append(string3);
            stringBuffer.append("] from ");
            stringBuffer.append(this.m_oFtpConnection.getFtpConfig());
            s_logger.debug((Object)stringBuffer.toString());
        }
        return this.m_oFtpConnection.deleteFile(string3);
    }

    public boolean withdrawPath(String string) throws Exception {
        this.assertReady();
        String string2 = this.returnFullPath(string);
        if (s_logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append("to remove path [");
            stringBuffer.append(string2);
            stringBuffer.append("] from ");
            stringBuffer.append(this.m_oFtpConnection.getFtpConfig());
            s_logger.debug((Object)stringBuffer.toString());
        }
        return this.m_oFtpConnection.deleteDirectory(string2);
    }
}

