/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.distribute.FileDistributorFtpCacheMgr;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.ftp.FtpMgr;
import org.apache.log4j.Logger;

public class FileDistributorFtpImpl
implements IFileDistristributor {
    private static final Logger logger = Logger.getLogger((String)FileDistributorFtpImpl.class.getName());
    private String m_sRootDir;
    private FtpMgr m_oFtpMgr = null;
    private FileDistributorFtpCacheMgr m_oFtpCacheMgr = (FileDistributorFtpCacheMgr)DreamFactory.createObjectById("FileDistributorFtpCacheMgr");
    private static Logger s_logger = Logger.getLogger(FileDistributorFtpImpl.class);

    public int getConfigID() {
        return 0;
    }

    public void setTargetRoot(PublishDistribution publishDistribution) {
        this.m_oFtpMgr = this.m_oFtpCacheMgr.lookupFtpMgr(publishDistribution);
        this.m_sRootDir = publishDistribution.getDataPath();
    }

    public void distributeFile(String string, String string2, boolean bl) throws Exception {
        this.checkFtpReady();
        String string3 = this.calFullPath(string2) + CMyFile.extractFileName(string);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("to upload file [" + string + "] to [" + string3 + "] in ftp://" + this.m_oFtpMgr.getServerHost()));
        }
        if (!bl) {
            this.m_oFtpMgr.upload(string, string3);
        }
    }

    public boolean withdrawFile(String string, String string2) throws Exception {
        if (!this.checkFtpReady()) {
            return false;
        }
        String string3 = this.calFullPath(string2) + string;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("to remove file [" + string3 + "] from ftp://" + this.m_oFtpMgr.getServerHost()));
        }
        return this.m_oFtpMgr.removeFile(string3);
    }

    public boolean withdrawPath(String string) throws Exception {
        if (!this.checkFtpReady()) {
            return false;
        }
        String string2 = this.calFullPath(string);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("to remove path [" + string2 + "] from ftp://" + this.m_oFtpMgr.getServerHost()));
        }
        return this.m_oFtpMgr.removePath(string2);
    }

    private boolean checkFtpReady() throws WCMException {
        if (this.m_oFtpMgr != null) {
            return true;
        }
        s_logger.error((Object)I18NMessage.get(FileDistributorFtpImpl.class, "FileDistributorFtpImpl.label1", "\u5f53\u524d\u5206\u53d1\u76ee\u6807\u7684FTP\u7ba1\u7406\u5668\u6709\u8bef\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u4ee5\u53caFTP\u670d\u52a1\u5668\u4e0a\u7684\u6743\u9650\u8bbe\u7f6e\uff01"));
        throw new WCMException(I18NMessage.get(FileDistributorFtpImpl.class, "FileDistributorFtpImpl.label1", "\u5f53\u524d\u5206\u53d1\u76ee\u6807\u7684FTP\u7ba1\u7406\u5668\u6709\u8bef\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u4ee5\u53caFTP\u670d\u52a1\u5668\u4e0a\u7684\u6743\u9650\u8bbe\u7f6e\uff01"));
    }

    private String calFullPath(String string) {
        string = string.replace('\\', '/');
        return this.m_sRootDir + CMyString.setStrEndWith(string, '/');
    }

    public boolean renameFile(String string, String string2, String string3) throws Exception {
        throw new RuntimeException("Not supported method");
    }
}

