/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message.notify;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.common.message.notify.NotificationConfig;
import com.trs.components.common.message.notify.NotificationSchemeConfig;
import com.trs.components.common.message.notify.NotificationServer;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Notifier {
    private static final Logger logger = Logger.getLogger((String)Notifier.class.getName());
    private HashMap m_parameters = new HashMap();

    public void setParameter(String string, String string2) {
        this.m_parameters.put(string, string2);
    }

    public String getParameter(String string) {
        return (String)this.m_parameters.get(string);
    }

    public void executeOnEvent(String string) throws WCMException {
        NotificationSchemeConfig notificationSchemeConfig = NotificationServer.getInstance().lookupSchemeForEvent(string);
        if (notificationSchemeConfig == null) {
            logger.debug((Object)("NotificationConfig scheme for event " + string + " is not found!"));
            return;
        }
        if (!notificationSchemeConfig.isEnabled()) {
            logger.debug((Object)("NotificationConfig scheme for event " + string + " is disabled!"));
            return;
        }
        logger.debug((Object)("NotificationConfig scheme for event " + string + " is found and enabled!"));
        this.execute(notificationSchemeConfig);
    }

    public void execute(NotificationSchemeConfig notificationSchemeConfig) throws WCMException {
        if (notificationSchemeConfig == null) {
            return;
        }
        try {
            logger.debug((Object)("to execute notification scheme for event " + notificationSchemeConfig.getEvent()));
            String string = this.parseTemplate(notificationSchemeConfig.getTitle());
            String string2 = this.parseTemplate(notificationSchemeConfig.getMsgBody());
            ArrayList arrayList = notificationSchemeConfig.getNotifications();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3;
                NotificationConfig notificationConfig = (NotificationConfig)arrayList.get(i);
                if (notificationConfig == null) continue;
                logger.debug((Object)("to notify through " + notificationConfig.getSendType() + " ..."));
                String string4 = notificationConfig.getUserNames();
                if (string4 == null) {
                    string3 = null;
                } else {
                    string4 = this.parseTemplate(string4);
                    string3 = this.getUserIdsByName(string4);
                }
                String string5 = notificationConfig.getGroupIds();
                String string6 = notificationConfig.getRoleIds();
                if (CMyString.isEmpty(string3) && CMyString.isEmpty(string5) && CMyString.isEmpty(string6)) {
                    return;
                }
                Message message = Message.createNewInstance();
                message.setTitle(string);
                message.setBody(string2);
                message.setProperty("MsgType", 2L);
                message.setSendTypes(new String[]{notificationConfig.getSendType()});
                message.setFlag(0);
                message.setValidTime(CMyDateTime.now());
                if (string3 != null && string3.length() > 0) {
                    message.setReceivers(204, string3);
                }
                if (string5 != null && string5.length() > 0) {
                    message.setReceivers(201, string5);
                }
                if (string6 != null && string6.length() > 0) {
                    message.setReceivers(203, string6);
                }
                MessageServer.send(message);
                logger.debug((Object)("finished to notify through " + notificationConfig.getSendType()));
            }
            logger.debug((Object)("finished to execute notification scheme for event " + notificationSchemeConfig.getEvent()));
        }
        catch (Exception exception) {
            throw new WCMException(1352, "Failed to execute notification scheme!", exception);
        }
    }

    private String parseTemplate(String string) throws WCMException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        try {
            char[] cArray = string.toCharArray();
            int n = 0;
            int n2 = cArray.length;
            stringBuffer = new StringBuffer();
            while (n < cArray.length) {
                char c;
                if ((c = cArray[n++]) == '$' && n < n2 && cArray[n] == '{') {
                    stringBuffer2 = new StringBuffer(16);
                    while (true) {
                        int n3 = ++n;
                        ++n;
                        c = cArray[n3];
                        if (c == '}') break;
                        stringBuffer2.append(c);
                    }
                    String string2 = stringBuffer2.toString();
                    stringBuffer2.setLength(0);
                    String string3 = this.getParameter(string2);
                    if (string3 == null) {
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append(c);
            }
            String string4 = stringBuffer.toString();
            return string4;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to parse the template: " + string, exception);
        }
        finally {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
            }
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
            }
        }
    }

    private String getUserIdsByName(String string) throws Exception {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            User user = User.findByName(string3);
            if (user == null) continue;
            if (string2 == null) {
                string2 = String.valueOf(user.getId());
                continue;
            }
            string2 = string2 + ',' + String.valueOf(user.getId());
        }
        return string2;
    }
}

