/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.comment.domain.DocumentTopicRelationMgr;
import com.trs.components.comment.persistent.DocumentTopic;
import com.trs.components.comment.service.ICommentService;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;

public class CommentService
implements ICommentService {
    private DocumentTopicRelationMgr topicMgr = (DocumentTopicRelationMgr)DreamFactory.createObjectById("DocumentTopicRelationMgr");

    public boolean isInRelatedTopic(String string, int n) {
        boolean bl = false;
        try {
            bl = this.topicMgr.isInRelatedTopic(string, n);
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    public void saveDocTopicRelation(int n, int n2, String string) throws WCMException {
        try {
            if (CMyString.isEmpty(string)) {
                this.topicMgr.saveDocTopicRelation(n, n2, null);
                return;
            }
            String[] stringArray = string.split(",");
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                nArray[i] = Integer.parseInt(string2);
            }
            this.topicMgr.saveDocTopicRelation(n, n2, nArray);
        }
        catch (Exception exception) {
            throw new WCMException("Failed to save the relationship for topic[" + n + "]", exception);
        }
    }

    public DocumentTopic getDocumentTopic(int n) {
        return this.topicMgr.getDocumentTopic(n);
    }

    public String getRelatedDocIds(int n, int n2) throws WCMException {
        String string = "";
        try {
            string = this.topicMgr.getRelatedDocIds(n, n2);
        }
        catch (CMyException cMyException) {
            throw new WCMException(I18NMessage.get(CommentService.class, "CommentService.label2", "\u8bd5\u56fe\u67e5\u627e[TopicId=") + n + "], [Doc ChannelId=" + n2 + I18NMessage.get(CommentService.class, "CommentService.label3", "]\u5173\u8054\u7684\u6587\u6863\u5931\u8d25\uff01"), cMyException);
        }
        return string;
    }

    public String getRelatedDocIds(int n) throws WCMException {
        String string = "";
        try {
            string = this.topicMgr.getRelatedDocIds(n);
        }
        catch (CMyException cMyException) {
            throw new WCMException(I18NMessage.get(CommentService.class, "CommentService.label2", "\u8bd5\u56fe\u67e5\u627e[TopicId=") + n + I18NMessage.get(CommentService.class, "CommentService.label3", "]\u5173\u8054\u7684\u6587\u6863\u5931\u8d25\uff01"), cMyException);
        }
        return string;
    }

    public String getNoneRelatedDocIds(int n, int n2) throws WCMException {
        String string = "";
        try {
            string = this.topicMgr.getNoneRelatedDocIds(n, n2);
        }
        catch (CMyException cMyException) {
            throw new WCMException(I18NMessage.get(CommentService.class, "CommentService.label2", "\u8bd5\u56fe\u67e5\u627e[TopicId=") + n + I18NMessage.get(CommentService.class, "CommentService.label3", "]\u5173\u8054\u7684\u6587\u6863\u5931\u8d25\uff01"), cMyException);
        }
        return string;
    }

    public DocumentTopic getDocumentTopic(int n, int n2) throws WCMException {
        try {
            return this.topicMgr.getDocumentTopic(n, n2);
        }
        catch (CMyException cMyException) {
            throw new WCMException(I18NMessage.get(CommentService.class, "CommentService.label4", "\u8bd5\u56fe\u67e5\u627e\u6307\u5b9a[DocumentId=") + n + "], [ChannelId=" + n2 + I18NMessage.get(CommentService.class, "CommentService.label5", "]\u7684\u76f8\u5173\u4e3b\u9898\u65f6\u5931\u8d25\uff01"), cMyException);
        }
    }

    public Documents getRelatedDocs(int n, WCMFilter wCMFilter) throws WCMException {
        String string = this.getRelatedDocIds(n);
        if (CMyString.isEmpty(string)) {
            return new Documents(ContextHelper.getLoginUser());
        }
        String string2 = "DOCID IN(" + string + ")";
        if (!CMyString.isEmpty(wCMFilter.getWhere())) {
            string2 = string2 + " AND " + wCMFilter.getWhere();
        }
        wCMFilter.setWhere(string2);
        Documents documents = Documents.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        return documents;
    }

    public void cancelDocTopicRelation(int n, int n2) throws WCMException {
        this.topicMgr.deleteTopicDocRelation(n, n2);
    }
}

