/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.domain;

import com.trs.components.comment.domain.SignUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;

public class CommentUpdator {
    private int m_nTopicId;
    private String m_sRelatedDocIds;
    private boolean m_bDeleteFlag;
    private String m_sDataWithSign;

    public CommentUpdator() {
        this.m_nTopicId = 0;
        this.m_sRelatedDocIds = null;
        this.m_bDeleteFlag = true;
        this.m_sDataWithSign = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommentUpdator(String string) throws Exception {
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            byte[] byArray = string.getBytes("ISO8859_1");
            SignUtil signUtil = SignUtil.getVerify();
            byArray = signUtil.decodeRadix64(byArray);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            this.m_nTopicId = ((DataInputStream)filterInputStream).readInt();
            this.m_sRelatedDocIds = ((DataInputStream)filterInputStream).readUTF();
            this.m_bDeleteFlag = ((DataInputStream)filterInputStream).readBoolean();
            if (!signUtil.verify(byArray, ((DataInputStream)filterInputStream).readInt())) {
                throw new Exception("sign error");
            }
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataWithSign() throws Exception {
        if (this.m_sDataWithSign == null) {
            if (this.m_sRelatedDocIds == null) {
                this.m_sRelatedDocIds = "";
            }
            SignUtil signUtil = SignUtil.getSign();
            ByteArrayOutputStream byteArrayOutputStream = null;
            FilterOutputStream filterOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(512);
                filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                ((DataOutputStream)filterOutputStream).writeInt(this.m_nTopicId);
                ((DataOutputStream)filterOutputStream).writeUTF(this.m_sRelatedDocIds);
                ((DataOutputStream)filterOutputStream).writeBoolean(this.m_bDeleteFlag);
                ((DataOutputStream)filterOutputStream).flush();
                byte[] byArray = signUtil.sign(byteArrayOutputStream.toByteArray());
                ((DataOutputStream)filterOutputStream).writeInt(byArray.length);
                filterOutputStream.write(byArray);
                ((DataOutputStream)filterOutputStream).flush();
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_sDataWithSign = signUtil.encodeRadix64(byteArrayOutputStream.toByteArray());
        }
        return this.m_sDataWithSign;
    }

    public static void main(String[] stringArray) {
        try {
            CommentUpdator commentUpdator = new CommentUpdator();
            commentUpdator.setTopicId(1);
            commentUpdator.setRelatedDocIds("655,658,659");
            commentUpdator.setDeleteFlag(false);
            String string = commentUpdator.getDataWithSign();
            System.out.println("signed string:" + string);
            System.out.println("-------------------");
            CommentUpdator commentUpdator2 = new CommentUpdator(string);
            System.out.println("unsigned info:" + commentUpdator);
            System.out.println("designed info:" + commentUpdator2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("TopicID:");
        stringBuffer.append(this.m_nTopicId);
        stringBuffer.append(",RelatedDocs:");
        stringBuffer.append(this.m_sRelatedDocIds);
        stringBuffer.append(",IsTopicDelete?:");
        stringBuffer.append(this.m_bDeleteFlag);
        return stringBuffer.toString();
    }

    public int getTopicId() {
        return this.m_nTopicId;
    }

    public void setTopicId(int n) {
        this.m_nTopicId = n;
    }

    public String getRelatedDocIds() {
        return this.m_sRelatedDocIds;
    }

    public void setRelatedDocIds(String string) {
        this.m_sRelatedDocIds = string;
    }

    public boolean isDeleteFlag() {
        return this.m_bDeleteFlag;
    }

    public void setDeleteFlag(boolean bl) {
        this.m_bDeleteFlag = bl;
    }
}

