/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.xml;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.definition.FlowActions;
import com.trs.cms.process.definition.FlowCondition;
import com.trs.cms.process.definition.FlowConditions;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.definition.FlowNodeField;
import com.trs.cms.process.definition.FlowNodeFields;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.cms.process.definition.FlowOptMarkEnumParser;
import com.trs.cms.process.definition.FlowRule;
import com.trs.cms.process.definition.FlowRules;
import com.trs.cms.process.definition.IFlowRuleCacheServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverterByDOM4j;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.DBType;
import org.apache.log4j.Logger;

public class FlowImporter {
    private static Logger s_logger = Logger.getLogger(FlowImporter.class);
    private IFlowRuleCacheServer m_oRuleCacheServer = (IFlowRuleCacheServer)DreamFactory.createObjectById("IFlowRuleCacheServer");
    private XmlToObjConverterByDOM4j m_converter;
    private Reports m_reports;
    private static final String PROPERTY_CRTIME = "CRTIME";
    private static final String PROPERTY_CRUSER = "CRUSER";
    private static final char CHAR_S = 'S';
    private static final String TAG_NODES = "WCMFLOWNODES";
    private static final String TAG_BRANCHS = "WCMFLOWBRANCHS";
    private static final String TAG_NODE_FIELDS = "XWCMFLOWNODEFIELDS";
    private static final String TAG_RULES = "XWCMFLOWRULES";
    private static final String TAG_CONDITIONS = "XWCMFLOWCONDITIONS";
    private static final String TAG_ACTIONS = "XWCMFLOWACTIONS";
    private static final String TAG_USERS = "WCMUSERS";
    private static final String TAG_GROUPS = "WCMGROUPS";
    private boolean m_bUpdateMode = false;
    private User m_oLoginUser = null;
    public int m_nCurrFlowId = 0;
    private boolean m_bImportWithFlowNodeFields = false;
    private boolean m_bImportWithOptMarkEnum = false;
    private boolean m_bImportWithInfoviewId = false;
    private CMSObj m_oOwner = null;

    public FlowImporter(int n) {
        this.m_converter = new XmlToObjConverterByDOM4j(n);
        this.m_bUpdateMode = 1 != n;
        this.registerConverter();
    }

    public FlowImporter(User user, int n) {
        this.m_oLoginUser = user;
        this.m_converter = new XmlToObjConverterByDOM4j(n);
        this.m_bUpdateMode = 1 != n;
        this.registerConverter();
    }

    public Reports importFromFile(String string, String string2) throws WCMException {
        this.assertNotEmptyString(string);
        this.assertUnSupportFile(string);
        String string3 = this.getFullName(string);
        if (string2 != null) {
            string2 = this.getFullName(string2);
        }
        XmlObject[] xmlObjectArray = this.m_converter.convertXml(string3, string2, null);
        this.m_reports = new Reports(I18NMessage.get(FlowImporter.class, "FlowImporter.label1", "\u5bfc\u5165\u5de5\u4f5c\u6d41"));
        int[] nArray = new int[xmlObjectArray.length];
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importFlowInfo(xmlObjectArray[i]);
            nArray[i] = this.m_nCurrFlowId;
        }
        this.m_reports.setResultIds(nArray);
        return this.m_reports;
    }

    public Reports importFromXMLContent(String string) throws WCMException {
        XmlObject[] xmlObjectArray = this.m_converter.convertXml(string, null);
        this.m_reports = new Reports(I18NMessage.get(FlowImporter.class, "FlowImporter.label1", "\u5bfc\u5165"));
        int[] nArray = new int[xmlObjectArray.length];
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            this.importFlowInfo(xmlObjectArray[i]);
            nArray[i] = this.m_nCurrFlowId;
        }
        this.m_reports.setResultIds(nArray);
        return this.m_reports;
    }

    public Reports importFromXMLObj(XmlObject xmlObject) throws WCMException {
        this.m_reports = new Reports(I18NMessage.get(FlowImporter.class, "FlowImporter.label1", "\u5bfc\u5165"));
        this.importFlowInfo(xmlObject);
        return this.m_reports;
    }

    private void assertNotEmptyString(String string) throws WCMException {
        if (string == null || string.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(FlowImporter.class, "FlowImporter.label2", "\u65e0\u6548\u7684\u6587\u4ef6\u540d!"));
        }
    }

    private void assertUnSupportFile(String string) throws WCMException {
        String string2 = CMyFile.extractFileExt(string);
        if (!"xml".equalsIgnoreCase(string2)) {
            throw new WCMException(1200, I18NMessage.get(FlowImporter.class, "FlowImporter.label3", "\u53ea\u652f\u6301\u4eceXML\u6587\u4ef6\u4e2d\u5bfc\u5165\u5de5\u4f5c\u6d41\u7684\u914d\u7f6e!"));
        }
    }

    private String getFullName(String string) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(string)) {
            String string2 = filesMan.mapFilePath(string, 0);
            string = string2 + string;
        }
        return string;
    }

    private void importFlowInfo(XmlObject xmlObject) {
        Flow flow = null;
        try {
            flow = (Flow)xmlObject.getCurrentObj();
            if (flow == null) {
                s_logger.error((Object)"failed to parse the flow object!");
                this.m_reports.addFailedReport(I18NMessage.get(FlowImporter.class, "FlowImporter.label4", "\u5bfc\u5165\u5de5\u4f5c\u6d41[\u65e0\u6cd5\u89e3\u6790\u7684XML\u8282\u70b9]\u5931\u8d25\uff01"), new WCMException(I18NMessage.get(FlowImporter.class, "FlowImporter.label5", "\u65e0\u6cd5\u8bc6\u522b\u7684\u5bf9\u8c61\u5c5e\u6027\uff01-->") + xmlObject));
                return;
            }
            this.removePropertyIfNecessary(flow);
            boolean bl = flow.isAddMode();
            if (!bl) {
                flow.validCanEditAndLock(this.m_oLoginUser);
            } else {
                if (this.m_oOwner != null) {
                    flow.setOwner(this.m_oOwner.getWCMType(), this.m_oOwner.getId());
                }
                if (!this.m_bImportWithInfoviewId) {
                    flow.getProperties().remove("INFOVIEWID");
                }
            }
            this.changeFlowNameIfNescessary(flow);
            if (!bl && this.isImportWithOptMarkEnum()) {
                flow = this.fillFLowOptMarkEnum(flow);
            }
            flow.save(this.m_oLoginUser);
            XmlObject[] xmlObjectArray = xmlObject.getChild(TAG_RULES);
            this.importRules(xmlObjectArray, flow);
            XmlObject[] xmlObjectArray2 = xmlObject.getChild(TAG_NODES);
            this.importNodes(xmlObjectArray2, flow.getId());
            this.m_reports.addSucessedReport(I18NMessage.get(FlowImporter.class, "FlowImporter.label6", "\u5bfc\u5165[") + flow + I18NMessage.get(FlowImporter.class, "FlowImporter.label7", "]\u6210\u529f!"));
            this.m_nCurrFlowId = flow.getId();
            if (bl && this.isImportWithOptMarkEnum()) {
                flow = this.fillFLowOptMarkEnum(flow);
                flow.save();
            }
        }
        catch (Throwable throwable) {
            s_logger.error((Object)"failed to save the flow object!", throwable);
            this.m_reports.addFailedReport(I18NMessage.get(FlowImporter.class, "FlowImporter.label9", "\u5bfc\u5165[") + flow + I18NMessage.get(FlowImporter.class, "FlowImporter.label8", "]\u5931\u8d25!"), throwable);
        }
    }

    private Flow fillFLowOptMarkEnum(Flow flow) throws WCMException {
        String string = FlowOptMarkEnumParser.getFlowOptMarkEnum(flow);
        if (!CMyString.isEmpty(string)) {
            flow.setProperty("OperationMarkEnum", string);
        }
        return flow;
    }

    private void changeFlowNameIfNescessary(Flow flow) throws Throwable {
        String string = flow.getName();
        if (flow.isChangeProperty("FLOWNAME")) {
            string = flow.getNewPropertyAsString("FLOWNAME");
        }
        int n = flow.getOwnerType();
        int n2 = flow.getOwnerId();
        String string2 = string.trim();
        int n3 = 0;
        while (this.exists(string2, n, n2, flow.getId())) {
            string2 = string + "_" + n3;
            ++n3;
        }
        flow.setName(string2);
    }

    private boolean exists(String string, int n, int n2, int n3) throws Throwable {
        WCMFilter wCMFilter = new WCMFilter("WCMFlow", "FlowName=? and OwnerType=? and OwnerId=? and FlowId<>?", "", "FlowId");
        wCMFilter.addSearchValues(string);
        wCMFilter.addSearchValues(n);
        wCMFilter.addSearchValues(n2);
        wCMFilter.addSearchValues(n3);
        return DBManager.getDBManager().sqlExecuteIntQuery(wCMFilter) > 0;
    }

    private void importNodes(XmlObject[] xmlObjectArray, int n) throws Throwable {
        int n2;
        int[] nArray = new int[xmlObjectArray.length];
        for (n2 = 0; n2 < xmlObjectArray.length; ++n2) {
            nArray[n2] = xmlObjectArray[n2].getCurrentObj().getId();
        }
        this.clearUnUsedNodeWhenUpdate(n, nArray);
        for (n2 = 0; n2 < xmlObjectArray.length; ++n2) {
            this.importNodeInfo(xmlObjectArray[n2], n);
        }
    }

    private FlowNode importNodeInfo(XmlObject xmlObject, int n) throws Throwable {
        FlowNode flowNode = (FlowNode)xmlObject.getCurrentObj();
        if (flowNode.isAddMode()) {
            flowNode.setFlow(n);
        } else {
            flowNode.validCanEditAndLock(this.m_oLoginUser);
        }
        this.removePropertyIfNecessary(flowNode);
        flowNode.save(this.m_oLoginUser);
        this.clearNodeOperInfos(flowNode.getId());
        this.importOperUsers(xmlObject.getChild(TAG_USERS), flowNode.getId());
        this.importOperGroups(xmlObject.getChild(TAG_GROUPS), flowNode.getId());
        this.importBranchs(xmlObject.getChild(TAG_BRANCHS), flowNode.getId());
        this.importRules(xmlObject.getChild(TAG_RULES), flowNode);
        if (this.isImportWithFlowNodeFields()) {
            this.importNodeFields(xmlObject.getChild(TAG_NODE_FIELDS), flowNode);
        }
        this.m_oRuleCacheServer.reloadRuleCache(flowNode);
        return flowNode;
    }

    private void clearNodeOperInfos(int n) throws Throwable {
        String string = "DELETE FROM WCMFLOWNODEOPER WHERE NodeId=" + n;
        DBManager.getDBManager().sqlExecuteUpdate(string);
    }

    private void importOperUsers(XmlObject[] xmlObjectArray, int n) throws Throwable {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            User user = (User)xmlObjectArray[i].getCurrentObj();
            if (user.getPropertyAsString("UserName") != null) {
                String string = user.getPropertyAsString("UserName");
                if ((user = User.findByName(string)) == null || user.isDeleted() || user.getStatus() != 30) continue;
                this.importOperInfo(n, user.getId(), 204);
                continue;
            }
            this.importOperInfo(n, user.getPropertyAsInt("USERID", 0), 204);
        }
    }

    private void importOperGroups(XmlObject[] xmlObjectArray, int n) throws Throwable {
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            Group group = (Group)xmlObjectArray[i].getCurrentObj();
            this.importOperInfo(n, group.getPropertyAsInt("GROUPID", 0), 201);
        }
    }

    private void importOperInfo(int n, int n2, int n3) throws Throwable {
        DBManager dBManager = DBManager.getDBManager();
        DBType dBType = dBManager.getDBType();
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO WCMFLOWNODEOPER");
        stringBuffer.append('(');
        stringBuffer.append("NODEID");
        stringBuffer.append(',');
        stringBuffer.append("OPERTYPE");
        stringBuffer.append(',');
        stringBuffer.append("OPERID");
        stringBuffer.append(',');
        stringBuffer.append(PROPERTY_CRUSER);
        stringBuffer.append(',');
        stringBuffer.append(PROPERTY_CRTIME);
        stringBuffer.append(')');
        stringBuffer.append(" VALUES(");
        stringBuffer.append(n);
        stringBuffer.append(',');
        stringBuffer.append(n3);
        stringBuffer.append(',');
        stringBuffer.append(n2);
        stringBuffer.append(',');
        stringBuffer.append('\'');
        stringBuffer.append(CMyString.filterForSQL(this.getLoginUser().getName()));
        stringBuffer.append('\'');
        stringBuffer.append(',');
        stringBuffer.append(dBType.sqlGetSysDate());
        stringBuffer.append(')');
        dBManager.sqlExecuteUpdate(stringBuffer.toString());
    }

    private void clearUnUsedNodeWhenUpdate(int n, int[] nArray) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter wCMFilter = new WCMFilter("WCMFLOWNODE", "FlowId=" + n, "");
        this.clearUnUsedDataWhenUpdate(FlowNodes.class, wCMFilter, nArray);
    }

    private void importBranchs(XmlObject[] xmlObjectArray, int n) throws Throwable {
        int[] nArray = new int[xmlObjectArray.length];
        for (int i = 0; i < xmlObjectArray.length; ++i) {
            FlowNodeBranch flowNodeBranch = this.importBranchInfo(xmlObjectArray[i], n);
            if (flowNodeBranch == null) continue;
            nArray[i] = flowNodeBranch.getId();
        }
        this.clearUnUsedBranchsWhenUpdate(n, nArray);
    }

    private FlowNodeBranch importBranchInfo(XmlObject xmlObject, int n) throws Throwable {
        FlowNodeBranch flowNodeBranch = (FlowNodeBranch)xmlObject.getCurrentObj();
        if (flowNodeBranch.isAddMode()) {
            flowNodeBranch.setNode(n);
        } else {
            flowNodeBranch.validCanEditAndLock(this.m_oLoginUser);
        }
        this.removePropertyIfNecessary(flowNodeBranch);
        flowNodeBranch.canEdit(this.getLoginUser());
        flowNodeBranch.save(this.m_oLoginUser);
        this.importRules(xmlObject.getChild(TAG_RULES), flowNodeBranch);
        return flowNodeBranch;
    }

    private void clearUnUsedBranchsWhenUpdate(int n, int[] nArray) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter wCMFilter = new WCMFilter("WCMFLOWBRANCH", "NodeId=" + n, "");
        this.clearUnUsedDataWhenUpdate(FlowNodeBranchs.class, wCMFilter, nArray);
    }

    private void clearUnUsedDataWhenUpdate(Class clazz, WCMFilter wCMFilter, int[] nArray) throws Throwable {
        User user = this.getLoginUser();
        CMSBaseObjs cMSBaseObjs = CMSBaseObjs.openWCMObjs(user, clazz, wCMFilter);
        CMSBaseObjs cMSBaseObjs2 = this.getUsedDatas(clazz, nArray);
        if (cMSBaseObjs2 != null) {
            cMSBaseObjs.minusWith(cMSBaseObjs2);
        }
        cMSBaseObjs.removeAll(true);
    }

    private CMSBaseObjs getUsedDatas(Class clazz, int[] nArray) throws Throwable {
        String string = ",";
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n == 0) continue;
            string = string + n + ",";
        }
        if (string.length() > 2) {
            string = string.substring(1, string.length());
            return CMSBaseObjs.findWCMObjsByIds(this.getLoginUser(), clazz, string);
        }
        return null;
    }

    private void registerConverter() {
        this.m_converter.registPersistentObj("WCMFLOW", Flow.class);
        this.m_converter.registPersistentObj("WCMFLOWNODE", FlowNode.class);
        this.m_converter.registPersistentObj("WCMUSER", User.class);
        this.m_converter.registPersistentObj("WCMGROUP", Group.class);
        this.m_converter.registPersistentObj("WCMFLOWBRANCH", FlowNodeBranch.class);
        this.m_converter.registPersistentObj("XWCMFLOWRULE", FlowRule.class);
        this.m_converter.registPersistentObj("XWCMFLOWCONDITION", FlowCondition.class);
        this.m_converter.registPersistentObj("XWCMFLOWACTION", FlowAction.class);
        this.m_converter.registPersistentObj("XWCMFLOWNODEFIELD", FlowNodeField.class);
    }

    private void removePropertyIfNecessary(BaseObj baseObj) {
        if (baseObj.isAddMode()) {
            baseObj.removeProperty(PROPERTY_CRTIME);
            baseObj.removeProperty(PROPERTY_CRUSER);
        }
    }

    private User getLoginUser() {
        return this.m_oLoginUser;
    }

    private void importRules(XmlObject[] xmlObjectArray, CMSObj cMSObj) throws Throwable {
        int[] nArray = new int[xmlObjectArray.length];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < xmlObjectArray.length) {
            FlowRule flowRule = this.importRule(xmlObjectArray[n2], cMSObj, n);
            if (flowRule != null) {
                nArray[n2] = flowRule.getId();
            }
            ++n2;
            --n;
        }
        this.clearUnUsedRulesWhenUpdate(nArray, cMSObj);
    }

    private FlowRule importRule(XmlObject xmlObject, CMSObj cMSObj, int n) throws Throwable {
        FlowRule flowRule = (FlowRule)xmlObject.getCurrentObj();
        if (flowRule.isAddMode()) {
            flowRule.setHostType(cMSObj.getWCMType());
            flowRule.setHostId(cMSObj.getId());
        } else {
            flowRule.validCanEditAndLock(this.m_oLoginUser);
        }
        flowRule.setOrder(n);
        this.removePropertyIfNecessary(flowRule);
        flowRule.save(this.m_oLoginUser);
        this.importConditions(xmlObject.getChild(TAG_CONDITIONS), flowRule);
        this.importActions(xmlObject.getChild(TAG_ACTIONS), flowRule);
        return flowRule;
    }

    private void clearUnUsedRulesWhenUpdate(int[] nArray, CMSObj cMSObj) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter wCMFilter = new WCMFilter("XWCMFLOWRULE", "HostType=? and HostId=?", "");
        wCMFilter.addSearchValues(cMSObj.getWCMType());
        wCMFilter.addSearchValues(cMSObj.getId());
        this.clearUnUsedDataWhenUpdate(FlowRules.class, wCMFilter, nArray);
    }

    private void importConditions(XmlObject[] xmlObjectArray, FlowRule flowRule) throws Throwable {
        int[] nArray = new int[xmlObjectArray.length];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < xmlObjectArray.length) {
            FlowCondition flowCondition = this.importCondition(xmlObjectArray[n2], flowRule, n);
            if (flowCondition != null) {
                nArray[n2] = flowCondition.getId();
            }
            ++n2;
            --n;
        }
        this.clearUnUsedConditionsWhenUpdate(nArray, flowRule);
    }

    private FlowCondition importCondition(XmlObject xmlObject, FlowRule flowRule, int n) throws Throwable {
        FlowCondition flowCondition = (FlowCondition)xmlObject.getCurrentObj();
        if (flowCondition.isAddMode()) {
            flowCondition.setRuleId(flowRule.getId());
        } else {
            flowCondition.validCanEditAndLock(this.m_oLoginUser);
        }
        flowCondition.setOrder(n);
        this.removePropertyIfNecessary(flowCondition);
        flowCondition.save(this.m_oLoginUser);
        return flowCondition;
    }

    private void clearUnUsedConditionsWhenUpdate(int[] nArray, CMSObj cMSObj) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter wCMFilter = new WCMFilter("XWCMFLOWCONDITION", "RuleId=?", "");
        wCMFilter.addSearchValues(cMSObj.getId());
        this.clearUnUsedDataWhenUpdate(FlowConditions.class, wCMFilter, nArray);
    }

    private void importActions(XmlObject[] xmlObjectArray, FlowRule flowRule) throws Throwable {
        int[] nArray = new int[xmlObjectArray.length];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < xmlObjectArray.length) {
            FlowAction flowAction = this.importAction(xmlObjectArray[n2], flowRule, n);
            if (flowAction != null) {
                nArray[n2] = flowAction.getId();
            }
            ++n2;
            --n;
        }
        this.clearUnUsedActionsWhenUpdate(nArray, flowRule);
    }

    private FlowAction importAction(XmlObject xmlObject, FlowRule flowRule, int n) throws Throwable {
        FlowAction flowAction = (FlowAction)xmlObject.getCurrentObj();
        if (flowAction.isAddMode()) {
            flowAction.setRuleId(flowRule.getId());
        } else {
            flowAction.validCanEditAndLock(this.m_oLoginUser);
        }
        flowAction.setOrder(n);
        this.removePropertyIfNecessary(flowAction);
        flowAction.save(this.m_oLoginUser);
        return flowAction;
    }

    private void clearUnUsedActionsWhenUpdate(int[] nArray, CMSObj cMSObj) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter wCMFilter = new WCMFilter("XWCMFLOWACTION", "RuleId=?", "");
        wCMFilter.addSearchValues(cMSObj.getId());
        this.clearUnUsedDataWhenUpdate(FlowActions.class, wCMFilter, nArray);
    }

    private void importNodeFields(XmlObject[] xmlObjectArray, FlowNode flowNode) throws Throwable {
        int[] nArray = new int[xmlObjectArray.length];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < xmlObjectArray.length) {
            FlowNodeField flowNodeField = this.importNodeField(xmlObjectArray[n2], flowNode);
            if (flowNodeField != null) {
                nArray[n2] = flowNodeField.getId();
            }
            ++n2;
            --n;
        }
        this.clearUnUsedNodeFieldsWhenUpdate(nArray, flowNode);
    }

    private FlowNodeField importNodeField(XmlObject xmlObject, FlowNode flowNode) throws Throwable {
        FlowNodeField flowNodeField = (FlowNodeField)xmlObject.getCurrentObj();
        if (flowNodeField.isAddMode()) {
            flowNodeField.setFlowId(flowNode.getFlowId());
            flowNodeField.setNodeId(flowNode.getId());
        } else {
            flowNodeField.validCanEditAndLock(this.m_oLoginUser);
        }
        this.removePropertyIfNecessary(flowNodeField);
        flowNodeField.save(this.m_oLoginUser);
        return flowNodeField;
    }

    private void clearUnUsedNodeFieldsWhenUpdate(int[] nArray, FlowNode flowNode) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter wCMFilter = new WCMFilter("XWCMFLOWNODEFIELD", "NodeId=?", "");
        wCMFilter.setPageSize(500);
        wCMFilter.addSearchValues(flowNode.getId());
        this.clearUnUsedDataWhenUpdate(FlowNodeFields.class, wCMFilter, nArray);
    }

    public CMSObj getOwner() {
        return this.m_oOwner;
    }

    public void setOwner(CMSObj cMSObj) {
        this.m_oOwner = cMSObj;
    }

    public boolean isImportWithFlowNodeFields() {
        return this.m_bImportWithFlowNodeFields;
    }

    public void setImportWithFlowNodeFields(boolean bl) {
        this.m_bImportWithFlowNodeFields = bl;
    }

    public boolean isImportWithOptMarkEnum() {
        return this.m_bImportWithOptMarkEnum;
    }

    public void setImportWithOptMarkEnum(boolean bl) {
        this.m_bImportWithOptMarkEnum = bl;
    }

    public void setImportWithInfoviewId(boolean bl) {
        this.m_bImportWithInfoviewId = bl;
    }

    public boolean isImportWithInfoviewId() {
        return this.m_bImportWithInfoviewId;
    }
}

