/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.infra.common.WCMException;

public class ContentProcessInfo {
    private boolean m_bEnd = false;
    private User m_oStartUser = null;
    private String m_sStartUserName = null;
    private Flow m_oContentFlow = null;
    private IFlowContent m_oContent = null;
    private Users m_oCurrToUsers = null;

    public ContentProcessInfo(boolean bl, Flow flow, User user) {
        this.m_bEnd = bl;
        this.m_oStartUser = user;
        this.m_sStartUserName = this.m_oStartUser.getName();
        this.m_oContentFlow = flow;
    }

    public ContentProcessInfo(boolean bl, Flow flow, String string) {
        this.m_bEnd = bl;
        this.m_sStartUserName = string;
        this.m_oContentFlow = flow;
    }

    public ContentProcessInfo(boolean bl, IFlowContent iFlowContent, String string) throws WCMException {
        this.m_bEnd = bl;
        this.m_sStartUserName = string;
        this.m_oContent = iFlowContent;
        this.m_oContentFlow = this.m_oContent.getOwnerFlow();
    }

    public ContentProcessInfo(boolean bl, IFlowContent iFlowContent, String string, Users users) throws WCMException {
        this.m_bEnd = bl;
        this.m_sStartUserName = string;
        this.m_oContent = iFlowContent;
        this.m_oContentFlow = this.m_oContent.getOwnerFlow();
        this.m_oCurrToUsers = users;
    }

    public boolean isEnd() {
        return this.m_bEnd;
    }

    public void setEnd(boolean bl) {
        this.m_bEnd = bl;
    }

    public Users getCurrToUses() {
        return this.m_oCurrToUsers;
    }

    public void setCurrToUses(Users users) {
        this.m_oCurrToUsers = users;
    }

    public User getStartUser() {
        if (this.m_oStartUser == null && this.m_sStartUserName != null) {
            this.m_oStartUser = User.findByName(this.m_sStartUserName);
            if (this.m_oStartUser == null) {
                this.m_sStartUserName = null;
            }
        }
        return this.m_oStartUser;
    }

    public void setStartUser(User user) {
        this.m_oStartUser = user;
    }

    public String getStartUserName() {
        return this.m_sStartUserName;
    }

    public void setStartUserName(String string) {
        this.m_sStartUserName = string;
    }

    public Flow getContentFlow() throws WCMException {
        if (this.m_oContentFlow == null) {
            this.m_oContentFlow = this.m_oContent.getOwnerFlow();
        }
        return this.m_oContentFlow;
    }

    public void setContentFlow(Flow flow) {
        this.m_oContentFlow = flow;
    }

    public int getContentFlowId() {
        if (this.m_oContentFlow == null) {
            return 0;
        }
        return this.m_oContentFlow.getId();
    }

    public IFlowContent getContent() {
        return this.m_oContent;
    }

    public void setContent(IFlowContent iFlowContent) {
        this.m_oContent = iFlowContent;
    }

    public boolean canReInFlow() throws WCMException {
        if (this.getContentFlow() == null) {
            return false;
        }
        if (!this.isEnd()) {
            return false;
        }
        return this.m_sStartUserName != null && this.m_sStartUserName.length() > 0;
    }

    public boolean canInFlow() throws WCMException {
        if (this.getContentFlow() == null) {
            return false;
        }
        return this.m_sStartUserName == null || this.m_sStartUserName.length() == 0;
    }

    public boolean canStopFlow() {
        if (this.isEnd()) {
            return false;
        }
        return this.m_sStartUserName != null && this.m_sStartUserName.length() > 0;
    }
}

