/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.config;

import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.config.FlowContentField;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;

public class FlowContentTypeConfig {
    private String m_sName = null;
    private String m_sDesc = null;
    private String m_sDBTableName = null;
    private String m_sClassName = null;
    private Class m_oContentClass = null;
    private FlowContentField[] m_pContentFields = new FlowContentField[0];
    private int m_nContentType = -1;

    public String getClassName() {
        return this.m_sClassName;
    }

    public void setClassName(String string) throws WCMException {
        if (string == null || string.length() == 0) {
            throw new WCMException(1106, I18NMessage.get(FlowContentTypeConfig.class, "FlowContentTypeConfig.label1", "\u6ca1\u6709\u6307\u5b9aClassName\uff01"));
        }
        this.m_sClassName = string;
        try {
            this.m_oContentClass = Class.forName(string);
        }
        catch (Exception exception) {
            throw new WCMException(13, string + I18NMessage.get(FlowContentTypeConfig.class, "FlowContentTypeConfig.label2", "-->Class\u6709\u8bef\uff01"), exception);
        }
        try {
            Object t = this.m_oContentClass.newInstance();
            if (!(t instanceof IFlowContent)) {
                throw new WCMException(2, string + I18NMessage.get(FlowContentTypeConfig.class, "FlowContentTypeConfig.label3", "\u4e0d\u662f") + IFlowContent.class.getName() + I18NMessage.get(FlowContentTypeConfig.class, "FlowContentTypeConfig.label4", "\u7684\u5b9e\u73b0\uff01"));
            }
            this.m_nContentType = ((IFlowContent)t).getContentType();
        }
        catch (Exception exception) {
            throw new WCMException(12, string + I18NMessage.get(FlowContentTypeConfig.class, "FlowContentTypeConfig.label5", ".newInstance\u6709\u8bef\uff01"), exception);
        }
    }

    public String getDBTableName() {
        return this.m_sDBTableName;
    }

    public void setDBTableName(String string) {
        this.m_sDBTableName = string;
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String string) {
        this.m_sDesc = string;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String string) {
        this.m_sName = string;
    }

    public String toString() {
        return this.getClass().getName() + "(Name=" + this.m_sName + ", ClassName=" + this.m_sClassName + ")@" + Integer.toHexString(this.hashCode());
    }

    public FlowContentField[] getContentFields() {
        return this.m_pContentFields;
    }

    public void setContentFields(FlowContentField[] flowContentFieldArray) {
        this.m_pContentFields = flowContentFieldArray;
    }

    public void addContentField(FlowContentField flowContentField) {
        int n = this.m_pContentFields.length;
        FlowContentField[] flowContentFieldArray = new FlowContentField[n + 1];
        if (n > 0) {
            System.arraycopy(this.m_pContentFields, 0, flowContentFieldArray, 0, n);
        }
        flowContentFieldArray[n] = flowContentField;
        this.m_pContentFields = flowContentFieldArray;
    }

    public int getContentType() {
        return this.m_nContentType;
    }

    public Class getContentClass() {
        return this.m_oContentClass;
    }
}

