/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowNotifyWorker;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.engine.FlowContentHelper;
import com.trs.cms.process.engine.FlowContextOld;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocBak;
import com.trs.cms.process.engine.FlowDocBaks;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.cms.process.engine.FlowParamers;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class FlowServer
extends BaseServer {
    private static Logger s_logger = Logger.getLogger(FlowServer.class);
    public static boolean IS_DEBUG = false;
    Hashtable hFlowDocs = new Hashtable();
    Hashtable hConditionBeans = new Hashtable();
    Hashtable hOperateBeans = new Hashtable();
    IFlowNotifyWorker m_oNotify = null;

    public FlowServer() {
        try {
            this.m_oNotify = (IFlowNotifyWorker)DreamFactory.createObjectById("Flow.Notify.Worker");
        }
        catch (Throwable throwable) {
            this.m_oNotify = null;
        }
    }

    public static FlowServer getFlowServer() throws WCMException {
        FlowServer flowServer = (FlowServer)DreamFactory.createObjectById("FlowServer");
        if (flowServer == null) {
            throw new WCMException(I18NMessage.get(FlowServer.class, "FlowServer.label1", "FlowServer\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!flowServer.isStarted()) {
            flowServer.startup();
        }
        return flowServer;
    }

    private String makeTrialCacheKey(FlowDoc flowDoc) {
        return this.makeTrialCacheKey(flowDoc.getContentType(), flowDoc.getContentId());
    }

    private String makeTrialCacheKey(int n, int n2) {
        return n + "." + n2;
    }

    private void putFlowDocIntoBuffer(FlowDoc flowDoc) {
        this.hFlowDocs.put(this.makeTrialCacheKey(flowDoc), flowDoc);
    }

    private void putFlowDocIntoBuffer(FlowDoc flowDoc, User user) {
        IFlowContent iFlowContent = null;
        try {
            iFlowContent = FlowContentHelper.createFlowContent(flowDoc.getContentType(), flowDoc.getId());
        }
        catch (WCMException wCMException) {
            s_logger.error((Object)(I18NMessage.get(FlowServer.class, "FlowServer.label2", "\u6d41\u8f6c\u6587\u6863\u5931\u8d25\uff01\u83b7\u53d6FlowContent\u51fa\u73b0\u5f02\u5e38\uff01 Type\uff1a[") + flowDoc.getContentType() + "] Id\uff1a[" + flowDoc.getContentId() + "]"), (Throwable)wCMException);
        }
        if (iFlowContent == null) {
            s_logger.error((Object)(I18NMessage.get(FlowServer.class, "FlowServer.label3", "\u6d41\u8f6c\u6587\u6863\u5931\u8d25\uff01\u627e\u4e0d\u5230\u6307\u5b9a\u7684FlowContent Type\uff1a[") + flowDoc.getContentType() + "] Id\uff1a[" + flowDoc.getContentId() + "]"));
            return;
        }
        this.hFlowDocs.put(this.makeTrialCacheKey(flowDoc), flowDoc);
        try {
            FlowNode flowNode = flowDoc.getNode();
            User user2 = User.getSystem();
            if (user != null) {
                user2 = user;
            }
            FlowContextOld flowContextOld = new FlowContextOld(iFlowContent, flowNode, user2);
        }
        catch (Exception exception) {
            s_logger.error((Object)(I18NMessage.get(FlowServer.class, "FlowServer.label4", "\u5904\u7406\u8282\u70b9\u8fdb\u5165\u540e\u7684\u4e8b\u4ef6\u5931\u8d25\uff01FlowDoc\u7684ID\u4e3a[") + flowDoc.getId() + "]"), (Throwable)exception);
        }
    }

    private FlowServer start() throws WCMException {
        return this;
    }

    public FlowDoc getFlowDoc(int n, int n2) {
        FlowDoc flowDoc = (FlowDoc)this.hFlowDocs.get(this.makeTrialCacheKey(n, n2));
        return flowDoc;
    }

    public FlowDoc getFlowDoc(IFlowContent iFlowContent) throws WCMException {
        if (iFlowContent == null) {
            throw new WCMException(10, I18NMessage.get(FlowServer.class, "FlowServer.label6", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61\uff08JobServer.getFlowDoc\uff09"));
        }
        return this.getFlowDoc(iFlowContent.getContentType(), iFlowContent.getSubinstanceId());
    }

    public FlowDoc removeFlowDoc(int n, int n2) throws WCMException {
        return this.removeFlowDoc(n, n2, User.getSystem());
    }

    public FlowDoc removeFlowDoc(int n, int n2, User user) throws WCMException {
        FlowDoc flowDoc = (FlowDoc)this.hFlowDocs.remove(this.makeTrialCacheKey(n, n2));
        if (flowDoc == null) {
            return null;
        }
        FlowNode flowNode = flowDoc.getNode();
        User user2 = user;
        if (user2 == null) {
            user2 = User.getSystem();
        }
        String string = "update WCMFlowDocBak set Flag=" + flowDoc.getFlag() + " where ObjType=" + flowDoc.getContentType() + " and Objid=" + flowDoc.getContentId() + " and (flag=" + 1 + " or flag=" + 2 + ")";
        DBManager.getDBManager().sqlExecuteUpdate(string);
        flowDoc.delete(user2);
        IFlowContent iFlowContent = FlowContentHelper.createFlowContent(n, n2);
        FlowContextOld flowContextOld = new FlowContextOld(iFlowContent, flowNode, user2);
        if (flowNode != null) {
            // empty if block
        }
        return flowDoc;
    }

    public FlowDoc removeFlowDoc(IFlowContent iFlowContent, User user) throws WCMException {
        if (iFlowContent == null) {
            throw new WCMException(10, I18NMessage.get(FlowServer.class, "FlowServer.label7", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61\uff08FlowServer.removeFlowDoc\uff09"));
        }
        return this.removeFlowDoc(iFlowContent.getContentType(), iFlowContent.getSubinstanceId(), user);
    }

    public FlowDoc removeFlowDoc(IFlowContent iFlowContent) throws WCMException {
        if (iFlowContent == null) {
            throw new WCMException(10, I18NMessage.get(FlowServer.class, "FlowServer.label7", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61\uff08FlowServer.removeFlowDoc\uff09"));
        }
        return this.removeFlowDoc(iFlowContent.getContentType(), iFlowContent.getSubinstanceId(), User.getSystem());
    }

    public FlowDoc startContentInFlow(User user, IFlowContent iFlowContent) throws WCMException {
        return this.startContentInFlow(user, iFlowContent, I18NMessage.get(FlowServer.class, "FlowServer.label8", "\u7cfb\u7edf\u81ea\u52a8\u63d0\u4ea4"));
    }

    public boolean isCanInFlow(IFlowContent iFlowContent) throws WCMException {
        Flow flow = iFlowContent.getOwnerFlow();
        if (flow == null) {
            return false;
        }
        FlowDoc flowDoc = this.getFlowDoc(iFlowContent);
        return flowDoc == null;
    }

    public FlowDoc startContentInFlow(User user, IFlowContent iFlowContent, String string) throws WCMException {
        FlowNodeBranch flowNodeBranch;
        if (iFlowContent == null) {
            throw new WCMException(10, I18NMessage.get(FlowServer.class, "FlowServer.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u65e0\u6548\uff08FlowServer.addFlowDoc\uff09"));
        }
        Flow flow = iFlowContent.getOwnerFlow();
        if (flow == null) {
            return null;
        }
        FlowDoc flowDoc = this.getFlowDoc(iFlowContent);
        if (flowDoc != null) {
            s_logger.error((Object)I18NMessage.get(FlowServer.class, "FlowServer.label10", "\u5df2\u7ecf\u5728\u6d41\u8f6c\uff0c\u4e0d\u80fd\u6b63\u5e38\u5f00\u59cb\uff01"));
            return flowDoc;
        }
        FlowNode flowNode = flow.getStartNode();
        FlowNodeBranchs flowNodeBranchs = flowNode.getBranchs(user);
        FlowNodeBranch flowNodeBranch2 = flowNodeBranch = flowNodeBranchs.isEmpty() ? null : (FlowNodeBranch)flowNodeBranchs.getAt(0);
        if (flowNodeBranch == null) {
            return null;
        }
        FlowParamers flowParamers = new FlowParamers();
        flowParamers.setPostUser(user);
        flowParamers.setFlowContent(iFlowContent);
        flowParamers.setToUsers(Users.createNewInstance(user));
        flowParamers.setNextNode(flowNode);
        flowParamers.setOpinion(string);
        flowDoc = this.submitTo(flowParamers);
        flowParamers = new FlowParamers();
        flowParamers.setPostUser(user);
        flowParamers.setFlowContent(iFlowContent);
        flowParamers.setPreNode(flowNode);
        flowParamers.setNextNode(flowNodeBranch.getNextNode(user));
        flowParamers.setOpinion(string);
        flowDoc = this.submitTo(flowParamers);
        return flowDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlowDoc(FlowParamers flowParamers) throws WCMException {
        if (flowParamers.getNextNode().isStartNode() && flowParamers.getPreNode() == null) {
            return;
        }
        IFlowContent iFlowContent = flowParamers.getFlowContent();
        FlowDoc flowDoc = null;
        try {
            flowDoc = this.getFlowDoc(iFlowContent);
            if (flowDoc == null) {
                throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label11", "\u6ca1\u6709\u627e\u5230\u6587\u6863\u5bf9\u5e94\u7684FlowDoc\u5bf9\u8c61\uff08FlowServer.submitDocTo\uff09"));
            }
            if (!flowDoc.canEdit(flowParamers.getPostUser())) {
                throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label12", "\u65e0\u6cd5\u4fee\u6539FlowDoc\u5bf9\u8c61\uff0c\u53ef\u80fd\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4fee\u6539\uff08FlowServer.submitDocTo\uff09"));
            }
            flowDoc.setFlag(5);
            flowDoc.update(flowParamers.getPostUser());
            this.removeFlowDoc(flowParamers.getFlowContent(), flowParamers.getPostUser());
        }
        finally {
            if (flowDoc != null && flowDoc.isLocked()) {
                flowDoc.cancelUpdate(flowParamers.getPostUser());
            }
        }
    }

    private FlowDoc createFlowDoc(FlowParamers flowParamers) throws WCMException {
        FlowNode flowNode = flowParamers.getNextNode();
        FlowDoc flowDoc = null;
        flowDoc = flowNode.isEndNode() ? new FlowDocBak() : new FlowDoc();
        flowDoc.setFlowContent(flowParamers.getFlowContent());
        flowDoc.setFlag(flowNode.isEndNode() ? 18 : flowParamers.getDirection());
        flowDoc.setPreNode(flowParamers.getPreNode());
        flowDoc.setNode(flowNode);
        flowDoc.setPostUser(flowParamers.getPostUser());
        flowDoc.setPostTime(CMyDateTime.now());
        flowDoc.setPostDesc(flowParamers.getOpinion());
        flowDoc.setToUsers(flowParamers.getToUsers().getIdListAsString());
        flowDoc.insert(flowParamers.getPostUser());
        if (!flowNode.isEndNode()) {
            this.putFlowDocIntoBuffer(flowDoc, flowParamers.getPostUser());
        }
        try {
            FlowContextOld flowContextOld = new FlowContextOld(flowParamers.getFlowContent(), flowNode, flowParamers.getPostUser());
        }
        catch (Exception exception) {
            s_logger.error((Object)I18NMessage.get(FlowServer.class, "FlowServer.label13", "\u5904\u7406\u8282\u70b9\u8fdb\u5165\u540e\u7684\u4e8b\u4ef6\u5931\u8d25\uff01"), (Throwable)exception);
        }
        return flowDoc;
    }

    public FlowDoc submitTo(FlowParamers flowParamers) throws WCMException {
        if (flowParamers == null) {
            throw new WCMException(I18NMessage.get(FlowServer.class, "FlowServer.label14", "\u6ca1\u6709\u6307\u5b9a\u7684\u5904\u7406\u53c2\u6570\uff01"));
        }
        flowParamers.validate();
        User user = flowParamers.getPostUser();
        FlowNodeBranch flowNodeBranch = null;
        IFlowContent iFlowContent = flowParamers.getFlowContent();
        try {
            this.updateFlowDoc(flowParamers);
            flowNodeBranch = flowParamers.getBranch();
            if (flowNodeBranch != null) {
                iFlowContent.updateStatus(user, flowNodeBranch.getStatusId());
            }
            Users users = flowParamers.getToUsers();
            this.doOpersOnNodeBranch(iFlowContent, user, flowNodeBranch, users, flowParamers.getNotifyType());
            return this.createFlowDoc(flowParamers);
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label15", "\u5448\u4ea4\u6587\u6863\u5230\u6307\u5b9a\u8282\u70b9\u5931\u8d25\uff08FlowServer.submitDocTo\uff09"), exception);
        }
    }

    private void doOpersOnNodeBranch(IFlowContent iFlowContent, User user, FlowNodeBranch flowNodeBranch, Users users, int n) throws Exception {
        if (users.isEmpty()) {
            return;
        }
        String string = I18NMessage.get(FlowServer.class, "FlowServer.label16", "TRS\u4e1a\u52a1\u8868\u5355\u63d0\u9192-[") + iFlowContent.getDesc() + I18NMessage.get(FlowServer.class, "FlowServer.label17", "]\u9700\u8981\u60a8\u5904\u7406");
        String string2 = "[" + iFlowContent.getDesc() + I18NMessage.get(FlowServer.class, "FlowServer.label18", "]\u9700\u8981\u60a8\u5904\u7406!\n\u8bf7\u70b9\u51fb\u4ee5\u4e0b\u94fe\u63a5\u53ef\u4ee5\u76f4\u63a5\u5904\u7406\uff1a\n<a href=\")test\">\u5904\u7406\u5730\u5740</a>\n\u63d0\u4ea4\u4eba\uff1a") + user.getName();
        this.m_oNotify.addMsgEvent(user, users, string, string2, n);
    }

    public FlowDoc submitBack(User user, IFlowContent iFlowContent, String string) throws WCMException {
        return this.submitBack(user, iFlowContent, string, 3);
    }

    public FlowDoc submitBack(User user, IFlowContent iFlowContent, String string, int n) throws WCMException {
        if (iFlowContent == null) {
            throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label20", "\u6307\u5b9a\u7684\u6587\u6863\u5bf9\u8c61\u65e0\u6548\uff08FlowServer.submitDocTo\uff09"));
        }
        if (!iFlowContent.canEdit(user)) {
            throw new WCMException(1013, I18NMessage.get(FlowServer.class, "FlowServer.label21", "\u65e0\u6cd5\u4fee\u6539\u6587\u6863\uff0c\u53ef\u80fd\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4fee\u6539\uff08FlowServer.submitDocTo\uff09"));
        }
        FlowDoc flowDoc = null;
        FlowDoc flowDoc2 = null;
        boolean bl = false;
        try {
            FlowDoc flowDoc3;
            flowDoc = this.getFlowDoc(iFlowContent);
            if (flowDoc == null) {
                throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label22", "\u5bf9\u8c61[") + iFlowContent.getDesc() + I18NMessage.get(FlowServer.class, "FlowServer.label23", "]\u4e0d\u5728\u6d41\u8f6c\u4e2d\uff01"));
            }
            int n2 = flowDoc.getNodeId();
            FlowDoc flowDoc4 = flowDoc.getPrevious(user, false);
            if (flowDoc4.getNodeId() == n2) {
                while ((flowDoc4 = (flowDoc2 = flowDoc4).getPrevious(user, false)).getNodeId() == n2) {
                }
            } else {
                flowDoc2 = flowDoc;
            }
            if (!flowDoc.canEdit(user)) {
                throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label24", "\u6587\u6863\u5bf9\u5e94\u7684FlowDoc\u5bf9\u8c61\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u4fee\u6539"));
            }
            bl = true;
            flowDoc.setFlag(5);
            flowDoc.update(user);
            bl = false;
            String string2 = null;
            FlowNode flowNode = flowDoc4.getNode();
            if (flowNode.isNeedPostTogether()) {
                int n3 = flowNode.getId();
                flowDoc3 = flowDoc4;
                FlowDoc flowDoc5 = flowDoc3.getPrevious(user, false);
                while (flowDoc5.getNodeId() == n3) {
                    flowDoc3 = flowDoc5;
                    flowDoc5 = flowDoc3.getPrevious(user, false);
                }
                string2 = flowDoc3.getToUserIds();
            } else {
                string2 = String.valueOf(flowDoc2.getPostUser().getId());
            }
            FlowDoc flowDoc6 = new FlowDoc();
            flowDoc6.setFlowContent(iFlowContent);
            flowDoc6.setFlag(2);
            flowDoc6.setPreNode(flowDoc.getNodeId());
            flowDoc6.setNode(flowNode);
            flowDoc6.setToUsers(string2);
            flowDoc6.setPostUser(user);
            flowDoc6.setPostDesc(string);
            flowDoc6.setPostTime(CMyDateTime.now());
            this.removeFlowDoc(iFlowContent, user);
            flowDoc6.insert(user);
            this.putFlowDocIntoBuffer(flowDoc6, user);
            iFlowContent.updateStatus(user, n);
            this.doOpersWhenSubmitDocBack(user, flowDoc6);
            flowDoc3 = flowDoc6;
            return flowDoc3;
        }
        catch (Exception exception) {
            throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label25", "\u6587\u6863\u6253\u56de\u5931\u8d25\uff08FlowServer.submitDocBack\uff09"), exception);
        }
        finally {
            iFlowContent.cancelUpdate(user);
            if (bl && flowDoc != null) {
                flowDoc.cancelUpdate(user);
            }
        }
    }

    private void doOpersWhenSubmitDocBack(User user, FlowDoc flowDoc) {
    }

    public void forceDocToEnd(IFlowContent iFlowContent, User user) throws Exception {
        FlowDoc flowDoc = this.getFlowDoc(iFlowContent);
        if (flowDoc == null) {
            return;
        }
        if (flowDoc.canEdit(User.getSystem())) {
            flowDoc.setFlag(7);
            flowDoc.update(User.getSystem());
        }
        this.removeFlowDoc(iFlowContent, user);
    }

    protected void doShutdown() {
    }

    protected boolean doStart() throws WCMException {
        this.start();
        return true;
    }

    public static Users getConsignUsers(User user, int n) throws WCMException {
        String string = CMyDateTime.now().toString("yyyy-MM-dd");
        String string2 = "wcmTrusteeInfo.StartTime<=" + DBManager.getDBManager().getDBType().sqlDateTime(string + " 23:59:59", "YYYY-MM-DD HH24:MI:SS") + " and wcmTrusteeInfo.EndTime>=" + DBManager.getDBManager().getDBType().sqlDateTime(string + " 00:00:00", "YYYY-MM-DD HH24:MI:SS");
        String string3 = "wcmTrusteeInfo.Status>0 and wcmTrusteeInfo.Trustee=" + user.getId() + " and " + string2 + " and wcmTrusteeInfo.Module=" + n;
        Users users = Users.openWCMObjs(User.getSystem(), new WCMFilter("wcmTrusteeInfo", string3, "", "distinct wcmTrusteeInfo.CrUserId as USERID"));
        return users;
    }

    private String getFlowUserSql(User user) throws WCMException {
        String string = "(" + DBManager.getDBManager().getDBType().sqlConcatStr("','", "wcmFlowDoc.ToUsers", "','") + " like '%," + user.getId() + ",%'";
        Users users = FlowServer.getConsignUsers(user, 1);
        for (int i = 0; i < users.size(); ++i) {
            User user2 = (User)users.getAt(i);
            if (user2 == null) continue;
            string = string + " or " + DBManager.getDBManager().getDBType().sqlConcatStr("','", "wcmFlowDoc.ToUsers", "','") + " like '%," + user2.getId() + ",%'";
        }
        string = string + ")";
        return string;
    }

    public FlowDocs getFlowDocs(User user, int n, WCMFilter wCMFilter) throws WCMException {
        if (n == 1 || n == 2 || n == 0) {
            String string = "wcmFlowDoc.Flag=" + n;
            string = string + " and " + this.getFlowUserSql(user);
            WCMFilter wCMFilter2 = new WCMFilter("", string, "FlowDocId desc");
            if (wCMFilter != null) {
                wCMFilter2.mergeWith(wCMFilter);
            }
            return FlowDocs.openWCMObjs(User.getSystem(), wCMFilter2);
        }
        String string = "WCMFLOWDOCBAK.Flag=" + n;
        string = string + " and POSTUSER='" + CMyString.filterForSQL(user.getName()) + "'";
        WCMFilter wCMFilter3 = new WCMFilter("", string, "FlowDocId desc");
        if (wCMFilter != null) {
            wCMFilter3.mergeWith(wCMFilter);
        }
        FlowDocBaks flowDocBaks = new FlowDocBaks(user);
        flowDocBaks.open(wCMFilter3);
        return flowDocBaks;
    }

    public FlowDocs getSubmitFlowDocs(User user, WCMFilter wCMFilter) throws WCMException {
        String string = " PreNodeId>0 and POSTUSER='" + CMyString.filterForSQL(user.getName()) + "'";
        WCMFilter wCMFilter2 = new WCMFilter("", string, "FlowDocId desc");
        if (wCMFilter != null) {
            wCMFilter2.mergeWith(wCMFilter);
        }
        FlowDocBaks flowDocBaks = new FlowDocBaks(user);
        flowDocBaks.open(wCMFilter2);
        return flowDocBaks;
    }

    public int getCurrFlowFlag(int n, int n2) throws WCMException {
        FlowDoc flowDoc = this.getFlowDoc(n, n2);
        if (flowDoc != null) {
            return flowDoc.getFlag();
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DBManager dBManager = DBManager.getDBManager();
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement("SELECT FLAG FROM WCMFLOWDOCBAK WHERE OBJTYPE=? AND OBJID=? Order by FlowDocId desc");
            preparedStatement.setMaxRows(1);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n3 = resultSet.getInt("FLAG");
                return n3;
            }
            int n4 = 0;
            return n4;
        }
        catch (Exception exception) {
            throw new WCMException(1100, "Failed to get Flow Flag!", exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    s_logger.error((Object)"Failed to close resultSet", (Throwable)exception);
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    s_logger.error((Object)"Failed to close prepared statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
        }
    }

    public FlowDocs getFlowDocsOfContent(int n, int n2) throws WCMException {
        String string = "PreNodeId>0 and ObjType=" + n + " and ObjId=" + n2;
        WCMFilter wCMFilter = new WCMFilter("", string, "FlowDocId Desc");
        FlowDocBaks flowDocBaks = new FlowDocBaks(ContextHelper.getLoginUser());
        flowDocBaks.open(wCMFilter);
        return flowDocBaks;
    }

    public void submitAgain(User user, int n, String string) throws WCMException {
        FlowDoc flowDoc = FlowDoc.findById(n);
        if (flowDoc == null || flowDoc.getFlag() != 2) {
            return;
        }
        FlowDoc flowDoc2 = flowDoc.getPrevious(user, false);
        FlowParamers flowParamers = new FlowParamers();
        flowParamers.setPostUser(user);
        flowParamers.setFlowContent(flowDoc.getContentType(), flowDoc.getContentId());
        flowParamers.setToUsers(flowDoc2.getToUserIds());
        flowParamers.setPreNode(flowDoc.getNodeId());
        flowParamers.setNextNode(flowDoc.getPreNodeId());
        flowParamers.setOpinion(string);
        this.submitTo(flowParamers);
    }
}

