/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.logger;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.logger.IObjLogger;
import com.trs.cms.logger.LogInfo;
import com.trs.infra.common.BaseContextHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.log.Log;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public final class ObjSysLogger {
    private static Logger logger = Logger.getLogger(ObjSysLogger.class);
    private static final String LOGGERIMPL = IObjLogger.class.getName();
    private static final HashMap LOGGERS = new HashMap(20, 0.5f);
    private static final ObjSysLogger INSTANCE = new ObjSysLogger();

    private ObjSysLogger() {
        this.init();
    }

    private void init() {
        IDiscovery iDiscovery = WCMDiscoveryFactory.getDiscovery();
        Iterator iterator = iDiscovery.getImplementors(LOGGERIMPL);
        if (iterator != null) {
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                try {
                    Class<?> clazz = Class.forName(string);
                    IObjLogger iObjLogger = (IObjLogger)clazz.newInstance();
                    Method method = clazz.getMethod("getLogObjType", null);
                    LOGGERS.put(String.valueOf(method.invoke((Object)iObjLogger, null)), iObjLogger);
                }
                catch (Exception exception) {
                    logger.error((Object)("error regesiter obj logger:" + string), (Throwable)exception);
                }
                LOGGERS.remove(String.valueOf(702));
            }
        }
    }

    public static ObjSysLogger instance() {
        return INSTANCE;
    }

    public int startLogInserting(User user, BaseObj baseObj) {
        IObjLogger iObjLogger = (IObjLogger)LOGGERS.get(String.valueOf(baseObj.getWCMType()));
        if (iObjLogger == null) {
            return 0;
        }
        LogInfo logInfo = iObjLogger.makeLogOnAdd(baseObj);
        return this.saveLog(user, baseObj, logInfo);
    }

    public int startLogModifying(User user, BaseObj baseObj) {
        IObjLogger iObjLogger = (IObjLogger)LOGGERS.get(String.valueOf(baseObj.getWCMType()));
        if (iObjLogger == null) {
            return 0;
        }
        LogInfo logInfo = iObjLogger.makeLogOnModify(baseObj);
        return this.saveLog(user, baseObj, logInfo);
    }

    public int startLogDeleting(User user, BaseObj baseObj) {
        IObjLogger iObjLogger = (IObjLogger)LOGGERS.get(String.valueOf(baseObj.getWCMType()));
        if (iObjLogger == null) {
            return 0;
        }
        LogInfo logInfo = iObjLogger.makeLogOnDel(baseObj);
        return this.saveLog(user, baseObj, logInfo);
    }

    private int saveLog(User user, BaseObj baseObj, LogInfo logInfo) {
        if (logInfo == null) {
            return 0;
        }
        try {
            Log log = new Log();
            log.setOpType(logInfo.optype);
            log.setObjName(logInfo.name);
            log.setDesc(logInfo.detail);
            log.setObjType(baseObj.getWCMType());
            log.setObjId(baseObj.getId());
            log.setUser(user.getName());
            log.setLogUserIP(user.getLoginIP());
            log.setTopLogId(ObjSysLogger.getTopLogId());
            long l = System.currentTimeMillis();
            log.setStartTimeMillis(l);
            log.setEndTimeMillis(l);
            log.setLogType(3);
            log.setResult(0);
            log.setOpTime();
            log.save();
            return log.getId();
        }
        catch (WCMException wCMException) {
            logger.error((Object)"Failed to record a log", (Throwable)wCMException);
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append(user);
                stringBuffer.append(" operate on ");
                stringBuffer.append(baseObj);
                stringBuffer.append(". Detail log info:");
                stringBuffer.append(logInfo);
                logger.debug((Object)stringBuffer);
                stringBuffer.setLength(0);
                stringBuffer = null;
            }
            return 0;
        }
    }

    private static int getTopLogId() {
        Integer n = (Integer)BaseContextHelper.getArg(LogServer.CONTEXT_INDEX_TOPID);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void finishLog(int n) {
        this.finishLog(n, null, 0);
    }

    public void finishLog(int n, int n2) {
        this.finishLog(n, null, 0);
    }

    public void finishLog(int n, Throwable throwable) {
        this.finishLog(n, throwable, 0);
    }

    private void finishLog(int n, Throwable throwable, int n2) {
        if (n <= 0) {
            return;
        }
        if (throwable == null) {
            if (n2 > 0) {
                LogServer.endRecordSucceedOperation(n, n2);
            } else {
                LogServer.endRecordSucceedOperation(n);
            }
        } else {
            LogServer.endRecordFailedOperation(n, throwable);
        }
    }
}

