/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyBitsValue;

public class Rights
extends CMSBaseObjs {
    public Rights(User user) {
        super(user);
    }

    public Rights(User user, int n, int n2) {
        super(user, n, n2);
    }

    protected String getDbTableName() {
        return "WCMRIGHT";
    }

    public String getIdFieldName() {
        return "RIGHTID";
    }

    public Class getElementClass() {
        return Right.class;
    }

    public BaseObjs newInstance() throws Exception {
        return new Rights(this.currUser);
    }

    public CMyBitsValue orAll() {
        CMyBitsValue cMyBitsValue = null;
        Right right = null;
        for (int i = 0; i < this.size(); ++i) {
            right = (Right)this.getAt(i);
            if (right == null) continue;
            if (cMyBitsValue == null) {
                cMyBitsValue = new CMyBitsValue(right.getValue());
                continue;
            }
            cMyBitsValue.or(right.getValue());
        }
        return cMyBitsValue;
    }

    public int indexOf(CMSObj cMSObj, CMSObj cMSObj2) {
        if (cMSObj == null || !cMSObj.isValidInstance() || cMSObj2 == null || !cMSObj2.isValidInstance()) {
            return -1;
        }
        return this.indexOf(cMSObj.getWCMType(), cMSObj.getId(), cMSObj2.getWCMType(), cMSObj2.getId());
    }

    public int indexOf(int n, int n2, int n3, int n4) {
        Right right = null;
        for (int i = 0; i < this.size(); ++i) {
            right = (Right)this.getAt(i);
            if (right == null || right.getOperatorType() != n || right.getOperatorId() != n2 || right.getObjType() != n3 || right.getObjId() != n4) continue;
            return i;
        }
        return -1;
    }

    public static final Rights findByIds(User user, String string) throws WCMException {
        if (string.length() <= 0) {
            throw new WCMException(10, I18NMessage.get(Rights.class, "Rights.label1", "\u6307\u5b9a\u5bf9\u8c61ID\u5e8f\u5217\u65e0\u6548\uff01"));
        }
        return (Rights)CMSBaseObjs.findWCMObjsByIds(user, Rights.class, string);
    }

    public static final Rights openWCMObjs(User user, WCMFilter wCMFilter) throws WCMException {
        return (Rights)CMSBaseObjs.openWCMObjs(user, Rights.class, wCMFilter);
    }

    public static Rights createNewInstance(User user) throws WCMException {
        return (Rights)CMSBaseObjs.createInstance(user, Rights.class);
    }
}

