/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class ObjectMemberMgr
implements IObjectMemberMgr {
    private static final int MEMBER_RIGHT_VISIBLE = 1;
    private static final int MEMBER_RIGHT_OPERATION = 2;
    private HashMap m_hMemberCache = null;

    public boolean canOperate(User user, int n, int n2) throws WCMException {
        Object object = this.makeKey(user, n, n2);
        this.insureCacheLoaded();
        Integer n3 = (Integer)this.m_hMemberCache.get(object);
        if (n3 != null && n3 >= 2) {
            return true;
        }
        Groups groups = user.getGroups();
        int n4 = groups.size();
        for (int i = 0; i < n4; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null || !this.canOperate(group, n, n2)) continue;
            return true;
        }
        Roles roles = user.getRoles();
        int n5 = roles.size();
        for (n4 = 0; n4 < n5; ++n4) {
            Role role = (Role)roles.getAt(n4);
            if (role == null || role.isSystemRole() || !this.canOperate(role, n, n2)) continue;
            return true;
        }
        return false;
    }

    public boolean canOperate(Group group, int n, int n2) throws WCMException {
        boolean bl;
        if (group == null) {
            return false;
        }
        this.insureCacheLoaded();
        Object object = this.makeKey(group, n, n2);
        Integer n3 = (Integer)this.m_hMemberCache.get(object);
        int n4 = 0;
        if (n3 != null) {
            n4 = n3;
        }
        boolean bl2 = bl = n4 >= 2;
        if (bl) {
            return true;
        }
        if (group.getParentId() <= 0) {
            return false;
        }
        return this.canOperate(group.getParent(), n, n2);
    }

    public boolean canOperate(Role role, int n, int n2) throws WCMException {
        if (role.isSystemRole()) {
            return false;
        }
        Object object = this.makeKey(role, n, n2);
        this.insureCacheLoaded();
        Integer n3 = (Integer)this.m_hMemberCache.get(object);
        if (n3 == null) {
            return false;
        }
        return n3 >= 2;
    }

    public boolean canOperate(CMSObj cMSObj, int n, int n2) throws WCMException {
        if (cMSObj instanceof User) {
            return this.canOperate((User)cMSObj, n, n2);
        }
        Object object = this.makeKey(cMSObj, n, n2);
        this.insureCacheLoaded();
        Integer n3 = (Integer)this.m_hMemberCache.get(object);
        if (n3 == null) {
            return false;
        }
        return n3 >= 2;
    }

    public boolean isVisible(User user, int n, int n2) throws WCMException {
        this.insureCacheLoaded();
        Object object = this.makeKey(user, n, n2);
        Integer n3 = (Integer)this.m_hMemberCache.get(object);
        if (n3 != null && n3 >= 1) {
            return true;
        }
        Groups groups = user.getGroups();
        int n4 = groups.size();
        for (int i = 0; i < n4; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null || !this.isVisible(group, n, n2)) continue;
            return true;
        }
        Roles roles = user.getRoles();
        int n5 = roles.size();
        for (n4 = 0; n4 < n5; ++n4) {
            Role role = (Role)roles.getAt(n4);
            if (role == null || role.isSystemRole() || !this.isVisible(role, n, n2)) continue;
            return true;
        }
        return false;
    }

    private void insureCacheLoaded() throws WCMException {
        if (this.m_hMemberCache == null) {
            this.doStart();
        }
    }

    public boolean isVisible(Group group, int n, int n2) throws WCMException {
        if (group == null) {
            return false;
        }
        this.insureCacheLoaded();
        Object object = this.makeKey(group, n, n2);
        Integer n3 = (Integer)this.m_hMemberCache.get(object);
        int n4 = 0;
        if (n3 != null) {
            n4 = n3;
        }
        if (n4 >= 1) {
            return true;
        }
        if (group.getParentId() <= 0) {
            return false;
        }
        return this.isVisible(group.getParent(), n, n2);
    }

    public boolean isVisible(Role role, int n, int n2) throws WCMException {
        if (role.isSystemRole()) {
            return false;
        }
        this.insureCacheLoaded();
        Object object = this.makeKey(role, n, n2);
        Integer n3 = (Integer)this.m_hMemberCache.get(object);
        if (n3 == null) {
            return false;
        }
        return n3 >= 1;
    }

    public boolean isVisible(CMSObj cMSObj, int n, int n2) throws WCMException {
        this.insureCacheLoaded();
        if (cMSObj instanceof User) {
            return this.isVisible((User)cMSObj, n, n2);
        }
        Object object = this.makeKey(cMSObj, n, n2);
        Integer n3 = (Integer)this.m_hMemberCache.get(object);
        if (n3 == null) {
            return false;
        }
        return n3 >= 1;
    }

    public void clear() {
        if (this.m_hMemberCache != null) {
            this.m_hMemberCache.clear();
            this.m_hMemberCache = null;
        }
    }

    public boolean init() throws WCMException {
        return this.doStart();
    }

    private synchronized boolean doStart() throws WCMException {
        if (this.m_hMemberCache != null) {
            return true;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(100);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DBManager dBManager = DBManager.getDBManager();
        String string = "select MemberType, MemberId, ObjType, ObjId, Visible, DoOperation from XWCMOBJECTMEMBER";
        try {
            connection = dBManager.getConnection();
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object object = this.makeKey(resultSet.getInt("MemberType"), resultSet.getInt("MemberId"), resultSet.getInt("ObjType"), resultSet.getInt("ObjId"));
                int n = 0;
                if (resultSet.getInt("Visible") > 0) {
                    ++n;
                }
                if (resultSet.getInt("DoOperation") > 0) {
                    n += 2;
                }
                hashMap.put(object, new Integer(n));
            }
        }
        catch (SQLException sQLException) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + string, sQLException);
        }
        catch (Exception exception) {
            throw new WCMException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=" + string, exception);
        }
        finally {
            if (connection != null) {
                dBManager.freeConnection(connection);
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        this.m_hMemberCache = hashMap;
        return true;
    }

    public boolean reinit() throws WCMException {
        if (this.m_hMemberCache != null) {
            this.m_hMemberCache.clear();
            this.m_hMemberCache = null;
        }
        return this.doStart();
    }

    public void notifyOnAddObj(BaseObj baseObj) throws WCMException {
        this.insureCacheLoaded();
        if (baseObj instanceof ObjectMember) {
            this.putToCache((ObjectMember)baseObj);
            return;
        }
        if (baseObj instanceof Right) {
            Right right = (Right)baseObj;
            String string = right.getAttributeValue("ISINHERIT");
            if (!CMyString.isEmpty(string) && "true".equalsIgnoreCase(string)) {
                return;
            }
            BaseChannel baseChannel = this.makeCurrBaseChannel(right);
            if (baseChannel == null) {
                return;
            }
            if (right.getValueAsInt() == 0L) {
                this.removeOperation(right.getCrUser(), right.getOperatorType(), right.getOperatorId(), right.getObjType(), right.getObjId());
            } else {
                this.addOperation(right.getCrUser(), right.getOperatorType(), right.getOperatorId(), right.getObjType(), right.getObjId());
                if (baseChannel.isSite()) {
                    return;
                }
                for (BaseChannel baseChannel2 = baseChannel.getHost(); baseChannel2 != null; baseChannel2 = baseChannel2.getHost()) {
                    this.addVisible(right.getCrUser(), right.getOperatorType(), right.getOperatorId(), baseChannel2.getWCMType(), baseChannel2.getId());
                    if (baseChannel2.isSite()) break;
                }
            }
        }
    }

    public void addOperation(User user, int n, int n2, int n3, int n4) throws WCMException {
        Object object = this.makeKey(n, n2, n3, n4);
        Integer n5 = (Integer)this.m_hMemberCache.get(object);
        if (n5 == null) {
            ObjectMember objectMember = ObjectMember.createNewInstance();
            objectMember.setMemberType(n);
            objectMember.setMemberId(n2);
            objectMember.setObjType(n3);
            objectMember.setObjId(n4);
            objectMember.setVisible(true);
            objectMember.setDoOperation(true);
            objectMember.insert(user);
        } else if (n5 < 2) {
            ObjectMember objectMember = ObjectMember.findByMemberObj(n, n2, n3, n4);
            if (objectMember == null) {
                this.m_hMemberCache.remove(object);
                this.addOperation(user, n, n2, n3, n4);
                return;
            }
            objectMember.setVisible(true);
            objectMember.setDoOperation(true);
            objectMember.update(user);
        }
    }

    public void addVisible(User user, int n, int n2, int n3, int n4) throws WCMException {
        Object object = this.makeKey(n, n2, n3, n4);
        Integer n5 = (Integer)this.m_hMemberCache.get(object);
        if (n5 == null) {
            ObjectMember objectMember = ObjectMember.createNewInstance();
            objectMember.setMemberType(n);
            objectMember.setMemberId(n2);
            objectMember.setObjType(n3);
            objectMember.setObjId(n4);
            objectMember.setVisible(true);
            objectMember.insert(user);
        } else if (n5 < 1) {
            ObjectMember objectMember = ObjectMember.findByMemberObj(n, n2, n3, n4);
            if (objectMember == null) {
                this.m_hMemberCache.remove(object);
                this.addVisible(user, n, n2, n3, n4);
                return;
            }
            objectMember.setVisible(true);
            objectMember.update(user);
        }
    }

    private BaseChannel makeCurrBaseChannel(Right right) throws WCMException {
        int n = right.getObjType();
        BaseChannel baseChannel = null;
        switch (n) {
            case 101: {
                baseChannel = Channel.findById(right.getObjId());
                break;
            }
            case 103: {
                baseChannel = WebSite.findById(right.getObjId());
                break;
            }
            default: {
                return null;
            }
        }
        return baseChannel;
    }

    private void removeOperation(User user, int n, int n2, int n3, int n4) throws WCMException {
        Object object = this.makeKey(n, n2, n3, n4);
        Integer n5 = (Integer)this.m_hMemberCache.get(object);
        if (n5 == null || n5 < 2) {
            return;
        }
        ObjectMember objectMember = ObjectMember.findByMemberObj(n, n2, n3, n4);
        if (objectMember == null) {
            return;
        }
        objectMember.canEdit(user);
        objectMember.setDoOperation(false);
        objectMember.update(user);
    }

    private void removeVisible(User user, int n, int n2, int n3, int n4) throws WCMException {
        Object object = this.makeKey(n, n2, n3, n4);
        Integer n5 = (Integer)this.m_hMemberCache.get(object);
        if (n5 == null || n5 < 2) {
            return;
        }
        ObjectMember objectMember = ObjectMember.findByMemberObj(n, n2, n3, n4);
        if (objectMember == null) {
            return;
        }
        objectMember.delete(user);
    }

    public void notifyOnDelObj(BaseObj baseObj, int n) throws WCMException {
        this.insureCacheLoaded();
        if (baseObj instanceof ObjectMember) {
            this.removeFromCache((ObjectMember)baseObj);
        } else if (baseObj instanceof Right) {
            Right right = (Right)baseObj;
            User user = this.getLoginUser();
            this.removeOperation(user, right.getOperatorType(), right.getOperatorId(), right.getObjType(), right.getObjId());
        }
    }

    public void notifyOnModifyObj(BaseObj baseObj, int n) throws WCMException {
        this.insureCacheLoaded();
        if (baseObj instanceof ObjectMember) {
            ObjectMember objectMember = (ObjectMember)baseObj;
            Object object = this.makeKey(objectMember);
            int n2 = 0;
            if (baseObj.isChangeProperty("VISIBLE")) {
                if (baseObj.getNewPropertyAsInt("VISIBLE", 0) > 0) {
                    ++n2;
                }
            } else if (baseObj.getPropertyAsInt("VISIBLE", 0) > 0) {
                ++n2;
            }
            if (baseObj.isChangeProperty("DOOPERATION")) {
                if (baseObj.getNewPropertyAsInt("DOOPERATION", 0) > 0) {
                    n2 += 2;
                }
            } else if (baseObj.getPropertyAsInt("DOOPERATION", 0) > 0) {
                n2 += 2;
            }
            this.m_hMemberCache.put(object, new Integer(n2));
            return;
        }
        if (baseObj instanceof Right) {
            Right right = (Right)baseObj;
            if (!right.isChangeProperty("RIGHTVALUE")) {
                return;
            }
            long l = ((Number)right.getNewProperty("RIGHTVALUE")).longValue();
            BaseChannel baseChannel = this.makeCurrBaseChannel(right);
            if (baseChannel == null) {
                return;
            }
            User user = this.getLoginUser();
            if (l == 0L) {
                this.removeOperation(user, right.getOperatorType(), right.getOperatorId(), right.getObjType(), right.getObjId());
            } else if (l > 0L) {
                this.addOperation(user, right.getOperatorType(), right.getOperatorId(), right.getObjType(), right.getObjId());
                if (baseChannel.isSite()) {
                    return;
                }
                for (BaseChannel baseChannel2 = baseChannel.getHost(); baseChannel2 != null; baseChannel2 = baseChannel2.getHost()) {
                    this.addVisible(user, right.getOperatorType(), right.getOperatorId(), baseChannel2.getWCMType(), baseChannel2.getId());
                    if (baseChannel2.isSite()) break;
                }
            }
        }
    }

    private Object makeKey(ObjectMember objectMember) {
        return this.makeKey(objectMember.getMemberType(), objectMember.getMemberId(), objectMember.getObjType(), objectMember.getObjId());
    }

    private Object makeKey(BaseObj baseObj, int n, int n2) {
        return this.makeKey(baseObj.getWCMType(), baseObj.getId(), n, n2);
    }

    private Object makeKey(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(n);
        stringBuffer.append(".");
        stringBuffer.append(n2);
        stringBuffer.append(".");
        stringBuffer.append(n3);
        stringBuffer.append(".");
        stringBuffer.append(n4);
        return stringBuffer.toString().intern();
    }

    private void removeFromCache(ObjectMember objectMember) {
        Object object = this.makeKey(objectMember);
        this.m_hMemberCache.remove(object);
    }

    private void putToCache(ObjectMember objectMember) {
        Object object = this.makeKey(objectMember);
        int n = 0;
        if (objectMember.isVisible()) {
            ++n;
        }
        if (objectMember.isDoOperation()) {
            n += 2;
        }
        this.m_hMemberCache.put(object, new Integer(n));
    }

    public ObjectMember getObjectMember(int n, int n2, int n3, int n4) throws WCMException {
        return ObjectMember.findByMemberObj(n, n2, n3, n4);
    }

    public ObjectMembers getObjectMembers(CMSObj cMSObj) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", "ObjType=? and ObjId=?", "");
        wCMFilter.addSearchValues(cMSObj.getWCMType());
        wCMFilter.addSearchValues(cMSObj.getId());
        ObjectMembers objectMembers = ObjectMembers.openWCMObjs(null, wCMFilter);
        return objectMembers;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

