/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.GroupRole;
import com.trs.cms.auth.persistent.GroupRoles;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class GroupRoleMgr {
    public boolean addGroup(Group group, Role role) throws WCMException {
        if (group == null || !group.isValidInstance()) {
            throw new WCMException("\u8981\u52a0\u5165\u89d2\u8272\u7684\u7ec4\u7ec7\u5bf9\u8c61\u65e0\u6548");
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label2", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548"));
        }
        if (role == null || !role.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            GroupRole groupRole = this.getGroupRole(group, role);
            if (groupRole != null) {
                return false;
            }
            groupRole = GroupRole.createNewInstance();
            groupRole.setRoleId(role.getId());
            groupRole.setGroupId(group.getId());
            groupRole.setCrUser(ContextHelper.getLoginUser());
            groupRole.insert(ContextHelper.getLoginUser());
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label4", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u89d2\u8272\u65f6\u51fa\u9519!"), exception);
        }
        return true;
    }

    private GroupRole getGroupRole(Group group, Role role) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMGRPROLE", "GroupId=" + group.getId() + " AND RoleId=" + role.getId(), "", "", 1);
        GroupRoles groupRoles = GroupRoles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter);
        if (groupRoles.isEmpty()) {
            return null;
        }
        return (GroupRole)groupRoles.getAt(0);
    }

    public boolean removeGroup(Group group, Role role) throws WCMException {
        if (group == null || !group.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label5", "\u8981\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u7684\u7ec4\u7ec7\u5bf9\u8c61\u65e0\u6548\uff08GroupRoleMgr.removeUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label6", "\u6267\u884c\u5220\u9664\u64cd\u4f5c\u7684\u7528\u6237\u65e0\u6548\uff08GroupRoleMgr.removeUser\uff09"));
        }
        if (role == null || !role.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            GroupRole groupRole = this.getGroupRole(group, role);
            if (groupRole == null) {
                return false;
            }
            groupRole.delete(ContextHelper.getLoginUser());
        }
        catch (Exception exception) {
            throw new WCMException(0, I18NMessage.get(GroupRoleMgr.class, "GroupRoleMgr.label7", "\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u6307\u5b9a\u7528\u6237\u65f6\u5931\u8d25"), exception);
        }
        return true;
    }

    public Groups getGroups(Role role, WCMFilter wCMFilter) throws WCMException {
        if (role == null) {
            throw new WCMException("\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u8be5\u89d2\u8272\u7684\u6240\u5c5e\u7ec4\u7ec7!");
        }
        String string = "exists(select RoleId FROM WCMGrpRole WHERE WCMGrpRole.GroupId=WCMGroup.GroupId AND RoleId=?)";
        WCMFilter wCMFilter2 = new WCMFilter(null, string, null);
        wCMFilter2.addSearchValues(role.getId());
        wCMFilter2.mergeWith(wCMFilter);
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public Roles getRoles(Group group, WCMFilter wCMFilter) throws WCMException {
        if (group == null) {
            throw new WCMException("\u65e0\u6548\u7684\u7ec4\u7ec7\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u5c5e\u4e8e\u8be5\u7ec4\u7ec7\u7684\u89d2\u8272!");
        }
        WCMFilter wCMFilter2 = new WCMFilter("", "EXISTS(SELECT GroupId FROM WCMGrpRole WHERE WCMGrpRole.RoleId=WCMRole.RoleId AND GroupId=" + group.getId() + ")", "", "RoleId");
        wCMFilter2.mergeWith(wCMFilter);
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), wCMFilter2);
    }

    public void setGroups(Role role, Groups groups) throws WCMException {
        Group group;
        int n;
        Groups groups2 = this.getGroups(role, null);
        int n2 = groups.size();
        for (n = 0; n < n2; ++n) {
            group = (Group)groups.getAt(n);
            if (group == null) continue;
            if (groups2.indexOf(group.getId()) >= 0) {
                groups2.remove(false);
                continue;
            }
            this.addGroup(group, role);
        }
        n2 = groups2.size();
        for (n = 0; n < n2; ++n) {
            group = (Group)groups2.getAt(n);
            if (group == null) continue;
            this.removeGroup(group, role);
        }
    }
}

