/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.receiver;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgReceiver;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class ObjectLCMsgReceiver
implements IClusterMsgReceiver {
    private static Logger logger = Logger.getLogger(ObjectLCMsgReceiver.class);
    private static final int[] OBJECT_TYPES = new int[]{101, 101, 101, 202, 1886731157, 694710472, 955, 403, 403, 105, 864684658, 102, 953, 957, -1209578322, -1209578322, -1643208931, -1643208931, 204, 204, 951, 501, 1874605631, 1886731157, 701, 701, -1676813972};
    public static final String[] LISTENER_NAMES = new String[]{"IChildrenMgr", "IChannelNameMgr", "ChannelLCListener4EPress", "RightCacheMgr", "IMetaDataDefCacheMgr", "IClassInfoCacheMgr", "PublishDistributionCacheMgr", "IFlowCacheMgr", "RuleHostLCListnerForCache", "ReplaceCacheMgr", "IFolderPubStatusCacheMgr", "TemplateParseMgr", "ITemplateEmployCacheMgr", "TemplateArgumentCacheMgr", "GroupUserCacheMgr", "GroupAdminsCacheMgr", "IAdministratorCacheMgr", "RoleUserCacheMgr", "IUserCacheMgr", "UserLCListenerForLogin", "TagBeanLCListener", "ScheduleLCListenerForServer", "IMetaDataDefCacheMgr", "IMetaDataDefCacheMgr", "PathConfigLCListener", "ConfigServer", "IPublishTaskDispatcher"};

    public void receive(BaseObj baseObj, int n) throws Exception {
        if (baseObj == null) {
            throw new WCMException("\u6d88\u606f\u4e2d\u5fc3\u4f20\u5165\u7684\u5bf9\u8c61\u6709\u8bef\uff01\u6ca1\u6709\u4f20\u5165\u6301\u4e45\u5316\u5bf9\u8c61\uff01");
        }
        int[] nArray = this.makeCurrListenerIndexs(baseObj);
        for (int i = 0; i < nArray.length && nArray[i] != -1; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LISTENER_NAMES[nArray[i]] + "......."));
            }
            this.notifyListener(nArray[i], baseObj, n);
        }
    }

    private int[] makeCurrListenerIndexs(BaseObj baseObj) throws WCMException {
        int n;
        int n2 = baseObj.getWCMType();
        int[] nArray = new int[LISTENER_NAMES.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        n = 0;
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            if (n2 != OBJECT_TYPES[i]) continue;
            nArray[n++] = i;
        }
        if (nArray[0] == -1) {
            throw new WCMException("\u7cfb\u7edf\u6545\u969c\uff1f[Type=" + baseObj.getWCMType() + ", ID=" + baseObj.getId() + "]");
        }
        return nArray;
    }

    private void notifyListener(int n, BaseObj baseObj, int n2) throws WCMException {
        Object object = DreamFactory.createObjectById(LISTENER_NAMES[n]);
        switch (n2) {
            case 1: {
                if (!(object instanceof IObjectLCListenerOnAdd)) break;
                ((IObjectLCListenerOnAdd)object).notifyOnAddObj(baseObj);
                break;
            }
            case 2: {
                if (!(object instanceof IObjectLCListenerOnModify)) break;
                ((IObjectLCListenerOnModify)object).notifyOnModifyObj(baseObj, 2);
                break;
            }
            case 3: {
                if (!(object instanceof IObjectLCListenerOnDel)) break;
                ((IObjectLCListenerOnDel)object).notifyOnDelObj(baseObj, 4);
            }
        }
    }

    public void receive(String string, String[] stringArray) throws Exception {
    }

    public String[] registerMoniterMessages() {
        return null;
    }

    public int[] registerMoniterWCMObjTypesOnAdd() {
        int[] nArray = null;
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            int n = OBJECT_TYPES[i];
            Object object = DreamFactory.createObjectById(LISTENER_NAMES[i]);
            if (!(object instanceof IObjectLCListenerOnAdd)) continue;
            if (nArray == null) {
                nArray = new int[1];
            } else {
                if (this.isAdd(n, nArray)) continue;
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
            }
            nArray[nArray.length - 1] = n;
        }
        return nArray;
    }

    public int[] registerMoniterWCMObjTypesOnDel() {
        int[] nArray = null;
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            int n = OBJECT_TYPES[i];
            Object object = DreamFactory.createObjectById(LISTENER_NAMES[i]);
            if (!(object instanceof IObjectLCListenerOnDel)) continue;
            if (nArray == null) {
                nArray = new int[1];
            } else {
                if (this.isAdd(n, nArray)) continue;
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
            }
            nArray[nArray.length - 1] = n;
        }
        return nArray;
    }

    public int[] registerMoniterWCMObjTypesOnModify() {
        int[] nArray = null;
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            int n = OBJECT_TYPES[i];
            Object object = DreamFactory.createObjectById(LISTENER_NAMES[i]);
            if (!(object instanceof IObjectLCListenerOnModify)) continue;
            if (nArray == null) {
                nArray = new int[1];
            } else {
                if (this.isAdd(n, nArray)) continue;
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
            }
            nArray[nArray.length - 1] = n;
        }
        return nArray;
    }

    private boolean isAdd(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }
}

