/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster;

import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.Configs;
import com.trs.infra.util.CMyString;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClusterConfigHelper {
    private static Logger logger = Logger.getLogger(ClusterConfigHelper.class);
    private static ClusterConfig CONF = null;
    private static final byte[] INIT_LOCK = new byte[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ClusterConfig getConfig() {
        if (CONF != null) return CONF;
        byte[] byArray = INIT_LOCK;
        synchronized (INIT_LOCK) {
            if (CONF != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return CONF;
            }
            URL uRL = ClusterConfigHelper.class.getResource("/trswcmcluster.properties");
            ClusterConfig clusterConfig = new ClusterConfig();
            clusterConfig.load(uRL);
            if (!clusterConfig.isEnabled()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return clusterConfig;
            }
            Configs configs = new Configs();
            WCMFilter wCMFilter = new WCMFilter("", "", "", "CKEY,CVALUE");
            wCMFilter.setWhere("CTYPE=13");
            try {
                configs.open(wCMFilter);
            }
            catch (WCMException wCMException) {
                clusterConfig.setEnabled(false);
                logger.fatal((Object)"Load cluster config failed.", (Throwable)wCMException);
                // ** MonitorExit[var0] (shouldn't be in output)
                return clusterConfig;
            }
            Properties properties = new Properties();
            int n = configs.size();
            for (int i = 0; i < n; ++i) {
                Config config = (Config)configs.getAt(i);
                if (config == null || CMyString.isEmpty(config.getValue())) continue;
                properties.put(config.getConfigKey(), config.getValue());
            }
            clusterConfig.load(properties);
            clusterConfig.setMaster(false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)properties);
            }
            properties.clear();
            CONF = clusterConfig;
            // ** MonitorExit[var0] (shouldn't be in output)
            return CONF;
        }
    }
}

