/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.DreamFactory;
import com.trs.ajaxservice.TemplateAuthHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WCMFolderPublishConfigToXML
implements IXMLConvertor {
    private String[] m_pSelectFields = null;
    private TemplateEmployMgr m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");

    public String[] registerTargetClassName() {
        return new String[]{WCMFolderPublishConfig.class.getName()};
    }

    public String toXmlString(MethodContext methodContext, Object object) throws ConvertException {
        Element element;
        if (!(object instanceof WCMFolderPublishConfig)) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label1", "\u53c2\u6570\u7c7b\u578b[") + object.getClass() + I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label2", "]\u4e0d\u4e00\u81f4[") + WCMFolderPublishConfig.class + "]\uff01");
        }
        this.m_pSelectFields = this.makeSelectFields(methodContext);
        WCMFolderPublishConfig wCMFolderPublishConfig = (WCMFolderPublishConfig)object;
        Element element2 = DocumentHelper.createElement((String)"PublishConfig");
        try {
            if (this.isSelectFields("OutlineTemplate")) {
                element2.add(this.makeTemplateTag(methodContext, wCMFolderPublishConfig.getDefaultOutlineTemplateId(), "OutlineTemplate"));
            }
            if (this.isSelectFields("OtherOutlineTemplates")) {
                element = element2.addElement("OtherOutlineTemplates");
                Templates templates = this.m_oEmployMgr.getOtherOutlineTemplates(wCMFolderPublishConfig.getFolder());
                int n = templates.size();
                for (int i = 0; i < n; ++i) {
                    Template template = (Template)templates.getAt(i);
                    if (template == null) continue;
                    element.add(this.makeTemplateTag(methodContext, template, "OtherOutlineTemplate"));
                }
            }
            if (this.isSelectFields("DetailTemplate")) {
                element2.add(this.makeTemplateTag(methodContext, wCMFolderPublishConfig.getDetailTemplateId(), "DetailTemplate"));
            }
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label3", "\u6784\u9020\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01"), exception);
        }
        try {
            if (this.isSelectFields("DataPath")) {
                element2.addElement("DataPath").addCDATA(wCMFolderPublishConfig.getDataPath());
            }
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label4", "\u6784\u9020\u5b58\u50a8\u8def\u5f84\u5931\u8d25\uff01"), exception);
        }
        try {
            if (this.isSelectFields("URL")) {
                element2.addElement("URL").addCDATA(CMyString.showNull(wCMFolderPublishConfig.getURL()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.isSelectFields("STATUSESCANDOPUB")) {
                element2.addElement("STATUSESCANDOPUB").addCDATA(wCMFolderPublishConfig.getStatusesCanDoPub());
            }
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label5", "\u6784\u9020\u5b9e\u9645\u53ef\u9884\u89c8\u5730\u5740\u5931\u8d25\uff01"), exception);
        }
        try {
            if (this.isSelectFields("ROOTDOMAIN")) {
                element2.addElement("ROOTDOMAIN").addCDATA(wCMFolderPublishConfig.getRootDomain());
            }
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label5", "\u6784\u9020\u5b9e\u9645\u53ef\u9884\u89c8\u5730\u5740\u5931\u8d25\uff01"), exception);
        }
        try {
            if (this.isSelectFields("PageEncoding") || this.isSelectFields("SiteLanguage")) {
                element2.addElement("PageEncoding").addCDATA(wCMFolderPublishConfig.getPageEncoding());
                element2.addElement("SiteLanguage").addText(String.valueOf(wCMFolderPublishConfig.getSiteLanguage()));
            }
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label6", "\u6784\u9020\u9875\u9762\u7f16\u7801\u5931\u8d25\uff01"), exception);
        }
        try {
            if (this.isSelectFields("StatusIdAfterModify")) {
                element2.addElement("StatusIdAfterModify").addText(String.valueOf(wCMFolderPublishConfig.getStatusIdAfterModify()));
            }
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label7", "\u6784\u9020\u7f16\u8f91\u540e\u7684\u6587\u6863\u72b6\u6001\u5931\u8d25\uff01"), exception);
        }
        try {
            if (this.isSelectFields("Schedule")) {
                element = element2.addElement("Schedule");
                element.addAttribute("ScheduleMode", String.valueOf(wCMFolderPublishConfig.getScheduleMode()));
                element.addAttribute("StartTime", wCMFolderPublishConfig.getStartTime());
                element.addAttribute("EndTime", wCMFolderPublishConfig.getEndTime());
                element.addAttribute("Interval", String.valueOf(wCMFolderPublishConfig.getInterval()));
                element.addAttribute("ExecTime", wCMFolderPublishConfig.getExecTime());
            }
        }
        catch (Exception exception) {
            throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label7", "\u6784\u9020\u7f16\u8f91\u540e\u7684\u6587\u6863\u72b6\u6001\u5931\u8d25\uff01"), exception);
        }
        return element2.asXML();
    }

    private Element makeTemplateTag(MethodContext methodContext, int n, String string) throws WCMException, ConvertException {
        Template template = null;
        if (n > 0) {
            template = Template.findById(n);
        }
        return this.makeTemplateTag(methodContext, template, string);
    }

    private Element makeTemplateTag(MethodContext methodContext, Template template, String string) throws ConvertException {
        Element element = DocumentHelper.createElement((String)string);
        if (template != null) {
            element.addCDATA(template.getName());
            element.addAttribute("Id", String.valueOf(template.getId()));
        } else {
            element.addAttribute("Id", "0");
        }
        if (methodContext.getValue("ContainsRight", false) && template != null) {
            try {
                User user = ContextHelper.getLoginUser();
                RightValue rightValue = null;
                if (user.isAdministrator() || user.getName().equals(template.getCrUserName())) {
                    rightValue = new RightValue(RightValue.VALUE_ADMINISTRATOR);
                } else {
                    IPublishFolder iPublishFolder = (IPublishFolder)methodContext.getContextCacheData("Host");
                    rightValue = TemplateAuthHelper.makeTemplateRightValue(methodContext, user, template, iPublishFolder);
                }
                element.addAttribute("Right", rightValue.toString());
            }
            catch (Exception exception) {
                throw new ConvertException(I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label8", "\u6784\u9020[") + template + I18NMessage.get(WCMFolderPublishConfigToXML.class, "WCMFolderPublishConfigToXML.label9", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), exception);
            }
        }
        return element;
    }

    private String[] makeSelectFields(MethodContext methodContext) {
        String[] stringArray = null;
        String string = methodContext.getValue("SelectFields");
        if (string != null && (string = string.trim()).length() > 0 && !string.equals("*")) {
            stringArray = CMyString.split(string, ",");
        }
        return stringArray;
    }

    private boolean isSelectFields(String string) {
        if (this.m_pSelectFields == null) {
            return true;
        }
        for (int i = 0; i < this.m_pSelectFields.length; ++i) {
            if (!this.m_pSelectFields[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

