/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.logger;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.PublishConstants;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.log.LogServer;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class DocPublishTaskLogger
extends AbstractLogger {
    private static final Logger LOG = Logger.getLogger(DocPublishTaskLogger.class);
    private static final int MAX_DOCSIZE = 20;

    public int startLog(MethodConfig methodConfig, MethodContext methodContext) {
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("PublishType", 0);
        String string = this.getLogType(n, methodContext.getValue("withdrawall", false));
        if (string == null) {
            string = "UNKNOWN_OPERTYPE";
        }
        Document document = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(256);
            if (n == 7) {
                stringBuffer.append(string).append(", \u88ab\u64a4\u9500\u53d1\u5e03\u7684\u5bf9\u8c61\u4e3a: ");
            } else {
                stringBuffer.append(string).append(", \u88ab\u53d1\u5e03\u7684\u5bf9\u8c61\u4e3a: ");
            }
            String string2 = methodContext.getObjectIds();
            ChnlDocs chnlDocs = ChnlDocs.findByIds(user, string2);
            if (chnlDocs.isEmpty()) {
                return 0;
            }
            int n2 = chnlDocs.size();
            for (int i = 0; i < n2 && i < 20; ++i) {
                Document document2;
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                if (chnlDoc == null || (document2 = chnlDoc.getDocument()) == null) continue;
                if (document == null) {
                    document = document2;
                }
                stringBuffer.append(document2);
                stringBuffer.append(", ");
            }
            if (chnlDocs.size() > 20) {
                stringBuffer.append(" ...(\u7565). ID\u5e8f\u5217\u4e3a:").append(string2);
                stringBuffer.append(", ");
            }
            if (document == null) {
                LOG.warn((Object)"No need to log a pubish operate: no object found.");
                return 0;
            }
            return (int)LogServer.startRecord(user.getName(), string, stringBuffer.substring(0, stringBuffer.length() - 2), document);
        }
        catch (WCMException wCMException) {
            LOG.error((Object)"Failed to log a publish operate.", (Throwable)wCMException);
            return 0;
        }
    }

    protected String getLogType(int n, boolean bl) {
        String string = "\u6587\u6863\u7684";
        string = bl ? string + "\u76f4\u63a5\u64a4\u9500\u53d1\u5e03" : string + PublishConstants.getPublishTypeName(n, "\u672a\u77e5\u53d1\u5e03\u7c7b\u578b");
        try {
            if (!LogServer.existsLogType(string)) {
                this.createLogTypeIfNeed(string, string);
            }
        }
        catch (Exception exception) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"get logtype fail", (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            LOG.error((Object)"get logtype fail", throwable);
        }
        return string;
    }
}

