/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelContentLink;
import com.trs.components.wcm.content.persistent.ChannelContentLinks;
import com.trs.components.wcm.content.persistent.ContentLink;
import com.trs.components.wcm.content.persistent.ContentLinkType;
import com.trs.components.wcm.content.persistent.ContentLinkTypes;
import com.trs.components.wcm.content.persistent.ContentLinks;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.contentlink.TxtFileParserForContentLink;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;

public class ContentLinkServiceProvider
implements IGlueServiceProvider {
    private static DBManager m_oDbManager = null;

    public void delete(MethodContext methodContext) throws Throwable {
        Object object;
        String string = methodContext.getObjectIds();
        if (CMyString.isEmpty(string)) {
            return;
        }
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("ChannelId", 0);
        int n2 = methodContext.getValue("SiteId", 0);
        if (n != 0) {
            object = this.findChannelById(n);
            this.validateRight(user, (BaseChannel)object, WCMRightTypes.CONTENT_LINK_DELETE, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label1", "\u5220\u9664\u70ed\u8bcd"));
        } else if (n2 != 0) {
            object = WebSite.findById(n2);
            if (object == null) {
                throw new WCMException(I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label17", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + n2 + "]\uff01");
            }
            this.validateRight(user, (BaseChannel)object, WCMRightTypes.CONTENT_LINK_DELETE, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label1", "\u5220\u9664\u70ed\u8bcd"));
        } else {
            throw new WCMException(I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label18", "\u6ca1\u6709\u4f20\u5165\u6709\u6548\u7684ChannelId\u6216SiteId!"));
        }
        object = ChannelContentLinks.findByIds(user, string);
        ((BaseObjs)object).removeAll(true);
    }

    public Object querySysLinks(MethodContext methodContext) throws Throwable {
        Object object;
        User user = this.getLoginUser();
        Channel channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
        this.validateRight(user, channel, WCMRightTypes.CONTENT_LINK_LIST, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label2", "\u83b7\u53d6\u5185\u5bb9\u8d85\u94fe\u63a5\u7684\u4fe1\u606f"));
        int n = 0;
        try {
            object = channel.getAttributeValue("ContentLinkType");
            n = Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object = new ContentLinks(user);
        if (n <= 0) {
            return object;
        }
        WCMFilter wCMFilter = new WCMFilter("", "ContentLinkType=?", "");
        wCMFilter.addSearchValues(0, n);
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        ((BaseObjs)object).open(wCMFilter);
        return object;
    }

    public Object query(MethodContext methodContext) throws Throwable {
        Object object;
        User user = this.getLoginUser();
        int n = methodContext.getValue("ChannelId", 0);
        int n2 = methodContext.getValue("SiteId", 0);
        boolean bl = methodContext.getValue("containsSite", false);
        int n3 = 0;
        if (n > 0) {
            object = this.findChannelById(n);
            n3 = ((Channel)object).getSiteId();
            if (!AuthServer.hasRight(user, (CMSObj)object, WCMRightTypes.CONTENT_LINK_LIST)) {
                throw new WCMException(I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label7", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650\u5728(") + object + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label9", ")\u4e0a\u6267\u884c[") + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label2", "\u83b7\u53d6\u5185\u5bb9\u8d85\u94fe\u63a5\u7684\u4fe1\u606f") + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label10", "]\u64cd\u4f5c\uff01"));
            }
        }
        object = new ChannelContentLinks(user);
        String string = methodContext.getValue("OrderBy");
        if (CMyString.isEmpty(string)) {
            string = "LinkOrder desc";
        }
        WCMFilter wCMFilter = new WCMFilter("", "", string);
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append("ChannelId=? or SiteId=?");
                wCMFilter.addSearchValues(0, n);
                wCMFilter.addSearchValues(1, n3);
            } else {
                stringBuffer.append("ChannelId=?");
                wCMFilter.addSearchValues(0, n);
            }
            String string2 = this.getParentChannelWhere(n, wCMFilter);
            if (!CMyString.isEmpty(string2)) {
                stringBuffer.append(string2);
            }
            wCMFilter.setWhere(stringBuffer.toString());
        } else {
            wCMFilter.setWhere("SiteId=?");
            wCMFilter.addSearchValues(0, n2);
        }
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        ((BaseObjs)object).open(wCMFilter);
        if (!bl) {
            return object;
        }
        return this.excludeSimilar((ChannelContentLinks)object, n, n3);
    }

    private ChannelContentLinks excludeSimilar(ChannelContentLinks channelContentLinks, int n, int n2) throws WCMException {
        Channel channel;
        User user = this.getLoginUser();
        ChannelContentLink channelContentLink = null;
        ChannelContentLink channelContentLink2 = null;
        ChannelContentLinks channelContentLinks2 = new ChannelContentLinks(user);
        ChannelContentLinks channelContentLinks3 = new ChannelContentLinks(user);
        ChannelContentLinks channelContentLinks4 = new ChannelContentLinks(user);
        WCMFilter wCMFilter = new WCMFilter("", "ChannelId=?", "LinkOrder desc");
        wCMFilter.addSearchValues(0, n);
        channelContentLinks2.open(wCMFilter);
        wCMFilter = new WCMFilter("", "SiteId=?", "LinkOrder desc");
        wCMFilter.addSearchValues(0, n2);
        channelContentLinks3.open(wCMFilter);
        wCMFilter = new WCMFilter("", "", "LinkOrder desc");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SiteId=?");
        wCMFilter.addSearchValues(0, n2);
        String string = this.getParentChannelWhere(n, wCMFilter);
        if (!CMyString.isEmpty(string)) {
            stringBuffer.append(string);
        }
        wCMFilter.setWhere(stringBuffer.toString());
        channelContentLinks4.open(wCMFilter);
        if (channelContentLinks2.size() > 0 && channelContentLinks4.size() > 0) {
            for (int i = 0; i < channelContentLinks2.size(); ++i) {
                channelContentLink = (ChannelContentLink)channelContentLinks2.getAt(i);
                if (channelContentLink == null) continue;
                for (int j = 0; j < channelContentLinks4.size(); ++j) {
                    channelContentLink2 = (ChannelContentLink)channelContentLinks4.getAt(j);
                    if (channelContentLink2 == null || !channelContentLink.getName().equalsIgnoreCase(channelContentLink2.getName())) continue;
                    channelContentLinks.remove(channelContentLink2, false);
                }
            }
        }
        if ((channel = Channel.findById(n)) == null) {
            return null;
        }
        for (Channel channel2 = channel.getParent(); channel2 != null; channel2 = channel2.getParent()) {
            wCMFilter = new WCMFilter("", "ChannelId=? and ISUSEDINCHILDREN=1", "LinkOrder desc");
            wCMFilter.addSearchValues(0, channel2.getId());
            channelContentLinks2.open(wCMFilter);
            channelContentLinks = this.filterParentLinks(channelContentLinks2, channelContentLinks4, channelContentLinks);
        }
        return channelContentLinks;
    }

    private ChannelContentLinks filterParentLinks(ChannelContentLinks channelContentLinks, ChannelContentLinks channelContentLinks2, ChannelContentLinks channelContentLinks3) throws WCMException {
        ChannelContentLink channelContentLink = null;
        ChannelContentLink channelContentLink2 = null;
        if (channelContentLinks.size() > 0 && channelContentLinks2.size() > 0) {
            for (int i = 0; i < channelContentLinks.size(); ++i) {
                channelContentLink = (ChannelContentLink)channelContentLinks.getAt(i);
                if (channelContentLink == null) continue;
                for (int j = 0; j < channelContentLinks2.size(); ++j) {
                    channelContentLink2 = (ChannelContentLink)channelContentLinks2.getAt(j);
                    if (channelContentLink2 == null || !channelContentLink.getName().equalsIgnoreCase(channelContentLink2.getName()) || channelContentLink.getId() <= channelContentLink2.getId()) continue;
                    channelContentLinks3.remove(channelContentLink2, false);
                }
            }
        }
        return channelContentLinks3;
    }

    public String getParentChannelWhere(int n, WCMFilter wCMFilter) throws WCMException {
        StringBuffer stringBuffer = new StringBuffer();
        Channel channel = Channel.findById(n);
        if (channel == null) {
            return null;
        }
        Channel channel2 = channel.getParent();
        if (channel2 == null) {
            return null;
        }
        stringBuffer.append(" or (ISUSEDINCHILDREN=1 And ChannelId IN(?");
        wCMFilter.addSearchValues(channel2.getId());
        for (channel2 = channel2.getParent(); channel2 != null; channel2 = channel2.getParent()) {
            stringBuffer.append(",?");
            wCMFilter.addSearchValues(channel2.getId());
        }
        stringBuffer.append(")) ");
        return stringBuffer.toString();
    }

    public Object queryLinkType(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        Channel channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
        this.validateRight(user, channel, WCMRightTypes.CONTENT_LINK_DETAIL, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label2", "\u83b7\u53d6\u5185\u5bb9\u8d85\u94fe\u63a5\u7684\u4fe1\u606f"));
        int n = 0;
        try {
            String string = channel.getAttributeValue("ContentLinkType");
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ContentLinkType.findById(n);
    }

    public Object queryTypes(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        ContentLinkTypes contentLinkTypes = new ContentLinkTypes(user);
        contentLinkTypes.open(methodContext.getExtraWCMFilter());
        return contentLinkTypes;
    }

    public void setLinkType(MethodContext methodContext) throws WCMException {
        User user = this.getLoginUser();
        Channel channel = this.findChannelById(methodContext.getValue("ChannelId", 0));
        this.validateRight(user, channel, WCMRightTypes.CONTENT_LINK_EDIT, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label3", "\u8bbe\u7f6e\u680f\u76ee\u70ed\u8bcd\u5206\u7c7b"));
        int n = methodContext.getValue("ContentLinkTypeId", 0);
        String string = channel.getAttribute();
        AttributesString attributesString = new AttributesString(string);
        attributesString.putAttributeValue("ContentLinkType", String.valueOf(n));
        channel.setAttribute(attributesString);
        channel.save();
    }

    public int save(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        ChannelContentLink channelContentLink = ChannelContentLink.findById(n);
        User user = this.getLoginUser();
        if (channelContentLink != null && channelContentLink.canEdit(user)) {
            channelContentLink.setName(methodContext.getValue("LinkName"));
            channelContentLink.save(user);
        }
        return n;
    }

    public Object findById(MethodContext methodContext) throws Throwable {
        int n = methodContext.getObjectId();
        ChannelContentLink channelContentLink = ChannelContentLink.findById(n);
        if (channelContentLink == null && channelContentLink == null) {
            throw new WCMException(200006, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label4", "\u6ca1\u6709\u627e\u5230[Id=") + n + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label5", "]\u7684\u70ed\u8bcd\uff01"));
        }
        return channelContentLink;
    }

    public Object findByIds(MethodContext methodContext) throws Throwable {
        return null;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private Channel findChannelById(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label6", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + n + "]\uff01");
        }
        return channel;
    }

    private void validateRight(User user, BaseChannel baseChannel, int n, String string) throws WCMException {
        if (!AuthServer.hasRight(user, (CMSObj)baseChannel, n)) {
            throw new WCMException(I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label7", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650\u5728(") + baseChannel + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label9", ")\u4e0a\u6267\u884c[") + string + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label10", "]\u64cd\u4f5c\uff01"));
        }
    }

    public Object addLinkInChannel(MethodContext methodContext) throws WCMException {
        CMSObj cMSObj;
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("ChannelId", 0);
        int n2 = methodContext.getValue("SiteId", 0);
        if (n > 0) {
            cMSObj = this.findChannelById(n);
            this.validateRight(user, (BaseChannel)cMSObj, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label21", "\u65b0\u5efa\u680f\u76ee\u70ed\u8bcd"));
        } else {
            cMSObj = WebSite.findById(n2);
            this.validateRight(user, (BaseChannel)cMSObj, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label22", "\u65b0\u5efa\u7ad9\u70b9\u70ed\u8bcd"));
        }
        cMSObj = new ChannelContentLink();
        ((ChannelContentLink)cMSObj).setName(methodContext.getValue("LinkName"));
        ((ChannelContentLink)cMSObj).setLinkTitle(methodContext.getValue("LinkTitle"));
        ((ChannelContentLink)cMSObj).setLinkUrl(methodContext.getValue("LinkUrl"));
        ((ChannelContentLink)cMSObj).setOrder(methodContext.getValue("LinkOrder", -1));
        boolean bl = methodContext.getValue("ISUSEDINCHILDREN", 0) == 1;
        ((ChannelContentLink)cMSObj).setUsedInChildren(bl);
        if (n > 0) {
            ((ChannelContentLink)cMSObj).setChnlId(n);
        } else {
            ((ChannelContentLink)cMSObj).setSiteId(n2);
            ((ChannelContentLink)cMSObj).setChnlId(0);
        }
        cMSObj.save(user);
        return String.valueOf(cMSObj.getId());
    }

    public Object editLinkInChannel(MethodContext methodContext) throws WCMException {
        BaseChannel baseChannel;
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("ChannelId", 0);
        int n2 = methodContext.getValue("SiteId", 0);
        if (n > 0) {
            baseChannel = Channel.findById(n);
            this.validateRight(user, baseChannel, WCMRightTypes.CONTENT_LINK_EDIT, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label12", "\u7f16\u8f91\u680f\u76ee\u70ed\u8bcd"));
        } else {
            baseChannel = WebSite.findById(n2);
            this.validateRight(user, baseChannel, WCMRightTypes.CONTENT_LINK_EDIT, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label18", "\u7f16\u8f91\u7ad9\u70b9\u70ed\u8bcd"));
        }
        int n3 = methodContext.getValue("LinkId", 0);
        ChannelContentLink channelContentLink = ChannelContentLink.findById(n3);
        if (channelContentLink == null) {
            throw new WCMException(200006, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label13", "\u6ca1\u6709\u627e\u5230\u70ed\u8bcd[Id=") + n3 + "]!");
        }
        if (!channelContentLink.canEdit(user)) {
            throw new WCMException(1012, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label14", "\u65e0\u6cd5\u9501\u5b9a\u5bf9\u8c61\u8fdb\u884c\u7f16\u8f91!"));
        }
        channelContentLink.setName(methodContext.getValue("LinkName"));
        channelContentLink.setLinkTitle(methodContext.getValue("LinkTitle"));
        channelContentLink.setLinkUrl(methodContext.getValue("LinkUrl"));
        channelContentLink.setOrder(methodContext.getValue("LinkOrder", -1));
        boolean bl = methodContext.getValue("ISUSEDINCHILDREN", 0) == 1;
        channelContentLink.setUsedInChildren(bl);
        channelContentLink.save(user);
        return String.valueOf(n3);
    }

    public void createFromFile(MethodContext methodContext) throws WCMException {
        Object object;
        User user = ContextHelper.getLoginUser();
        int n = methodContext.getValue("ChannelId", 0);
        int n2 = methodContext.getValue("SiteId", 0);
        if (n > 0) {
            object = Channel.findById(n);
            this.validateRight(user, (BaseChannel)object, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label20", "\u6279\u91cf\u521b\u5efa\u70ed\u8bcd"));
        } else {
            object = WebSite.findById(n2);
            this.validateRight(user, (BaseChannel)object, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label20", "\u6279\u91cf\u521b\u5efa\u70ed\u8bcd"));
        }
        object = methodContext.getValue("ImportFile");
        object = FilesMan.getFilesMan().mapFilePath((String)object, 0) + (String)object;
        TxtFileParserForContentLink txtFileParserForContentLink = new TxtFileParserForContentLink();
        Map map = txtFileParserForContentLink.parse((String)object);
        for (Object k : map.keySet()) {
            ArrayList arrayList = (ArrayList)map.get(k);
            ChannelContentLink channelContentLink = new ChannelContentLink();
            channelContentLink.setName((String)arrayList.get(0));
            channelContentLink.setLinkUrl((String)arrayList.get(1));
            if (n > 0) {
                channelContentLink.setChnlId(n);
                boolean bl = Integer.parseInt((String)arrayList.get(2)) == 1;
                channelContentLink.setUsedInChildren(bl);
            } else {
                channelContentLink.setSiteId(n2);
                channelContentLink.setChnlId(0);
            }
            channelContentLink.setLinkTitle((String)arrayList.get(3));
            channelContentLink.save(user);
        }
    }

    public void importSysLinks(MethodContext methodContext) throws WCMException {
        Object object;
        User user = this.getLoginUser();
        int n = methodContext.getValue("ChannelId", 0);
        int n2 = methodContext.getValue("SiteId", 0);
        int n3 = methodContext.getValue("sameNameOpera", 0);
        if (n > 0) {
            object = this.findChannelById(n);
            this.validateRight(user, (BaseChannel)object, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label15", "\u8bbe\u7f6e\u680f\u76ee\u70ed\u8bcd"));
        } else {
            object = WebSite.findById(n2);
            this.validateRight(user, (BaseChannel)object, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label19", "\u8bbe\u7f6e\u7ad9\u70b9\u70ed\u8bcd"));
        }
        object = methodContext.getValue("ContentLinkTypeIds");
        if (!CMyString.isEmpty((String)object)) {
            String string = "ContentLinkType in(" + (String)object + ")";
            WCMFilter wCMFilter = new WCMFilter("", string, "ContentLinkType,ContentLinkId desc");
            ContentLinks contentLinks = new ContentLinks(user);
            contentLinks.open(wCMFilter);
            ContentLink contentLink = null;
            ChannelContentLink channelContentLink = null;
            int n4 = 0;
            int n5 = contentLinks.size();
            for (int i = 0; i < n5; ++i) {
                contentLink = (ContentLink)contentLinks.getAt(i);
                if (contentLink == null || (n4 = n > 0 ? this.existsLink(contentLink, n, true) : this.existsLink(contentLink, n2, false)) != 0 && n3 == 0) continue;
                channelContentLink = n4 != 0 ? ChannelContentLink.findById(n4) : new ChannelContentLink();
                if (n > 0) {
                    channelContentLink.setChnlId(n);
                } else {
                    channelContentLink.setSiteId(n2);
                    channelContentLink.setChnlId(0);
                }
                channelContentLink.setName(contentLink.getName());
                channelContentLink.setLinkTitle(contentLink.getLinkTitle());
                channelContentLink.setLinkUrl(contentLink.getLinkUrl());
                channelContentLink.setOrder(-1);
                channelContentLink.setSysContentLinkId(contentLink.getId());
                channelContentLink.save(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int existsLink(ContentLink contentLink, int n, boolean bl) {
        String string = bl ? "ChannelId=?" : "SiteId=?";
        String string2 = "SELECT LinkId FROM WcmChannelContentLink WHERE LinkName=? AND " + string;
        if (m_oDbManager == null) {
            m_oDbManager = DBManager.getDBManager();
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = m_oDbManager.getConnection();
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, contentLink.getName());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n2 = 0;
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            int n3 = n2;
            return n3;
        }
        catch (Exception exception) {
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            m_oDbManager.freeConnection(connection);
        }
        return 0;
    }

    public Object changeOrder(MethodContext methodContext) throws WCMException {
        BaseChannel baseChannel;
        int n = methodContext.getValue("LinkId", 0);
        int n2 = methodContext.getValue("ChannelId", 0);
        int n3 = methodContext.getValue("SiteId", 0);
        User user = ContextHelper.getLoginUser();
        ChannelContentLink channelContentLink = ChannelContentLink.findById(n);
        if (channelContentLink == null) {
            throw new WCMException(200006, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label13", "\u6ca1\u6709\u627e\u5230\u70ed\u8bcd[Id=") + n + "]!");
        }
        if (n2 > 0) {
            baseChannel = this.findChannelById(n2);
            this.validateRight(user, baseChannel, WCMRightTypes.CONTENT_LINK_EDIT, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label12", "\u7f16\u8f91\u680f\u76ee\u70ed\u8bcd"));
        } else {
            baseChannel = WebSite.findById(n3);
            this.validateRight(user, baseChannel, WCMRightTypes.CONTENT_LINK_EDIT, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label18", "\u7f16\u8f91\u7ad9\u70b9\u70ed\u8bcd"));
        }
        if (!channelContentLink.canEdit(user)) {
            throw new WCMException(1012, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label16", "\u4e0d\u80fd\u9501\u5b9a\u5bf9\u8c61\u5b8c\u6210\u8fdb\u884c\u4fee\u6539\uff01"));
        }
        int n4 = channelContentLink.getOrder();
        int n5 = methodContext.getValue("NewOrder", n4);
        if (n5 != n4) {
            channelContentLink.setOrder(n5);
            channelContentLink.save(user);
        }
        return String.valueOf(n5);
    }
}

