/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentExporter;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IDeleteServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.List;

public class ChnlDocServiceProvider
implements ISelfDefinedServiceProvider,
IDeleteServiceProvider {
    private DocumentMgr m_oDocumentMgr = null;
    private PublishServer m_oPublishServer = PublishServer.getInstance();
    private static final int TRANSMIT_COPY = 1;
    private static final int TRANSMIT_QUOTE = 2;
    private static final int TRANSMIT_MIRROR = 3;

    public ChnlDocServiceProvider() {
        this.m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    }

    public void changeStatus(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Status status = Status.findById(methodContext.getValue("StatusId", 0));
        if (status == null) {
            throw new WCMException(1100, I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label1", "\u6307\u5b9a\u7684\u6587\u6863\u72b6\u6001\u4e0d\u5b58\u5728\uff01"));
        }
        this.validateRight(user, methodContext.getObjectIds(), status.getRightIndex(), I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label2", "\u6539\u53d8\u6587\u6863\u72b6\u6001\u4e3a[") + status.getDisp() + "]");
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        int n = chnlDocs.size();
        for (int i = 0; i < n; ++i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null) continue;
            this.m_oDocumentMgr.changeStatus(status.getId(), chnlDoc);
        }
    }

    public Reports copy(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ToChannelIds");
        Channels channels = Channels.findByIds(user, string);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        return this.transmit(user, chnlDocs, channels, 1);
    }

    public Reports quote(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ToChannelIds");
        Channels channels = Channels.findByIds(user, string);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        return this.transmit(user, chnlDocs, channels, 2);
    }

    public Reports mirror(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        String string = methodContext.getValue("ToChannelIds");
        Channels channels = Channels.findByIds(user, string);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        return this.transmit(user, chnlDocs, channels, 3);
    }

    public Reports move(MethodContext methodContext) throws Throwable {
        Channel channel;
        User user = this.getLoginUser();
        if (!this.hasRight(user, channel = this.findChannelById(methodContext.getValue("ToChannelId", 0)), 31)) {
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label3", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u76ee\u6807\u680f\u76ee\u4e0b\u521b\u5efa\u6587\u6863[ID=") + channel.getId() + ",Name=" + channel.getDispDesc() + "]!", null);
        }
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        return this.move(user, chnlDocs, channel);
    }

    public void delete(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        boolean bl = methodContext.getValue("Drop", false);
        this.validateRight(user, methodContext.getObjectIds(), 33, I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label4", "\u5220\u9664"));
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        int n = chnlDocs.size();
        for (int i = 0; i < n; ++i) {
            Document document;
            Channel channel;
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || (channel = chnlDoc.getChannel()) == null || (document = chnlDoc.getDocument()) == null) continue;
            this.m_oDocumentMgr.delete(document, channel, bl);
        }
    }

    public String export(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        Documents documents = this.findDocumentsByChnlDocIds(user, methodContext.getObjectIds());
        String string = methodContext.getValue("ExportFields");
        boolean bl = methodContext.getValue("ExportAppendix", false);
        documents.setFilter(new WCMFilter("", "", "", string));
        this.validateRight(user, null, documents, 34, I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label5", "\u5bfc\u51fa\u6587\u6863"));
        DocumentExporter documentExporter = (DocumentExporter)DreamFactory.createObjectById("DocumentExporter");
        String string2 = documentExporter.export(documents, string, bl);
        methodContext.setContentTypeIsHTML();
        return string2;
    }

    public void publish(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        ChnlDocs chnlDocs = ChnlDocs.findByIds(user, methodContext.getObjectIds());
        int n = methodContext.getValue("PublishType", 8);
        int n2 = chnlDocs.size();
        for (int i = 0; i < n2; ++i) {
            Document document;
            Channel channel;
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || (channel = chnlDoc.getChannel()) == null || (document = chnlDoc.getDocument()) == null) continue;
            this.publishDocument(user, channel, document, n);
        }
    }

    private boolean publishDocument(User user, Channel channel, Document document, int n) throws WCMException {
        if (!this.hasRight(user, channel, document, 39)) {
            return false;
        }
        IPublishFolder iPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        IPublishContent iPublishContent = (IPublishContent)PublishElementFactory.makeElementFrom(document);
        iPublishContent.setFolder(iPublishFolder);
        this.m_oPublishServer.publishContent(iPublishContent, n);
        return true;
    }

    private Reports transmit(User user, ChnlDocs chnlDocs, Channels channels, int n) throws WCMException {
        int n2;
        String string = this.makeTransmitDesc(n);
        Reports reports = new Reports(string + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label6", "\u6587\u6863"));
        if (!user.isAdministrator()) {
            for (n2 = channels.size() - 1; n2 >= 0; --n2) {
                Channel channel = (Channel)channels.getAt(n2);
                if (channel == null) {
                    reports.addFailedReport(string + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label7", "\u5931\u8d25:\u680f\u76ee[ID=") + channels.getIdAt(n2) + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label8", "]\u6ca1\u6709\u627e\u5230!"), null);
                    channels.removeAt(n2, false);
                    continue;
                }
                if (AuthServer.hasRight(user, (CMSObj)channel, 31)) continue;
                reports.addFailedReport(string + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label9", "\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u4e0b\u521b\u5efa\u6587\u6863[ID=") + channels.getIdAt(n2) + ",Name=" + channel.getDispDesc() + "]!", null);
                channels.removeAt(n2, false);
            }
        }
        int n3 = chnlDocs.size();
        for (n2 = 0; n2 < n3; ++n2) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(n2);
            if (chnlDoc == null) {
                reports.addFailedReport(string + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label10", "\u5931\u8d25:\u6587\u6863[ID=") + chnlDocs.getIdAt(n2) + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label8", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            Channel channel = chnlDoc.getChannel();
            if (channel == null) {
                reports.addFailedReport(string + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label11", "\u5931\u8d25:\u6587\u6863\u7684\u680f\u76ee[Id=") + chnlDoc.getChannelId() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label12", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            Document document = chnlDoc.getDocument();
            if (document == null) {
                reports.addFailedReport(string + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label13", "\u5931\u8d25:\u6587\u6863[Id=") + chnlDoc.getDocId() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label12", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            if (!this.hasRight(user, channel, document, 34)) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label14", "\u5f15\u7528\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\u6587\u6863[Id=") + document.getId() + ",Title=" + document.getTitle() + "]!", null);
                continue;
            }
            int n4 = channels.size();
            for (int i = 0; i < n4; ++i) {
                Channel channel2 = (Channel)channels.getAt(i);
                if (channel2 == null) {
                    reports.addFailedReport(string + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label7", "\u5931\u8d25:\u680f\u76ee[ID=") + channels.getIdAt(i) + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label8", "]\u6ca1\u6709\u627e\u5230!"), null);
                    continue;
                }
                this.transmit(channel, document, channel2, n, reports);
            }
        }
        return reports;
    }

    private void transmit(Channel channel, Document document, Channel channel2, int n, Reports reports) {
        String string = this.makeTransmitDesc(n);
        if (channel2.isVirtual()) {
            string = I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label15", "\u5f15\u7528");
        }
        try {
            switch (n) {
                case 1: {
                    this.m_oDocumentMgr.copyDocument(document, channel, channel2);
                    break;
                }
                case 2: {
                    this.m_oDocumentMgr.quoteTo(document, channel2);
                    break;
                }
                case 3: {
                    this.m_oDocumentMgr.mirrorTo(document, channel2);
                }
            }
            reports.addSucessedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label16", "\u6210\u529f") + string + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label17", "\u6587\u6863[") + document.getTitle() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label18", "]\u5230\u680f\u76ee[") + channel2.getDispDesc() + "]\uff01");
        }
        catch (Throwable throwable) {
            reports.addFailedReport(string + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label17", "\u6587\u6863[") + document.getTitle() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label18", "]\u5230\u680f\u76ee[") + channel2.getDispDesc() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label19", "]\u5931\u8d25\uff01"), throwable);
        }
    }

    private String makeTransmitDesc(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label20", "\u590d\u5236");
                break;
            }
            case 2: {
                string = I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label15", "\u5f15\u7528");
                break;
            }
            case 3: {
                string = I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label21", "\u955c\u50cf");
            }
        }
        return string;
    }

    private Reports move(User user, ChnlDocs chnlDocs, Channel channel) throws WCMException {
        Reports reports = new Reports(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label22", "\u79fb\u52a8\u6587\u6863"));
        int n = chnlDocs.size();
        for (int i = 0; i < n; ++i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label23", "\u79fb\u52a8\u5931\u8d25:\u6587\u6863[ID=") + chnlDocs.getIdAt(i) + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label8", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            Channel channel2 = chnlDoc.getChannel();
            if (channel2 == null) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label24", "\u79fb\u52a8\u5931\u8d25:\u5f85\u590d\u5236\u7684\u6587\u6863\u7684\u680f\u76ee[Id=") + chnlDoc.getChannelId() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label12", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            Document document = chnlDoc.getDocument();
            if (document == null) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label25", "\u79fb\u52a8\u5931\u8d25:\u5f85\u590d\u5236\u7684\u6587\u6863[Id=") + chnlDoc.getDocId() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label12", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            if (!this.hasRight(user, channel2, document, 33)) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label26", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8\u6587\u6863[Id=") + document.getId() + ",Title=" + document.getTitle() + "]!", null);
                continue;
            }
            try {
                reports.addReport(this.m_oDocumentMgr.moveTo(document, channel2, channel));
                continue;
            }
            catch (Throwable throwable) {
                reports.addFailedReport(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label27", "\u79fb\u52a8\u6587\u6863[") + document.getTitle() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label18", "]\u5230\u680f\u76ee[") + channel2.getDispDesc() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label19", "]\u5931\u8d25\uff01"), throwable);
            }
        }
        return reports;
    }

    public ChnlDocs search(MethodContext methodContext) throws WCMException {
        int n;
        String string;
        String string2;
        User user = this.getLoginUser();
        CMSBaseObjs cMSBaseObjs = null;
        String string3 = methodContext.getValue("ChannelIds");
        String string4 = methodContext.getValue("SiteIds");
        String string5 = methodContext.getValue("FromTable");
        boolean bl = string5 != null && string5.indexOf(44) > 0;
        boolean bl2 = false;
        if (string3 != null && string3.length() > 0) {
            cMSBaseObjs = Channels.findByIds(user, string3);
            string2 = (bl ? "WCMDocument.DocId=WCMChnlDoc.DocId and WCMDocument.DocChannel>0 and " : "") + "WCMChnlDoc.DocStatus>0 and WCMChnlDoc.ChnlId in(";
            string = ")";
            bl2 = true;
        } else if (string4 != null && string4.length() > 0) {
            cMSBaseObjs = WebSites.findByIds(user, string4);
            string2 = (bl ? "WCMDocument.DocId=WCMChnlDoc.DocId and WCMDocument.DocChannel>0 and " : "") + "WCMChnlDoc.DocStatus>0 and exists(Select ChannelId from WCMChannel where Status>=0 and SiteId in(";
            string = ") and WCMChannel.ChannelId=WCMChnlDoc.ChnlId)";
        } else {
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label28", "\u6ca1\u6709\u6307\u5b9a\u68c0\u7d22\u7684\u680f\u76ee[ChannelIds]\u6216\u8005\u68c0\u7d22\u7684\u7ad9\u70b9[SiteIds]\uff01"));
        }
        if (bl2 && methodContext.getValue("ContainsChildren", false)) {
            n = cMSBaseObjs.size();
            for (int i = 0; i < n; ++i) {
                Channel channel = (Channel)cMSBaseObjs.getAt(i);
                if (channel == null) continue;
                this.makeChildren((Channels)cMSBaseObjs, channel);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length() + cMSBaseObjs.size() * 2 + string.length() + 4);
        stringBuffer.append(string2);
        WCMFilter wCMFilter = new WCMFilter();
        n = 1;
        int n2 = cMSBaseObjs.size();
        for (int i = 0; i < n2; ++i) {
            BaseChannel baseChannel = (BaseChannel)cMSBaseObjs.getAt(i);
            if (baseChannel == null || !this.isValidateRight(user, baseChannel, 30)) continue;
            if (n == 0) {
                stringBuffer.append(',');
            } else {
                n = 0;
            }
            stringBuffer.append('?');
            wCMFilter.addSearchValues(baseChannel.getId());
        }
        stringBuffer.append(string);
        wCMFilter.setWhere(stringBuffer.toString());
        wCMFilter.mergeWith(methodContext.getExtraWCMFilter());
        wCMFilter.mergeWith(this.makeTimeFilterByType(methodContext.getValue("CrTimeInterval", 0), "WCMChnlDoc.CrTime"));
        wCMFilter.mergeWith(this.makeTimeFilterByType(methodContext.getValue("PubTimeInterval", 0), "WCMChnlDoc.DocPubTime"));
        return ChnlDocs.openWCMObjs(user, wCMFilter);
    }

    private boolean hasRight(User user, Channel channel, Document document, int n) throws WCMException {
        return DocumentAuthServer.hasRight(user, (BaseChannel)channel, document, n);
    }

    private boolean hasRight(User user, Channel channel, int n) throws WCMException {
        if (user.isAdministrator()) {
            return true;
        }
        return AuthServer.hasRight(user, (CMSObj)channel, n);
    }

    private Channels findChannelsByChnlDocIds(User user, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", "RecId in(" + string + ")", "", "ChnlId As ChannelId");
        return Channels.openWCMObjs(user, wCMFilter);
    }

    private Documents findDocumentsByChnlDocIds(User user, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("WCMChnlDoc", "RecId in(" + string + ")", "", "DocId");
        return Documents.openWCMObjs(user, wCMFilter);
    }

    private void validateRight(User user, String string, int n, String string2) throws WCMException {
        if (user.isAdministrator()) {
            return;
        }
        Channels channels = this.findChannelsByChnlDocIds(user, string);
        int n2 = channels.size();
        for (int i = 0; i < n2; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || AuthServer.hasRight(user, (CMSObj)channel, n)) continue;
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label29", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label30", "]\u6ca1\u6709\u6743\u9650\u5728(") + channel + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label31", ")\u4e0a\u6267\u884c[") + string2 + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label32", "]\u64cd\u4f5c\uff01"));
        }
    }

    private void validateRight(User user, Channel channel, Documents documents, int n, String string) throws WCMException {
        int n2 = documents.size();
        for (int i = 0; i < n2; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            this.validateRight(user, channel, document, n, string);
        }
    }

    private void validateRight(User user, Channel channel, Document document, int n, String string) throws WCMException {
        if (!this.hasRight(user, channel, document, n)) {
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label29", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + user.getName() + I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label33", "]\u6ca1\u6709\u6743\u9650") + string + ":" + document + "\uff01");
        }
    }

    private Channel findChannelById(int n) throws WCMException {
        Channel channel = Channel.findById(n);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label34", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + n + "]\uff01");
        }
        return channel;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void makeChildren(Channels channels, Channel channel) throws WCMException {
        List list = channel.getChildren(null);
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Channel channel2 = (Channel)list.get(i);
            if (channel2 == null) continue;
            channels.addElement(channel2);
            this.makeChildren(channels, channel2);
        }
    }

    private WCMFilter makeTimeFilterByType(int n, String string) throws WCMException {
        WCMFilter wCMFilter = new WCMFilter("", string + ">=?", "");
        try {
            switch (n) {
                case 5: {
                    wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(3, -3));
                    break;
                }
                case 6: {
                    wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(12, -1));
                    break;
                }
                case 7: {
                    wCMFilter.addSearchValues(0, CMyDateTime.now().dateAdd(2, -1));
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            throw new WCMException(I18NMessage.get(ChnlDocServiceProvider.class, "ChnlDocServiceProvider.label35", "\u6784\u9020\u65f6\u95f4\u8fc7\u6ee4\u5668\u5931\u8d25!"), exception);
        }
        return wCMFilter;
    }

    private boolean isValidateRight(User user, BaseChannel baseChannel, int n) throws WCMException {
        if (user.isAdministrator()) {
            return true;
        }
        return AuthServer.hasRight(user, (CMSObj)baseChannel, n);
    }
}

