/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.XmlToRightConvertor;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.RoleAuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.XmlObject;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class AuthServiceProvider
implements ISelfDefinedServiceProvider {
    public String saveOperatorRights(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        CMSObj cMSObj = this.makeOperator(methodContext);
        this.validLoginUserIsAdminOfOperator(user, cMSObj);
        XmlToRightConvertor xmlToRightConvertor = new XmlToRightConvertor(2);
        XmlObject[] xmlObjectArray = xmlToRightConvertor.convertXml(methodContext.getValue("RightsXML"), null);
        int n = xmlObjectArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 5);
        for (int i = 0; i < n; ++i) {
            XmlObject xmlObject = xmlObjectArray[i];
            Right right = (Right)xmlObject.getCurrentObj();
            if (right.isAddMode()) {
                right.setOperator(cMSObj);
            } else {
                right.validCanEditAndLock(user);
            }
            right.save(user);
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(right.getId());
        }
        methodContext.setReturnHTML(true);
        return stringBuffer.toString();
    }

    public String deleteOperatorRight(MethodContext methodContext) throws Exception {
        User user = this.getLoginUser();
        Right right = Right.findById(methodContext.getObjectId());
        if (right == null) {
            throw new WCMException(I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label1", "\u6307\u5b9a\u7684Right\u5bf9\u8c61\u4e0d\u5b58\u5728![ID=") + methodContext.getObjectId() + "]");
        }
        CMSObj cMSObj = right.getOperator();
        this.validLoginUserIsAdminOfOperator(user, cMSObj);
        CMSObj cMSObj2 = this.makeObject(right.getObjType(), right.getObjId());
        int n = 59;
        if (cMSObj2 instanceof WebSite) {
            n = 7;
        } else if (cMSObj2 instanceof Channel) {
            n = 55;
        }
        if (!AuthServer.hasRight(user, cMSObj2, n)) {
            throw new WCMException(I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u7ed9\u5f53\u524d\u5bf9\u8c61\u8bbe\u7f6e\u6743\u9650\uff01(\u64cd\u4f5c\u4eba=") + user + I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label3", ",\u5bf9\u8c61=") + cMSObj2 + ")");
        }
        right.delete(user);
        methodContext.setReturnHTML(true);
        return AuthServer.getRightValue(cMSObj2, cMSObj).toString();
    }

    private CMSObj makeOperator(MethodContext methodContext) throws WCMException {
        int n = methodContext.getValue("OperatorId", 0);
        int n2 = methodContext.getValue("OperatorType", 0);
        CMSObj cMSObj = (CMSObj)BaseObj.findById(n2, n);
        if (cMSObj == null) {
            throw new WCMException(I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label4", "\u627e\u4e0d\u5230\u6307\u5b9a\u7684Operator[Type=") + n2 + ",Id=" + n + I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label5", "]\u6216\u8bb8\u88ab\u5220\u9664\uff1f"));
        }
        return cMSObj;
    }

    private CMSObj makeObject(int n, int n2) throws WCMException {
        CMSObj cMSObj = (CMSObj)BaseObj.findById(n, n2);
        if (cMSObj == null) {
            throw new WCMException(I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label6", "\u627e\u4e0d\u5230\u6307\u5b9a\u7684Object[Type=") + n + ",Id=" + n2 + I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label5", "]\u6216\u8bb8\u88ab\u5220\u9664\uff1f"));
        }
        return cMSObj;
    }

    private void validLoginUserIsAdminOfOperator(User user, CMSObj cMSObj) throws WCMException {
        if (user.isAdministrator()) {
            return;
        }
        switch (cMSObj.getWCMType()) {
            case 204: {
                User user2 = (User)cMSObj;
                Groups groups = user2.getGroups();
                int n = groups.size();
                for (int i = 0; i < n; ++i) {
                    Group group = (Group)groups.getAt(i);
                    if (group == null || !this.isAdminOfGroup(user, group)) continue;
                    return;
                }
                break;
            }
            case 201: {
                if (!this.isAdminOfGroup(user, (Group)cMSObj)) break;
                return;
            }
            case 203: {
                if (!RoleAuthServer.hasRight(user, (Role)cMSObj, 11)) break;
                return;
            }
        }
        throw new WCMException(I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label7", "\u7528\u6237[") + user.getName() + I18NMessage.get(AuthServiceProvider.class, "AuthServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406") + cMSObj + "\uff01");
    }

    private boolean isAdminOfGroup(User user, Group group) throws WCMException {
        if (group == null) {
            return false;
        }
        if (group.isAdministrator(user)) {
            return true;
        }
        return this.isAdminOfGroup(user, group.getParent());
    }

    private User getLoginUser() {
        User user = ContextHelper.getLoginUser();
        return user;
    }
}

