/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.WCMApplyFormProcessServiceHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.Flow;
import com.trs.components.gkml.sqgk.persistent.ApplyForm;
import com.trs.components.gkml.sqgk.persistent.ApplyForms;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;
import java.util.Map;

public class ApplyFormServiceProvider
implements ISelfDefinedServiceProvider {
    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public void startDocumentInFlow(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        ApplyForm applyForm = ApplyForm.findById(methodContext.getObjectId());
        if (applyForm == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u4f9d\u7533\u8bf7\u4e0d\u5b58\u5728![ObjectId=" + methodContext.getObjectId() + "]");
        }
        if (!AuthServer.hasRight(user, (CMSObj)applyForm, 32)) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u8ba9\u4f9d\u7533\u8bf7[" + applyForm.toString() + "]\u6d41\u8f6c\uff01");
        }
        WCMApplyFormProcessServiceHelper.startApplyFormInFlow(user, applyForm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAppendixes(MethodContext methodContext) throws Throwable {
        User user = this.getLoginUser();
        int n = methodContext.getValue("AppendixType", 50);
        int n2 = methodContext.getValue("ApplyFormId", 0);
        ApplyForm applyForm = ApplyForm.findById(n2);
        int n3 = methodContext.getValue("FlowDocId", 0);
        if (n3 > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(user, applyForm, n3, 0, "\u4fdd\u5b58\u9644\u4ef6");
        } else if (!AuthServer.hasRight(user, (CMSObj)applyForm, 32)) {
            throw new WCMException(1002, "\u60a8\u4e0d\u80fd\u8fdb\u884c[\u4fdd\u5b58\u9644\u4ef6]\u64cd\u4f5c\uff01");
        }
        XMLToCMSObj xMLToCMSObj = new XMLToCMSObj(user, new Appendix());
        xMLToCMSObj.parse(methodContext.getValue("AppendixesXML"));
        String string = xMLToCMSObj.getObjectIds();
        if (!CMyString.isEmpty(string)) {
            DBManager.getDBManager().sqlExecuteUpdate("delete from WCMAppendix where AppDocId=" + -n2 + " and AppFlag=" + n + " and APPENDIXID not in (" + string + ")");
        } else {
            DBManager.getDBManager().sqlExecuteUpdate("delete from WCMAppendix where AppDocId=" + -n2 + " and AppFlag=" + n);
        }
        boolean bl = true;
        try {
            int n4 = xMLToCMSObj.getCMSObjs().length;
            for (int i = 0; i < n4; ++i) {
                Appendix appendix = (Appendix)xMLToCMSObj.getCMSObjs()[i];
                if (appendix == null) continue;
                appendix.setSerialNo(i + 1);
                if (appendix.isAddMode()) {
                    appendix.setFlag(n);
                    appendix.setDocId(-n2);
                    this.moveAppendixFile(appendix);
                }
                appendix.save();
            }
            bl = false;
        }
        finally {
            if (bl) {
                xMLToCMSObj.cancelUpdate();
            }
        }
    }

    private void moveAppendixFile(Appendix appendix) throws WCMException {
        int n = appendix.getFlag();
        String string = appendix.getFile();
        if (string == null) {
            return;
        }
        if (n != 40 && string.indexOf(47) < 0) {
            boolean bl;
            FilesMan filesMan = FilesMan.getFilesMan();
            String string2 = filesMan.getFileFlag(string);
            boolean bl2 = bl = string2 != "W0" && string2 != "P0";
            if (bl) {
                try {
                    string = 10 == n ? filesMan.moveWCMFile(string, "P0", false) : filesMan.moveWCMFile(string, "W0", false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            appendix.setFileExt(CMyFile.extractFileExt(string));
            appendix.setFile(CMyFile.extractFileName(string));
        }
    }

    public String getFlowingStat(MethodContext methodContext) throws Throwable {
        try {
            Flow flow = WCMApplyFormProcessServiceHelper.getFlow();
            Map map = this.parseFlowingPath(flow.getPropertyAsString("OperationMarkEnum"));
            if (map == null || map.isEmpty()) {
                return null;
            }
            this.fillFromRecords(map, methodContext);
            StringBuffer stringBuffer = new StringBuffer();
            for (Map.Entry object2 : map.entrySet()) {
                Object k = object2.getKey();
                Integer n = (Integer)object2.getValue();
                if (k == null || n == null) continue;
                String string = WCMProcessServiceHelper.makeXMLNode("StageName", k.toString());
                string = string + WCMProcessServiceHelper.makeXMLNode("StageCounter", String.valueOf(n));
                stringBuffer.append(WCMProcessServiceHelper.makeXMLNode("Stage", string, false));
            }
            String string = WCMProcessServiceHelper.makeXMLNode("Stages", stringBuffer.toString(), false);
            stringBuffer.setLength(0);
            return string;
        }
        catch (WCMException wCMException) {
            return WCMProcessServiceHelper.makeXMLNode("errmsg", wCMException.getMessage());
        }
    }

    private Map fillFromRecords(Map map, MethodContext methodContext) throws Throwable {
        ApplyForms applyForms = ApplyForms.createNewInstance(this.getLoginUser());
        applyForms.open(methodContext.getExtraWCMFilter());
        if (applyForms == null || applyForms.size() <= 0) {
            return null;
        }
        ApplyForm applyForm = null;
        CPager cPager = new CPager(-1);
        int n = applyForms.size();
        cPager.setItemCount(n);
        for (int i = cPager.getFirstItemIndex() - 1; i < cPager.getLastItemIndex(); ++i) {
            String string;
            applyForm = (ApplyForm)applyForms.getAt(i);
            if (applyForm == null || CMyString.isEmpty(string = applyForm.getPropertyAsString("FLOWOPERATIONMARK"))) continue;
            Integer n2 = (Integer)map.get(string);
            if (n2 == null) {
                n2 = new Integer(0);
            }
            map.put(string, new Integer(n2 + 1));
        }
        return map;
    }

    public Map parseFlowingPath(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        String string2 = string;
        if (CMyString.isEmpty(string2)) {
            return hashMap;
        }
        String[] stringArray = (string2 = string2.replaceAll("(\\{|\\}|\\[|\\])", "")).split(",");
        if (stringArray.length <= 2) {
            return hashMap;
        }
        for (int i = 1; i < stringArray.length - 1; ++i) {
            String string3 = stringArray[i];
            if (CMyString.isEmpty(string3)) continue;
            hashMap.put(string3, null);
        }
        return hashMap;
    }
}

