/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.ImageUtil;
import java.io.File;
import javax.activation.FileDataSource;
import junit.framework.TestCase;

public class ImageUtilTest
extends TestCase {
    private File file;

    protected void setUp() throws Exception {
        super.setUp();
        FileDataSource fds = new FileDataSource("resource/Thailand.JPG");
        this.file = fds.getFile();
    }

    public void testGetDefaultDestPath() throws Exception {
        String filepath = this.file.getPath();
        ImageUtilTest.assertEquals((String)filepath.replaceAll("(?i)\\.jpg", "_s\\.jpg"), (String)ImageUtil.getDefaultDestPath(filepath));
    }

    public void testGetImageHeight() throws Exception {
        ImageUtilTest.assertEquals((int)1536, (int)ImageUtil.getImageHeight(this.file.getPath()));
    }

    public void testGetImageWidth() throws Exception {
        ImageUtilTest.assertEquals((int)2048, (int)ImageUtil.getImageWidth(this.file.getPath()));
    }

    public void testResizeFix() throws Exception {
        String sourcePath = this.file.getPath();
        ImageUtil.setMaxWidth(2048);
        ImageUtil.setMaxHeight(1536);
        ImageUtilTest.assertFalse((ImageUtil.resizeFix(sourcePath) == 0 ? 1 : 0) != 0);
        String destPath = ImageUtil.getDefaultDestPath(sourcePath);
        ImageUtil.setMaxWidth(1024);
        ImageUtil.setMaxHeight(768);
        ImageUtilTest.assertTrue((ImageUtil.resizeFix(sourcePath) == 0 ? 1 : 0) != 0);
        ImageUtilTest.assertEquals((int)1024, (int)ImageUtil.getImageWidth(destPath));
        ImageUtilTest.assertEquals((int)768, (int)ImageUtil.getImageHeight(destPath));
    }
}

