/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.publish;

import com.trs.infra.config.ConfigConstants;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMySign;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class PreviewURLSign {
    private static Logger logger = Logger.getLogger(PreviewURLSign.class);
    private static final String SIGNED_STRING = "trs_wcm_preview_access";
    public static final String SIGNED_STRING_KEY = "sign";

    public static String[] getUniqueSignedStrs(String[] strs, String privateKeyPath) {
        String wcmPulicKeyPath = String.valueOf(ConfigConstants.DIR_APPROOT) + "public_platform_log.key";
        FilesMan filesMan = FilesMan.getFilesMan();
        String local = filesMan.getPathConfig("LV").getLocalPath();
        String previewPublicKeyDir = String.valueOf(local) + "WEB-INF" + File.separator + "classes" + File.separator;
        String previewPublicKeyPath = String.valueOf(previewPublicKeyDir) + "public_platform_log.key";
        File file = new File(previewPublicKeyPath);
        logger.debug((Object)previewPublicKeyPath);
        logger.debug((Object)wcmPulicKeyPath);
        if (!file.exists()) {
            try {
                CMyFile.copyFile((String)wcmPulicKeyPath, (String)previewPublicKeyPath);
            }
            catch (CMyException e) {
                logger.error((Object)"\u590d\u5236\u7b7e\u540d\u6587\u4ef6\u5230\u9884\u89c8\u76ee\u5f55\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        try {
            Calendar cal = Calendar.getInstance();
            CMySign su = CMySign.getSign((String)privateKeyPath);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            DataOutputStream dos = new DataOutputStream(bos);
            int i = 0;
            while (i < strs.length) {
                dos.writeUTF(SIGNED_STRING);
                dos.writeInt(cal.get(1));
                dos.writeInt(cal.get(2));
                dos.writeInt(cal.get(5));
                dos.writeInt(cal.get(11));
                dos.writeInt(cal.get(12));
                dos.writeInt(cal.get(13));
                dos.flush();
                bos.flush();
                String sDataWithSign = su.encodeRadix64(bos.toByteArray());
                if (strs[i].indexOf("?") > 0) {
                    int n = i;
                    strs[n] = String.valueOf(strs[n]) + "&sign=" + sDataWithSign;
                } else {
                    int n = i;
                    strs[n] = String.valueOf(strs[n]) + "?sign=" + sDataWithSign;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strs;
    }

    public static boolean checkSignedURL(String signedStr, String publicKeyPath) {
        block4: {
            int signedSecond;
            int signedMinuter;
            int second;
            int minuter;
            block5: {
                byte[] buff = signedStr.getBytes();
                Calendar cal = Calendar.getInstance();
                CMySign verify = CMySign.getVerify((String)publicKeyPath);
                buff = verify.decodeRadix64(buff);
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buff));
                minuter = cal.get(12);
                second = cal.get(13);
                String signedString = dis.readUTF();
                int signedYear = dis.readInt();
                int signedMonth = dis.readInt();
                int signedDate = dis.readInt();
                int signedHour = dis.readInt();
                signedMinuter = dis.readInt();
                signedSecond = dis.readInt();
                if (!signedString.equals(SIGNED_STRING) || signedYear != cal.get(1) || signedMonth != cal.get(2) || signedDate != cal.get(5) || signedHour != cal.get(11)) break block4;
                if (signedMinuter != minuter || second - signedSecond >= 2) break block5;
                return true;
            }
            try {
                if (signedMinuter == minuter - 1 && signedSecond - second > 58) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

