/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ds;

import com.kingbase8.ds.KBConnectionPoolDataSource;
import com.kingbase8.ds.common.BaseDataSource;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

@Deprecated
public class KBPoolingDataSource
extends BaseDataSource
implements DataSource {
    protected static ConcurrentMap<String, KBPoolingDataSource> dataSources = new ConcurrentHashMap<String, KBPoolingDataSource>();
    protected String dataSourceName;
    private int initialConnections = 0;
    private int maxConnections = 0;
    private boolean initialized = false;
    private Stack<PooledConnection> available = new Stack();
    private Stack<PooledConnection> used = new Stack();
    private Object lock = new Object();
    private KBConnectionPoolDataSource source;
    private ConnectionEventListener connectionEventListener = new ConnectionEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(ConnectionEvent event) {
            ((PooledConnection)event.getSource()).removeConnectionEventListener(this);
            Object object = KBPoolingDataSource.this.lock;
            synchronized (object) {
                if (KBPoolingDataSource.this.available == null) {
                    return;
                }
                boolean removed = KBPoolingDataSource.this.used.remove(event.getSource());
                if (removed) {
                    KBPoolingDataSource.this.available.push((PooledConnection)event.getSource());
                    KBPoolingDataSource.this.lock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionErrorOccurred(ConnectionEvent event) {
            ((PooledConnection)event.getSource()).removeConnectionEventListener(this);
            Object object = KBPoolingDataSource.this.lock;
            synchronized (object) {
                if (KBPoolingDataSource.this.available == null) {
                    return;
                }
                KBPoolingDataSource.this.used.remove(event.getSource());
                KBPoolingDataSource.this.lock.notify();
            }
        }
    };

    public static KBPoolingDataSource getDataSource(String name) {
        return (KBPoolingDataSource)dataSources.get(name);
    }

    @Override
    public String getDescription() {
        return "Pooling DataSource '" + this.dataSourceName + " from " + "Kingbase8 JDBC Driver V008R002B0001.jre6";
    }

    @Override
    public void setServerName(String serverName) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setServerName(serverName);
    }

    @Override
    public void setDatabaseName(String databaseName) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setDatabaseName(databaseName);
    }

    @Override
    public void setUser(String user) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setUser(user);
    }

    @Override
    public void setPassword(String password) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setPassword(password);
    }

    @Override
    public void setPortNumber(int portNumber) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setPortNumber(portNumber);
    }

    public int getInitialConnections() {
        return this.initialConnections;
    }

    public void setInitialConnections(int initialConnections) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        this.initialConnections = initialConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        this.maxConnections = maxConnections;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        if (this.dataSourceName != null && dataSourceName != null && dataSourceName.equals(this.dataSourceName)) {
            return;
        }
        KBPoolingDataSource previous = dataSources.putIfAbsent(dataSourceName, this);
        if (previous != null) {
            throw new IllegalArgumentException("DataSource with name '" + dataSourceName + "' already exists!");
        }
        if (this.dataSourceName != null) {
            dataSources.remove(this.dataSourceName);
        }
        this.dataSourceName = dataSourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.source = this.createConnectionPool();
            try {
                this.source.initializeFrom(this);
            }
            catch (Exception e) {
                throw new KSQLException(GT.tr("Failed to setup DataSource.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)e);
            }
            while (this.available.size() < this.initialConnections) {
                this.available.push(this.source.getPooledConnection());
            }
            this.initialized = true;
        }
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected KBConnectionPoolDataSource createConnectionPool() {
        return new KBConnectionPoolDataSource();
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        if (user == null || user.equals(this.getUser()) && (password == null && this.getPassword() == null || password != null && password.equals(this.getPassword()))) {
            return this.getConnection();
        }
        if (!this.initialized) {
            this.initialize();
        }
        return super.getConnection(user, password);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.getPooledConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            PooledConnection pci;
            while (!this.available.isEmpty()) {
                pci = this.available.pop();
                try {
                    pci.close();
                }
                catch (SQLException e) {}
            }
            this.available = null;
            while (true) {
                if (this.used.isEmpty()) {
                    this.used = null;
                    // MONITOREXIT @DISABLED, blocks:[3, 7, 8] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.removeStoredDataSource();
                    return;
                }
                pci = this.used.pop();
                pci.removeConnectionEventListener(this.connectionEventListener);
                try {
                    pci.close();
                }
                catch (SQLException sQLException) {
                }
            }
        }
    }

    protected void removeStoredDataSource() {
        dataSources.remove(this.dataSourceName);
    }

    protected void addDataSource(String dataSourceName) {
        dataSources.put(dataSourceName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getPooledConnection() throws SQLException {
        PooledConnection pc = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.available == null) {
                throw new KSQLException(GT.tr("DataSource has been closed.", new Object[0]), KSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            while (true) {
                if (!this.available.isEmpty()) {
                    pc = this.available.pop();
                    this.used.push(pc);
                    break;
                }
                if (this.maxConnections == 0 || this.used.size() < this.maxConnections) {
                    pc = this.source.getPooledConnection();
                    this.used.push(pc);
                    break;
                }
                try {
                    this.lock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        pc.addConnectionEventListener(this.connectionEventListener);
        return pc.getConnection();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = super.getReference();
        ref.add(new StringRefAddr("dataSourceName", this.dataSourceName));
        if (this.initialConnections > 0) {
            ref.add(new StringRefAddr("initialConnections", Integer.toString(this.initialConnections)));
        }
        if (this.maxConnections > 0) {
            ref.add(new StringRefAddr("maxConnections", Integer.toString(this.maxConnections)));
        }
        return ref;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

