/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.core;

import com.kingbase8.KBProperty;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.util.LOGGER;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ConnectionMangerV2 {
    public static Connection master;
    public static String passward;
    public static String dbName;
    public static ConcurrentHashMap<String, String> rates;
    public static ConcurrentHashMap<String, AtomicInteger> hostAcount;
    public static ConcurrentHashMap<String, AtomicInteger> totalAcount;
    public static AtomicInteger lastSlaveID;
    public static Stack<DispatchConnection> pool_available;
    public static Stack<DispatchConnection> pool_used;
    public static Object lock;
    public static ClusterMonitorThread ctmonitor;
    public static int Jdbcpoolsize;
    public static Thread thread_ct;
    public static DispatchConnection conn_check;
    public static boolean checkdb_init;
    public static boolean pgool_init;
    public static Connection pgpool_conn;
    public static boolean cluster_change;
    public static DispatchConnection ctmonitor_connect;
    public static String slave_online_ip;
    public static String master_online_ip;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DispatchConnection createConnection(String url, String passward, String dbName, Properties props) throws SQLException {
        Object object;
        boolean useconn_pool = KBProperty.USECONNECT_POOL.getBoolean(props);
        boolean usecluster_monitor = KBProperty.CLUSTER_MONITOR.getBoolean(props);
        if (useconn_pool) {
            Jdbcpoolsize = KBProperty.CONNECT_POOLSIZE.getIntNoCheck(props);
            LOGGER.log(Level.SEVERE, "createConnection:::current jdbcpool.size: {0})", new Object[]{pool_used.size() + pool_available.size()});
            int currentsize = 0;
            while (true) {
                object = lock;
                synchronized (object) {
                    currentsize = pool_available.size() + pool_used.size();
                }
                if (currentsize >= Jdbcpoolsize) break;
                DispatchConnection conn = new DispatchConnection(null, passward, dbName, props);
                if (rates.get(conn.url) == null) {
                    rates.put(conn.url, KBProperty.HOSTLOADRATE.get(props));
                    hostAcount.put(conn.url, new AtomicInteger(0));
                    totalAcount.put(conn.url, new AtomicInteger(0));
                    if (usecluster_monitor && ctmonitor == null) {
                        ctmonitor = new ClusterMonitorThread(props);
                        thread_ct = new Thread((Runnable)ctmonitor, "Kingbase8 JDBC driver cluster monitor");
                        thread_ct.setDaemon(true);
                        thread_ct.start();
                    }
                }
                if (usecluster_monitor) {
                    ctmonitor.setprops(props);
                }
                Object object2 = lock;
                synchronized (object2) {
                    pool_available.push(conn);
                }
                LOGGER.log(Level.SEVERE, "createConnection:::jdbc pool initialize: {0})", new Object[]{pool_used.size() + pool_available.size()});
            }
            object = lock;
            synchronized (object) {
                if (!pool_available.isEmpty()) {
                    DispatchConnection conn = pool_available.pop();
                    pool_used.push(conn);
                    LOGGER.log(Level.SEVERE, "createConnection:::jdbc pool return idle connect: {0})", new Object[]{pool_available.size()});
                    return conn;
                }
            }
        }
        DispatchConnection conn = new DispatchConnection(null, passward, dbName, props);
        if (rates.get(conn.url) == null) {
            rates.put(conn.url, KBProperty.HOSTLOADRATE.get(props));
            hostAcount.put(conn.url, new AtomicInteger(0));
            totalAcount.put(conn.url, new AtomicInteger(0));
            if (usecluster_monitor && ctmonitor == null) {
                object = lock;
                synchronized (object) {
                    if (ctmonitor == null) {
                        ctmonitor = new ClusterMonitorThread(props);
                        thread_ct = new Thread((Runnable)ctmonitor, "Kingbase8 JDBC driver cluster monitor");
                        thread_ct.setDaemon(true);
                        thread_ct.start();
                    }
                }
            }
        } else if (usecluster_monitor) {
            ctmonitor.setprops(props);
        }
        if (useconn_pool) {
            object = lock;
            synchronized (object) {
                pool_used.push(conn);
                LOGGER.log(Level.SEVERE, "createConnection:::jdbc pool extend pool size: {0})", new Object[]{pool_used.size() + pool_available.size()});
            }
        }
        return conn;
    }

    static {
        rates = new ConcurrentHashMap();
        hostAcount = new ConcurrentHashMap();
        totalAcount = new ConcurrentHashMap();
        lastSlaveID = new AtomicInteger(0);
        pool_available = new Stack();
        pool_used = new Stack();
        lock = new Object();
        ctmonitor = null;
        Jdbcpoolsize = 50;
        thread_ct = null;
        conn_check = null;
        checkdb_init = false;
        pgool_init = false;
        cluster_change = false;
        ctmonitor_connect = null;
        slave_online_ip = new String("");
        master_online_ip = new String("");
    }

    public static class ClusterMonitorThread
    implements Runnable {
        private Properties props;

        ClusterMonitorThread(Properties props) {
            this.setprops(props);
        }

        @Override
        public synchronized void run() {
            try {
                while (true) {
                    int monitor_interval;
                    block14: {
                        monitor_interval = KBProperty.MONITORINTERVAL.getIntNoCheck(this.props);
                        try {
                            if (ctmonitor_connect == null) {
                                ctmonitor_connect = new DispatchConnection(null, passward, dbName, this.props);
                            }
                            master_online_ip = ((KbConnection)ctmonitor_connect.getMainConn()).getHostIp();
                            String sql = String.format("select CLIENT_ADDR from sys_stat_replication", new Object[0]);
                            Statement stcheck = ctmonitor_connect.getMainConn().createStatement();
                            ResultSet rs = stcheck.executeQuery(sql);
                            String sip = "";
                            while (rs.next()) {
                                sip = sip + rs.getString(1);
                                sip = sip + ",";
                            }
                            rs.close();
                            slave_online_ip = sip;
                            LOGGER.log(Level.SEVERE, "ClusterMonitorThread current slave online: {0}", slave_online_ip);
                            if (slave_online_ip.isEmpty()) {
                                Boolean bmaster = false;
                                sql = String.format("select * from sys_is_in_recovery()", new Object[0]);
                                rs = stcheck.executeQuery(sql);
                                if (rs.next()) {
                                    bmaster = !rs.getBoolean(1);
                                }
                                rs.close();
                                if (!bmaster.booleanValue()) {
                                    try {
                                        ctmonitor_connect.CloseConnectCluter();
                                        ctmonitor_connect = null;
                                    }
                                    catch (SQLException e1) {
                                        ctmonitor_connect = null;
                                    }
                                }
                            }
                            stcheck.close();
                        }
                        catch (SQLException e) {
                            LOGGER.log(Level.SEVERE, "ClusterMonitorThread check slave info Exception: {0}", e.getMessage());
                            LOGGER.log(Level.SEVERE, e);
                            slave_online_ip = "";
                            master_online_ip = "";
                            if (ctmonitor_connect == null) break block14;
                            try {
                                ctmonitor_connect.CloseConnectCluter();
                                ctmonitor_connect = null;
                            }
                            catch (SQLException e1) {
                                ctmonitor_connect = null;
                            }
                        }
                    }
                    Thread.sleep(monitor_interval * 1000);
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "ClusterMonitorThread check slave info InterruptedException: {0}", e.getMessage());
                LOGGER.log(Level.SEVERE, e);
                pgool_init = false;
                pgpool_conn = null;
                return;
            }
        }

        public void setprops(Properties props) {
            this.props = props;
        }
    }
}

