/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.util.Yylex;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.List;

public class Word {
    public static final int ERROR = -1;
    public static final int EOF = 0;
    public static final int SEMI = 10;
    public static final int RPAREN = 11;
    public static final int LPAREN = 12;
    public static final int EXPLAIN = 100;
    public static final int CREATE = 101;
    public static final int SELECT = 102;
    public static final int INTO = 103;
    public static final int INSERT = 104;
    public static final int UPDATE = 105;
    public static final int DELETE = 106;
    public static final int FROM = 107;
    public static final int AS = 108;
    public static final int PREPARE = 109;
    public static final int GRANT = 110;
    public static final int DECLARE = 111;
    public static final int SET = 112;
    public static final int REVOKE = 113;
    public static final int AUDIT = 114;
    public static final int DROP = 115;
    public static final int AVG = 150;
    public static final int COUNT = 151;
    public static final int MAX = 152;
    public static final int MIN = 153;
    public static final int STDDEV = 154;
    public static final int SUM = 155;
    public static final int VARIANCE = 156;
    public static final int BEGIN = 116;
    public static final int ROLLBACK = 117;
    public static final int STRING_IDENTIFIER = 200;
    public static final int STRING_SINGLE = 201;
    public static final int STRING_DOUBLE = 202;
    public static final int GROUP_BY = 300;
    private int m_type;
    private String m_text;
    private int m_charBegin;
    private int m_charEnd;

    public static String getTypeString(int type) {
        switch (type) {
            case -1: {
                return "ERROR";
            }
            case 0: {
                return "EOF";
            }
            case 10: {
                return "SEMI";
            }
            case 11: {
                return "RPAREN";
            }
            case 12: {
                return "LPAREN";
            }
            case 100: {
                return "EXPLAIN";
            }
            case 101: {
                return "CREATE";
            }
            case 102: {
                return "SELECT";
            }
            case 103: {
                return "INTO";
            }
            case 104: {
                return "INSERT";
            }
            case 105: {
                return "UPDATE";
            }
            case 106: {
                return "DELETE";
            }
            case 112: {
                return "SET";
            }
            case 107: {
                return "FROM";
            }
            case 108: {
                return "AS";
            }
            case 109: {
                return "PREPARE";
            }
            case 110: {
                return "GRANT";
            }
            case 113: {
                return "REVOKE";
            }
            case 111: {
                return "DECLARE";
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                return "AGGREGATE";
            }
            case 200: {
                return "STRING_IDENTIFIER";
            }
            case 201: {
                return "STRING_SINGLE";
            }
            case 202: {
                return "STRING_DOUBLE";
            }
            case 115: {
                return "DROP";
            }
            case 116: {
                return "BEGIN";
            }
            case 117: {
                return "ROLLBACK";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printWords(String sql) {
        if (sql == null) {
            return;
        }
        boolean select = false;
        boolean create = false;
        boolean into = false;
        boolean explain = false;
        Yylex lex = null;
        try {
            lex = new Yylex(new CharArrayReader(sql.toCharArray()));
            Word w = null;
            do {
                w = lex.yylex();
                System.err.println(w);
            } while (w.m_type != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (lex != null) {
                try {
                    lex.yyclose();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parsing(String sql, List<String> list) {
        if (sql == null) {
            return false;
        }
        int select = 0;
        int create = 0;
        int into = 0;
        int explain = 0;
        int update = 0;
        int prepare = 0;
        boolean as = false;
        int grant = 0;
        int declare = 0;
        int delete = 0;
        int set = 0;
        int revoke = 0;
        int audit = 0;
        int drop = 0;
        int rollback = 0;
        int group_by = 0;
        int function = 0;
        int aggregate = 0;
        Yylex lex = null;
        Word pre = null;
        try {
            lex = new Yylex(new CharArrayReader(sql.toCharArray()));
            while (true) {
                Word w = lex.yylex();
                if (w.m_type == 0) break;
                if (w.m_type == 102) {
                    ++select;
                } else {
                    if (w.m_type == 101) {
                        ++create;
                        break;
                    }
                    if (w.m_type == 100) {
                        ++explain;
                        break;
                    }
                    if (w.m_type == 103) {
                        ++into;
                        break;
                    }
                    if (w.m_type == 105) {
                        ++update;
                        break;
                    }
                    if (w.m_type == 106) {
                        ++delete;
                        break;
                    }
                    if (w.m_type == 112) {
                        ++set;
                        break;
                    }
                    if (w.m_type == 109) {
                        ++prepare;
                        break;
                    }
                    if (w.m_type == 110) {
                        ++grant;
                        break;
                    }
                    if (w.m_type == 113) {
                        ++revoke;
                        break;
                    }
                    if (w.m_type == 111) {
                        ++declare;
                        break;
                    }
                    if (w.m_type == 115) {
                        ++drop;
                        break;
                    }
                    if (w.m_type == 114) {
                        ++audit;
                        break;
                    }
                    if (w.m_type == 150 || w.m_type == 151 || w.m_type == 152 || w.m_type == 153 || w.m_type == 154 || w.m_type == 155 || w.m_type == 156) {
                        ++aggregate;
                    } else {
                        if (w.m_type == 300) {
                            ++group_by;
                            break;
                        }
                        if (w.m_type == 116 || w.m_type == 117) {
                            ++rollback;
                            break;
                        }
                    }
                    if (!(w.m_type != 12 || list != null && list.contains(pre.m_text.toLowerCase()))) {
                        ++function;
                    }
                }
                pre = w;
            }
            lex.yyclose();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (lex != null) {
                try {
                    lex.yyclose();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (select > 0 && explain == 0 && create == 0 && update == 0 && prepare == 0 && grant == 0 && declare == 0 && function == 0 && into == 0 && set == 0 && delete == 0 && revoke == 0 && audit == 0 && drop == 0 && rollback == 0) {
            return true;
        }
        return aggregate != 0 && group_by != 0;
    }

    public static void main(String[] args) {
        System.err.println(Word.parsing("audit select on sysdba.b;", null));
    }

    public static boolean normalSelect(String sql) {
        int whereIndex;
        String upp_sql = sql.trim().toUpperCase();
        if (upp_sql.startsWith("(")) {
            upp_sql = upp_sql.substring(1).trim();
        }
        if ((whereIndex = upp_sql.indexOf(" WHERE ")) >= 0) {
            upp_sql = upp_sql.substring(0, whereIndex);
        }
        int intoIndex = upp_sql.indexOf(" INTO ");
        boolean hasInto = false;
        if (intoIndex >= 0) {
            hasInto = true;
        }
        return upp_sql.startsWith("SHOW") || upp_sql.startsWith("EXPLAIN") || upp_sql.startsWith("SELECT") && !hasInto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canExplain(String sql) {
        if (sql == null || sql == "") {
            return false;
        }
        int select = 0;
        int create = 0;
        int explain = 0;
        int update = 0;
        int delete = 0;
        int insert = 0;
        int drop = 0;
        Yylex lex = null;
        try {
            lex = new Yylex(new CharArrayReader(sql.toCharArray()));
            Word w = lex.yylex();
            while (w.m_type != 0) {
                switch (w.m_type) {
                    case 101: {
                        ++create;
                        break;
                    }
                    case 102: {
                        ++select;
                        break;
                    }
                    case 104: {
                        ++insert;
                        break;
                    }
                    case 105: {
                        ++update;
                        break;
                    }
                    case 106: {
                        ++delete;
                        break;
                    }
                    case 100: {
                        ++explain;
                        break;
                    }
                    case 115: {
                        ++drop;
                    }
                }
                w = lex.yylex();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (lex != null) {
                try {
                    lex.yyclose();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return create == 0 && explain == 0 && (select > 0 || delete > 0 || update > 0 || insert > 0 || drop > 0);
    }

    Word(int type, String text) {
        this.m_type = type;
        this.m_text = text;
        this.m_charBegin = -1;
        this.m_charEnd = -1;
    }

    Word(int type, String text, int charBegin, int charEnd) {
        this.m_type = type;
        this.m_text = text;
        this.m_charBegin = charBegin;
        this.m_charEnd = charEnd;
    }

    public String toString() {
        return Word.getTypeString(this.m_type) + " : " + this.m_text;
    }

    public int getType() {
        return this.m_type;
    }
}

