/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.BaseQueryKey;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.CallableQueryKey;
import com.kingbase8.core.JdbcCallParseInfo;
import com.kingbase8.core.NativeQuery;
import com.kingbase8.core.Parser;
import com.kingbase8.core.Query;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.QueryWithReturningColumnsKey;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.util.LruCache;
import java.sql.SQLException;
import java.util.List;
import java.util.StringTokenizer;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutor;

    public CachedQueryCreateAction(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean outParmBeforeFunc;
        boolean isFunction;
        String parsedSql;
        BaseQueryKey queryKey;
        assert (key instanceof String || key instanceof BaseQueryKey) : "Query key should be String or BaseQueryKey. Given " + key.getClass() + ", sql: " + String.valueOf(key);
        if (key instanceof BaseQueryKey) {
            queryKey = (BaseQueryKey)key;
            parsedSql = queryKey.sql;
        } else {
            queryKey = null;
            parsedSql = (String)key;
        }
        if (key instanceof String || queryKey.escapeProcessing) {
            parsedSql = Parser.replaceProcessing(parsedSql, true, this.queryExecutor.getStandardConformingStrings());
        }
        if (key instanceof CallableQueryKey) {
            JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.queryExecutor.getStandardConformingStrings(), this.queryExecutor.getServerVersionNum(), this.queryExecutor.getProtocolVersion());
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
            outParmBeforeFunc = callInfo.isOutParmBeforeFunc();
        } else {
            isFunction = false;
            outParmBeforeFunc = false;
        }
        boolean isParameterized = key instanceof String || queryKey.isParameterized;
        boolean splitStatements = isParameterized || this.queryExecutor.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) >= 0;
        String[] returningColumns = key instanceof QueryWithReturningColumnsKey ? ((QueryWithReturningColumnsKey)key).columnNames : EMPTY_RETURNING;
        List<NativeQuery> queries = Parser.parseJdbcSql(parsedSql, this.queryExecutor.getStandardConformingStrings(), isParameterized, splitStatements, this.queryExecutor.isReWriteBatchedInsertsEnabled(), returningColumns);
        this.addPrimaryKeys(queries);
        Query query = this.queryExecutor.wrap(queries);
        return new CachedQuery(key, query, isFunction, outParmBeforeFunc);
    }

    void addPrimaryKeys(List<NativeQuery> queries) throws SQLException {
        for (int i = 0; i < queries.size(); ++i) {
            NativeQuery nativeQuery = queries.get(i);
            String todo = nativeQuery.nativeSql;
            if (todo.toLowerCase().indexOf("select") == -1 || !this.hasForUpdate(todo)) continue;
            StringBuilder sb = new StringBuilder();
            StringTokenizer st = new StringTokenizer(todo, ";");
            while (st.hasMoreTokens()) {
                String str = st.nextToken().trim();
                if (todo.toLowerCase().indexOf("select") != -1 && this.hasForUpdate(str)) {
                    nativeQuery.forupdate = true;
                    String sql = str.substring(0, str.toLowerCase().indexOf("from"));
                    sql = sql + ",CTID,XMIN ";
                    sql = sql + str.substring(str.toLowerCase().indexOf("from"));
                    sb.append(sql + ";");
                    if (nativeQuery.bindPositions == null || nativeQuery.bindPositions.length == 0) continue;
                    int j = 0;
                    while (j < nativeQuery.bindPositions.length) {
                        int n = j++;
                        nativeQuery.bindPositions[n] = nativeQuery.bindPositions[n] + 11;
                    }
                    continue;
                }
                sb.append(str + ";");
            }
            nativeQuery.nativeSql = sb.toString();
        }
    }

    boolean hasForUpdate(String sql) {
        String todo = sql.toLowerCase();
        int index = todo.indexOf("for");
        while (index != -1) {
            int tempindex = index + 3;
            if (todo.charAt(tempindex) != ' ' && todo.charAt(tempindex) != '\n' && todo.charAt(tempindex) != '\t' && todo.charAt(tempindex) != '\r') {
                index = todo.indexOf("for", tempindex);
                continue;
            }
            index = Parser.skipBlank(todo, tempindex);
            if (index + 6 <= todo.length() && todo.substring(index, index + 6).equals("update")) {
                return true;
            }
            index = todo.indexOf("for", index);
        }
        return false;
    }
}

