/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowSet;
import dm.jdbc.driver.Row;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;

public class DmdbRowSetWriter
implements RowSetWriter {
    private StringBuffer jT = null;
    private StringBuffer jU = null;
    private StringBuffer jV = null;
    private int jf = 0;
    private String jW = "";
    private DmdbResultSetMetaData jX = null;
    private DmdbPreparedStatement jY = null;
    private DmdbPreparedStatement jZ = null;
    private DmdbPreparedStatement ka = null;
    private DmdbConnection fw = null;

    private void initialize(DmdbRowSet dmdbRowSet) {
        this.jX = (DmdbResultSetMetaData)dmdbRowSet.getMetaData();
        this.jf = this.jX.do_getColumnCount();
        this.fw = dmdbRowSet.getConnection();
        this.jW = dmdbRowSet.getTableName().toUpperCase();
        this.jT = new StringBuffer("UPDATE " + this.jW + " SET ");
        this.jU = new StringBuffer("INSERT INTO " + this.jW + "(");
        this.jV = new StringBuffer("DELETE FROM " + this.jW + " WHERE ");
        int n2 = 0;
        while (n2 < this.jf) {
            if (n2 > 0) {
                this.jT.append(" , ");
                this.jU.append(" , ");
            }
            this.jT.append(this.jX.do_getColumnName(n2 + 1)).append(" = ?");
            this.jU.append(this.jX.do_getColumnName(n2 + 1));
            ++n2;
        }
        this.jU.append(") VALUES(");
        this.jT.append(" WHERE ");
        n2 = 0;
        while (n2 < this.jf) {
            if (n2 > 0) {
                this.jU.append(",");
                this.jT.append(" AND ");
                this.jV.append(" AND ");
            }
            this.jU.append("?");
            this.jT.append(this.jX.do_getColumnName(n2 + 1)).append("= ?");
            this.jV.append(this.jX.do_getColumnName(n2 + 1)).append("= ?");
            ++n2;
        }
        this.jU.append(")");
        this.jZ = this.fw.do_prepareStatement(this.jU.substring(0, this.jU.length()));
        this.jY = this.fw.do_prepareStatement(this.jT.substring(0, this.jT.length()));
        this.ka = this.fw.do_prepareStatement(this.jV.substring(0, this.jV.length()));
    }

    private boolean insertRow(Row row) {
        this.jZ.do_clearParameters();
        int n2 = 0;
        while (n2 < this.jf) {
            Object object = row.getColumn(n2);
            if (object == null) {
                this.jZ.do_setNull(n2 + 1, this.jX.do_getColumnType(n2 + 1));
            } else {
                this.jZ.do_setObject(n2 + 1, object);
            }
            ++n2;
        }
        return 1 == this.jZ.do_executeUpdate();
    }

    private boolean updateRow(Row row) {
        if (row.isOriginalWithNull()) {
            return this.updateWithNull(row);
        }
        return this.updateNonNull(row);
    }

    private boolean updateWithNull(Row row) {
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.jW + " SET ");
        StringBuffer stringBuffer2 = new StringBuffer(" WHERE ");
        int[] nArray = new int[this.jf];
        int n2 = this.jf;
        int n3 = 0;
        while (n3 < this.jf) {
            if (n3 > 0) {
                stringBuffer.append(" , ");
                stringBuffer2.append(" AND ");
            }
            stringBuffer.append(this.jX.do_getColumnName(n3 + 1)).append(" = ?");
            stringBuffer2.append(this.jX.do_getColumnName(n3 + 1));
            if (row.isOriginalNull(n3)) {
                nArray[n3] = -1;
                stringBuffer2.append(" IS NULL ");
            } else {
                nArray[n3] = ++n2;
                stringBuffer2.append(" = ? ");
            }
            ++n3;
        }
        stringBuffer.append(stringBuffer2);
        DmdbPreparedStatement dmdbPreparedStatement = this.fw.do_prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        int n4 = 0;
        while (n4 < this.jf) {
            Object object;
            Object object2 = row.getColumn(n4);
            Object object3 = object = row.isColumnChanged(n4) ? row.getChangedColumn(n4) : object2;
            if (object == null) {
                dmdbPreparedStatement.do_setNull(n4 + 1, this.jX.do_getColumnType(n4 + 1));
            } else {
                dmdbPreparedStatement.do_setObject(n4 + 1, object);
            }
            if (nArray[n4] != -1) {
                dmdbPreparedStatement.do_setObject(nArray[n4], object2);
            }
            ++n4;
        }
        n4 = 1 == dmdbPreparedStatement.do_executeUpdate() ? 1 : 0;
        dmdbPreparedStatement.do_close();
        stringBuffer = null;
        stringBuffer2 = null;
        return n4 != 0;
    }

    private boolean updateNonNull(Row row) {
        int n2 = 0;
        while (n2 < this.jf) {
            Object object;
            Object object2 = row.getColumn(n2);
            Object object3 = object = row.isColumnChanged(n2) ? row.getChangedColumn(n2) : object2;
            if (object == null) {
                this.jY.do_setNull(n2 + 1, this.jX.do_getColumnType(n2 + 1));
            } else {
                this.jY.do_setObject(n2 + 1, object);
            }
            this.jY.do_setObject(this.jf + n2 + 1, object2);
            ++n2;
        }
        return 1 == this.jY.do_executeUpdate();
    }

    private boolean deleteRow(Row row) {
        if (row.isOriginalWithNull()) {
            return this.deleteWithNull(row);
        }
        return this.deleteNonNull(row);
    }

    private boolean deleteWithNull(Row row) {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.jW + " WHERE ");
        int[] nArray = new int[this.jf];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.jf) {
            if (n3 > 0) {
                stringBuffer.append(" AND ");
            }
            if (row.isOriginalNull(n3)) {
                stringBuffer.append(this.jX.do_getColumnName(n3 + 1)).append(" IS NULL ");
                nArray[n3] = -1;
            } else {
                stringBuffer.append(this.jX.do_getColumnName(n3 + 1)).append(" = ? ");
                nArray[n3] = ++n2;
            }
            ++n3;
        }
        DmdbPreparedStatement dmdbPreparedStatement = this.fw.do_prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        int n4 = 0;
        while (n4 < this.jf) {
            if (nArray[n4] != -1) {
                dmdbPreparedStatement.do_setObject(nArray[n4], row.getColumn(n4));
            }
            n4 += 1;
        }
        n4 = 1 == dmdbPreparedStatement.do_executeUpdate() ? 1 : 0;
        dmdbPreparedStatement.do_close();
        dmdbPreparedStatement = null;
        stringBuffer = null;
        return n4 != 0;
    }

    private boolean deleteNonNull(Row row) {
        int n2 = 0;
        while (n2 < this.jf) {
            this.ka.do_setObject(n2 + 1, row.getColumn(n2));
            ++n2;
        }
        return 1 == this.ka.do_executeUpdate();
    }

    private void release() {
        this.jU = null;
        if (this.jZ != null && !this.jZ.closed) {
            this.jZ.do_close();
            this.jZ = null;
        }
        this.jT = null;
        if (this.jY != null && !this.jY.closed) {
            this.jY.do_close();
            this.jY = null;
        }
        this.jV = null;
        if (this.ka != null && !this.ka.closed) {
            this.ka.do_close();
            this.ka = null;
        }
        this.jf = 0;
        this.jX = null;
        this.jW = "";
    }

    @Override
    public boolean writeData(RowSetInternal rowSetInternal) {
        DmdbRowSet dmdbRowSet = (DmdbRowSet)rowSetInternal;
        this.initialize(dmdbRowSet);
        if (this.jf < 1) {
            this.release();
            return true;
        }
        boolean bl = dmdbRowSet.getShowDeleted();
        if (this.fw.do_getAutoCommit()) {
            this.fw.do_setAutoCommit(false);
        }
        dmdbRowSet.setShowDeleted(true);
        dmdbRowSet.beforeFirst();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        while (dmdbRowSet.next()) {
            Row row;
            if (dmdbRowSet.rowInserted()) {
                if (dmdbRowSet.rowDeleted()) continue;
                row = dmdbRowSet.getCurrentRow();
                bl2 = this.insertRow(row) && bl2;
                continue;
            }
            if (dmdbRowSet.rowUpdated()) {
                row = dmdbRowSet.getCurrentRow();
                bl3 = this.updateRow(row) && bl3;
                continue;
            }
            if (!dmdbRowSet.rowDeleted()) continue;
            row = dmdbRowSet.getCurrentRow();
            boolean bl5 = bl4 = this.deleteRow(row) && bl4;
        }
        if (!(bl2 && bl3 && bl4)) {
            this.fw.do_rollback();
        } else {
            this.fw.do_commit();
            dmdbRowSet.setOriginal();
        }
        dmdbRowSet.setShowDeleted(bl);
        this.release();
        if (!dmdbRowSet.keepConnecting() && this.fw != null && !this.fw.do_isClosed()) {
            this.fw.do_close();
            this.fw = null;
        }
        return true;
    }
}

