/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.Reader;
import java.sql.SQLException;

public class DmdbReader
extends Reader {
    public static final int IS_BLOB = 0;
    public static final int IS_CLOB = 1;
    public static final int IS_STRING = 2;
    public static final int IS_BYTE = 3;
    public static final int IS_FILE_TYPE = 4;
    private DmdbBlob ij = null;
    private DmdbClob ik = null;
    private int hz;
    private String iC = null;
    byte[] iD = null;
    char[] iE = null;
    int iF = 0;
    static final int iG = 32000;
    static final int iH = 8000;
    int hC = 0;
    int iI;
    int iJ;
    private boolean closed = false;
    long iK = -1L;

    public DmdbReader(Object object) {
        if (object instanceof DmdbBlob) {
            this.ij = (DmdbBlob)object;
            this.hz = 0;
        } else if (object instanceof DmdbClob) {
            this.ik = (DmdbClob)object;
            this.hz = 1;
        } else if (object instanceof String) {
            this.hz = 2;
            this.iC = (String)object;
        } else if (object instanceof byte[]) {
            this.hz = 3;
            this.iD = (byte[])object;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
    }

    protected DmdbReader(DmdbClob dmdbClob, long l2, long l3) {
        this.hz = 1;
        this.ik = dmdbClob;
        this.iF = (int)(l2 - 1L);
        this.iK = l3;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        if (this.closed) {
            DBError.throwIOException(DBError.ECJDBC_STREAM_CLOSED.reason);
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        }
        switch (this.hz) {
            case 0: {
                return this.readFromBlob(cArray, n2, n3);
            }
            case 1: {
                return this.readFromClob(cArray, n2, n3);
            }
            case 2: {
                return this.readFromString(cArray, n2, n3);
            }
            case 3: {
                return this.readFromByteArray(cArray, n2, n3);
            }
        }
        DBError.throwIOException("io read error.");
        return 0;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private int readFromBlob(char[] cArray, int n2, int n3) {
        int n4;
        block10: {
            block9: {
                n4 = 0;
                if (this.ij != null) break block9;
                return -1;
            }
            if (this.iK < 0L) {
                this.iK = this.ij.do_length();
            }
            if (this.iD != null && (this.iI = this.iD.length) > this.hC || this.iK > (long)this.iF) break block10;
            return -1;
        }
        try {
            long l2 = 0L;
            l2 = this.iD == null ? this.iK - (long)this.iF : this.iK - (long)this.iF + (long)this.iI - (long)this.hC;
            int n5 = (int)(l2 > (long)n3 ? (long)n3 : l2);
            while (n4 < n5) {
                int n6;
                if (this.iD == null || (this.iI = this.iD.length) <= this.hC) {
                    n6 = (int)(this.iK - (long)this.iF > 32000L ? 32000L : this.iK - (long)this.iF);
                    this.iD = this.ij.do_getBytes(this.iF + 1, n6);
                    if (this.iD == null || this.iD.length <= 0) {
                        this.iD = new byte[0];
                        this.hC = 0;
                        this.iI = n6;
                        break;
                    }
                    this.hC = 0;
                    this.iI = n6;
                    this.iF += n6;
                }
                n6 = n5 - n4 < this.iI - this.hC ? n5 - n4 : this.iI - this.hC;
                int n7 = 0;
                while (n7 < n6) {
                    cArray[n2 + n7] = (char)this.iD[this.hC + n7];
                    ++n7;
                }
                n2 += n6;
                this.hC += n6;
                n4 += n6;
            }
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n4;
    }

    private int readFromClob(char[] cArray, int n2, int n3) {
        int n4;
        block9: {
            block8: {
                n4 = 0;
                if (this.ik != null) break block8;
                return -1;
            }
            if (this.iK < 0L) {
                this.iK = this.ik.do_length();
            }
            if (this.iE != null && (this.iJ = this.iE.length) > this.hC || this.iK > (long)this.iF) break block9;
            return -1;
        }
        try {
            long l2 = 0L;
            l2 = this.iE == null ? this.iK - (long)this.iF : this.iK - (long)this.iF + (long)this.iJ - (long)this.hC;
            int n5 = (int)(l2 > (long)n3 ? (long)n3 : l2);
            while (n4 < n5) {
                int n6;
                if (this.iE == null || (this.iJ = this.iE.length) <= this.hC) {
                    n6 = (int)(this.iK - (long)this.iF > 8000L ? 8000L : this.iK - (long)this.iF);
                    String string = this.ik.do_getSubString(this.iF + 1, n6);
                    if (string == null || string.length() <= 0) {
                        this.iE = new char[0];
                        this.hC = 0;
                        this.iJ = 0;
                        break;
                    }
                    this.iE = new char[n6];
                    string.getChars(0, n6, this.iE, 0);
                    this.hC = 0;
                    this.iF += n6;
                    this.iJ = n6;
                }
                n6 = n5 - n4 < this.iJ - this.hC ? n5 - n4 : this.iJ - this.hC;
                System.arraycopy(this.iE, this.hC, cArray, n2, n6);
                n2 += n6;
                this.hC += n6;
                n4 += n6;
            }
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n4;
    }

    private int readFromString(char[] cArray, int n2, int n3) {
        int n4;
        if (this.iC == null || (this.iJ = this.iC.length()) <= this.hC) {
            return -1;
        }
        int n5 = n4 = n3 > this.iJ - this.hC ? this.iJ - this.hC : n3;
        if (n2 + n4 > cArray.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        }
        this.iC.getChars(this.hC, this.hC + n4, cArray, n2);
        this.hC += n4;
        return n4;
    }

    private int readFromByteArray(char[] cArray, int n2, int n3) {
        int n4;
        if (this.iD == null || (this.iI = this.iD.length) <= this.hC) {
            return -1;
        }
        int n5 = n4 = n3 > this.iI - this.hC ? this.iI - this.hC : n3;
        if (n2 + n4 > cArray.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        }
        int n6 = 0;
        while (n6 < n4) {
            cArray[n2 + n6] = (char)this.iD[n6 + this.hC];
            ++n6;
        }
        this.hC += n4;
        return n4;
    }
}

