/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.a.b;
import dm.jdbc.a.c;
import dm.jdbc.b.d;
import dm.jdbc.b.j;
import dm.jdbc.b.k;
import dm.jdbc.b.l;
import dm.jdbc.b.p;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbSQLOutput;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DmdbPreparedStatement
extends DmdbStatement
implements PreparedStatement {
    public int it = 2;
    public l[] fa = new l[0];
    public int fb = 0;
    public List iu = null;
    public boolean iv;
    public Object[] iw = null;
    public int ix = 0;
    public static final byte BIND_IN = 1;
    public static final byte BIND_OUT = 16;
    public byte[] iy = null;
    public String[] iz = null;
    public boolean iA;
    public k iB;

    private DmdbPreparedStatement(DmdbConnection dmdbConnection, String string, int n2, int n3, int n4, int n5) {
        super(dmdbConnection, n2, n3, n4);
        this.type = 2;
        this.it = n5;
        this.allocateHandle(string);
    }

    public DmdbPreparedStatement(DmdbConnection dmdbConnection, String string, int n2) {
        this(dmdbConnection, string, dmdbConnection.connection_property_resultSetType, 1007, dmdbConnection.hg, n2);
    }

    public DmdbPreparedStatement(DmdbConnection dmdbConnection, String string, int n2, int n3, int n4) {
        this(dmdbConnection, string, n2, n3, n4, 2);
    }

    @Override
    protected void allocateHandle() {
    }

    protected void allocateHandle(String string) {
        k k2 = this.iB = this.connection.hl != null && this.connection.hl.size() > 0 ? (k)this.connection.hl.get(string) : null;
        if (this.iB != null) {
            this.fx = this.iB.fx;
            this.fy = this.iB.fy;
            this.fz = this.iB.fz;
            this.kj = string;
            this.fa = this.iB.fa;
            this.fb = this.iB.fb;
            this.ix = 0;
            this.iu = new ArrayList();
            this.iw = new Object[this.iB.fb];
            this.iy = new byte[this.iB.fb];
            this.fc = this.iB.fc;
            this.closed = false;
        } else {
            super.allocateHandle();
            try {
                this.prepareSql(string);
            }
            catch (SQLException sQLException) {
                this.free();
                throw sQLException;
            }
        }
    }

    private void prepareSql(String string) {
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_SQL_IS_EMPTY.throwException(new String[0]);
        }
        this.kj = string;
        if (this.km) {
            try {
                this.kj = this.connection.do_nativeSQL(string);
            }
            catch (Exception exception) {}
        }
        this.fc = this.connection.he.a(this);
        this.ix = 0;
        this.iu = new ArrayList();
        this.iw = new Object[this.fb];
        this.iy = new byte[this.fb];
    }

    @Override
    public void do_close() {
        if (!this.closed && this.ku && !this.iA && this.connection.connection_property_pstmtPoolMaxSize > 0) {
            this.do_clearBatch();
            this.do_clearWarnings();
            this.clearResultSets();
            this.connection.hl.put(this.kj, this.iB != null ? this.iB : new k(this.fx, this.fy, this.fz, this.kj, this.fa, this.fc));
            if (this.connection != null && this.connection.hk != null) {
                this.connection.hk.remove(this);
            }
            this.connection = null;
            this.closed = true;
            return;
        }
        super.do_close();
    }

    @Override
    public void reconnect() {
        super.reconnect();
        this.allocateHandle(this.kj);
    }

    private void checkAllParamsBind() {
        if (this.ix > 0) {
            return;
        }
        int n2 = 0;
        while (n2 < this.fb) {
            if (this.fa[n2].type == 120) {
                if (this.fa[n2].fo == null) {
                    this.fa[n2].fo = this.connection.do_createStatement();
                }
                int n3 = n2;
                this.iy[n3] = (byte)(this.iy[n3] | 1);
            } else if (this.fa[n2].ioType != 1 && (this.iy[n2] & 1) == 0) {
                if (this.fa[n2].ioType == 2) {
                    int n4 = n2;
                    this.iy[n4] = (byte)(this.iy[n4] | 1);
                    this.iw[n2] = null;
                } else {
                    DBError.ECJDBC_UNBINDED_PARAMETER.throwException(new String[0]);
                    break;
                }
            }
            ++n2;
        }
    }

    private void executeInner() {
        this.checkAllParamsBind();
        this.fc = this.connection.he.a(this, this.iw, false);
        if (this.fc.eJ) {
            this.ks = this.createAndCacheResultSet((short)1, this.fc);
        }
    }

    private long[] executeBatchByRow() {
        if (this.ix > 0) {
            int n2 = this.ix;
            this.fc = new j();
            this.fc.eV = new long[n2];
            ArrayList<String> arrayList = new ArrayList<String>();
            SQLException sQLException = null;
            int n3 = 0;
            while (n3 < n2) {
                block15: {
                    try {
                        try {
                            j sQLException2 = this.connection.he.a(this, (Object[])this.iu.get(n3), n3 != 0);
                            this.fc.a(sQLException2, n3, 1);
                        }
                        catch (SQLException sQLException2) {
                            this.fc.eV[n3] = -3L;
                            sQLException = sQLException2;
                            if (this.connection.compatibleOracle()) {
                                this.fc.eV[n3] = -2L;
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.connection.compatibleOracle()) {
                            this.fc.eV[n3] = -2L;
                        }
                        throw throwable;
                    }
                    if (this.connection.compatibleOracle()) {
                        this.fc.eV[n3] = -2L;
                    }
                }
                if (sQLException != null) {
                    if (this.connection.connection_property_continueBatchOnError) {
                        arrayList.add("row[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                        SQLWarning sQLWarning = new SQLWarning("row[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                        this.addSQLWarning(sQLWarning);
                    } else {
                        long[] lArray = new long[n3];
                        System.arraycopy(this.fc.eV, 0, lArray, 0, n3);
                        DBError.throwBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), lArray);
                    }
                }
                ++n3;
            }
            if (arrayList.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : arrayList) {
                    stringBuilder.append(StringUtil.LINE_SEPARATOR).append(string);
                }
                DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + stringBuilder.toString(), DBError.EC_BP_WITH_ERROR.ga, DBError.EC_BP_WITH_ERROR.fZ, this.fc.eV);
            }
            return this.fc.eV;
        }
        return new long[0];
    }

    public boolean do_execute() {
        try {
            this.beforeExecute();
            this.executeInner();
            boolean bl = this.ks != null;
            return bl;
        }
        finally {
            this.afterExecute();
        }
    }

    public DmdbResultSet do_executeQuery() {
        try {
            this.beforeExecute();
            this.executeInner();
            DmdbResultSet dmdbResultSet = this.ks == null ? DmdbResultSet.newEmptyResultSet(this) : this.ks;
            return dmdbResultSet;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate() {
        try {
            this.beforeExecute();
            this.executeInner();
            if (!this.connection.compatibleOracle() && this.ks != null) {
                DBError.ECJDBC_INVALID_SQL_TYPE.throwException(new String[0]);
            }
            int n2 = this.do_getUpdateCount();
            return n2;
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public int[] do_executeBatch() {
        long[] lArray = this.do_executeLargeBatch();
        int[] nArray = lArray == null ? new int[]{} : new int[lArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = ConvertUtil.toInt(lArray[n2]);
            ++n2;
        }
        return nArray;
    }

    @Override
    public long[] do_executeLargeBatch() {
        if (this.kr != null && this.kr.size() > 0) {
            return super.do_executeLargeBatch();
        }
        try {
            int n2;
            this.beforeExecute();
            if (this.connection.readOnly) {
                DBError.ECJDBC_READ_ONLY_CONNECTION.throwException(new String[0]);
            }
            if (this.fc.eY == 160 || this.fc.eY == 198) {
                DBError.throwBatchUpdateException(DBError.ECJDBC_INVALID_SQL_TYPE.reason, DBError.ECJDBC_INVALID_SQL_TYPE.ga, DBError.ECJDBC_INVALID_SQL_TYPE.fZ, new long[0]);
            }
            int n3 = n2 = this.ix > 0 ? this.ix : 0;
            if (n2 > 0) {
                if (n2 == 1 || this.connection.connection_property_batchType == 2 || this.connection.connection_property_callBatchNot && this.fc.eY == 162) {
                    long[] lArray = this.executeBatchByRow();
                    return lArray;
                }
                this.fc = this.connection.he.b(this, this.iu);
                long[] lArray = this.fc.eV;
                return lArray;
            }
            long[] lArray = new long[]{};
            return lArray;
        }
        finally {
            this.do_clearBatch();
            this.afterExecute();
        }
    }

    public void do_addBatch() {
        this.checkAllParamsBind();
        this.iu.add(this.iw);
        ++this.ix;
        Object[] objectArray = new Object[this.fb];
        System.arraycopy(this.iw, 0, objectArray, 0, this.fb);
        this.iw = objectArray;
    }

    @Override
    public void do_clearBatch() {
        super.do_clearBatch();
        this.do_clearParameters();
    }

    public void do_clearParameters() {
        this.ix = 0;
        if (this.iu != null) {
            this.iu.clear();
        }
        this.iw = new Object[this.fb];
        this.iy = new byte[this.fb];
        int n2 = 0;
        while (n2 < this.fb) {
            this.fa[n2].clear();
            ++n2;
        }
        this.iv = false;
    }

    public DmdbResultSetMetaData do_getMetaData() {
        return new DmdbResultSetMetaData(this.connection, this.columns);
    }

    public DmdbParameterMetaData do_getParameterMetaData() {
        return new DmdbParameterMetaData(this);
    }

    @Override
    public DmdbResultSet do_getGeneratedKeys() {
        if (this.iz != null && this.fc.eI != null && this.fc.eI.size() > 0) {
            d[] dArray = new d[this.iz.length];
            byte[][][] byArray = new byte[this.fc.eI.size()][this.iz.length + 1][];
            int n2 = 0;
            byte[][] byArray2 = null;
            int n3 = 0;
            while (n3 < this.fc.eI.size()) {
                byArray2 = (byte[][])this.fc.eI.get(n3);
                int n4 = 0;
                while (n4 < this.iz.length) {
                    n2 = this.fa.length - this.iz.length + n4;
                    dArray[n4] = new d();
                    dArray[n4].type = this.fa[n2].type;
                    dArray[n4].prec = this.fa[n2].prec;
                    dArray[n4].scale = this.fa[n2].scale;
                    dArray[n4].am = this.fa[n2].am;
                    dArray[n4].name = this.iz[n4];
                    dArray[n4].an = this.fa[n2].an;
                    dArray[n4].schemaName = this.fa[n2].schemaName;
                    dArray[n4].tableName = this.fa[n2].tableName;
                    byArray[n3][n4 + 1] = new byte[byArray2[n2].length];
                    ByteUtil.setBytes(byArray[n3][n4 + 1], 0, byArray2[n2]);
                    ++n4;
                }
                ++n3;
            }
            return DmdbResultSet.newLocalResultSet(this, dArray, byArray);
        }
        return super.do_getGeneratedKeys();
    }

    private boolean prepareBindInParam(int n2, int n3) {
        if (n2 < 1 || n2 > this.fb) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwException(new String[0]);
        }
        int n4 = n2 - 1;
        if (this.fa[n4].ioType == 1) {
            return false;
        }
        int n5 = n4;
        this.iy[n5] = (byte)(this.iy[n5] | 1);
        if (this.ix == 0 && this.fa[n4].fh != 1) {
            this.fa[n4].e(n3);
        }
        return true;
    }

    private void setNullInner(int n2, int n3) {
        if (!this.prepareBindInParam(n2, n3)) {
            return;
        }
        this.iw[n2 - 1] = null;
    }

    public void do_setNull(int n2, int n3) {
        this.setNullInner(n2, DmdbType.j2dType(n3));
    }

    public void do_setNull(int n2, int n3, String string) {
        this.setNullInner(n2, DmdbType.j2dType(n3));
    }

    public void do_setBoolean(int n2, boolean bl) {
        if (!this.prepareBindInParam(n2, 5)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(bl, this.fa[n3], this.connection);
    }

    public void do_setByte(int n2, byte by) {
        if (!this.prepareBindInParam(n2, 5)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(by, this.fa[n3], this.connection);
    }

    public void do_setShort(int n2, short s2) {
        if (!this.prepareBindInParam(n2, 6)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n2 - 1] = b.a(s2, this.fa[n3], this.connection);
    }

    public void do_setInt(int n2, int n3) {
        if (!this.prepareBindInParam(n2, 7)) {
            return;
        }
        int n4 = n2 - 1;
        this.iw[n4] = b.a(n3, this.fa[n4], this.connection);
    }

    public void do_setLong(int n2, long l2) {
        if (!this.prepareBindInParam(n2, 8)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(l2, this.fa[n3], this.connection);
    }

    public void do_setFloat(int n2, float f2) {
        if (!this.prepareBindInParam(n2, 10)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(f2, this.fa[n3], this.connection);
    }

    public void do_setDouble(int n2, double d2) {
        if (!this.prepareBindInParam(n2, 11)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(d2, this.fa[n3], this.connection);
    }

    public void do_setBigDecimal(int n2, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.setNullInner(n2, 2);
            return;
        }
        int n3 = n2 - 1;
        if (!this.prepareBindInParam(n2, 2)) {
            return;
        }
        this.iw[n3] = b.a(bigDecimal, this.fa[n3], this.connection);
    }

    public void do_setString(int n2, String string) {
        if (string == null || string.length() == 0 && DmdbType.emptyStringToNull(this.fa[n2 - 1].type)) {
            this.setNullInner(n2, 2);
            return;
        }
        if (!this.prepareBindInParam(n2, 2)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(string, this.fa[n3], this.connection);
        if (!this.iv) {
            this.iv = this.iw[n3] instanceof c;
        }
    }

    public void do_setBytes(int n2, byte[] byArray) {
        if (byArray == null) {
            this.setNullInner(n2, 18);
            return;
        }
        if (!this.prepareBindInParam(n2, 18)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(byArray, this.fa[n3], this.connection);
        if (!this.iv) {
            this.iv = this.iw[n3] instanceof c;
        }
    }

    public void do_setDate(int n2, Date date) {
        this.do_setDate(n2, date, null);
    }

    public void do_setDate(int n2, Date date, Calendar calendar) {
        if (date == null) {
            this.setNullInner(n2, 14);
            return;
        }
        if (!this.prepareBindInParam(n2, 14)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(date, this.fa[n3], this.connection, calendar);
    }

    public void do_setTime(int n2, Time time) {
        this.do_setTime(n2, time, null);
    }

    public void do_setTime(int n2, Time time, Calendar calendar) {
        if (time == null) {
            this.setNullInner(n2, 15);
            return;
        }
        if (!this.prepareBindInParam(n2, 15)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(time, this.fa[n3], this.connection, calendar);
    }

    public void do_setTimestamp(int n2, Timestamp timestamp) {
        this.do_setTimestamp(n2, timestamp, null);
    }

    public void do_setTimestamp(int n2, Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            this.setNullInner(n2, 16);
            return;
        }
        if (!this.prepareBindInParam(n2, 16)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(timestamp, this.fa[n3], this.connection, calendar);
    }

    public void do_setAsciiStream(int n2, InputStream inputStream) {
        this.do_setAsciiStream(n2, inputStream, -1);
    }

    public void do_setAsciiStream(int n2, InputStream inputStream, int n3) {
        this.do_setAsciiStream(n2, inputStream, (long)n3);
    }

    public void do_setAsciiStream(int n2, InputStream inputStream, long l2) {
        if (inputStream instanceof DmdbInputStream) {
            DmdbInputStream dmdbInputStream = (DmdbInputStream)inputStream;
            Object object = dmdbInputStream.useRealObject(l2);
            if (object instanceof DmdbBlob) {
                this.do_setBlob(n2, (Blob)object);
                return;
            }
            if (object instanceof DmdbClob) {
                this.do_setClob(n2, (Clob)object);
                return;
            }
            if (object instanceof byte[]) {
                this.do_setBytes(n2, (byte[])object);
                return;
            }
        }
        if (inputStream == null) {
            this.setNullInner(n2, 12);
            return;
        }
        if (!this.prepareBindInParam(n2, 12)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(inputStream, this.fa[n3], this.connection, l2);
        if (!this.iv) {
            this.iv = this.iw[n3] instanceof c;
        }
    }

    public void do_setUnicodeStream(int n2, InputStream inputStream) {
        this.do_setUnicodeStream(n2, inputStream, -1);
    }

    public void do_setUnicodeStream(int n2, InputStream inputStream, int n3) {
        if (inputStream == null) {
            this.setNullInner(n2, 12);
            return;
        }
        if (!this.prepareBindInParam(n2, 12)) {
            return;
        }
        int n4 = n2 - 1;
        this.iw[n4] = b.a(inputStream, this.fa[n4], this.connection, (long)n3);
        if (!this.iv) {
            this.iv = this.iw[n4] instanceof c;
        }
    }

    public void do_setBinaryStream(int n2, InputStream inputStream) {
        this.do_setBinaryStream(n2, inputStream, -1);
    }

    public void do_setBinaryStream(int n2, InputStream inputStream, long l2) {
        if (inputStream instanceof DmdbInputStream) {
            DmdbInputStream dmdbInputStream = (DmdbInputStream)inputStream;
            Object object = dmdbInputStream.useRealObject(l2);
            if (object instanceof DmdbBlob) {
                this.do_setBlob(n2, (Blob)object);
                return;
            }
            if (object instanceof DmdbClob) {
                this.do_setClob(n2, (Clob)object);
                return;
            }
            if (object instanceof byte[]) {
                this.do_setBytes(n2, (byte[])object);
                return;
            }
        }
        if (inputStream == null) {
            this.setNullInner(n2, 12);
            return;
        }
        if (!this.prepareBindInParam(n2, 12)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(inputStream, this.fa[n3], this.connection, l2);
        if (!this.iv) {
            this.iv = this.iw[n3] instanceof c;
        }
    }

    public void do_setBinaryStream(int n2, InputStream inputStream, int n3) {
        this.do_setBinaryStream(n2, inputStream, (long)n3);
    }

    public void do_setCharacterStream(int n2, Reader reader) {
        this.do_setCharacterStream(n2, reader, -1);
    }

    public void do_setCharacterStream(int n2, Reader reader, int n3) {
        this.do_setCharacterStream(n2, reader, (long)n3);
    }

    public void do_setCharacterStream(int n2, Reader reader, long l2) {
        if (reader == null) {
            this.setNullInner(n2, 19);
            return;
        }
        if (!this.prepareBindInParam(n2, 19)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(reader, this.fa[n3], this.connection, l2);
        if (!this.iv) {
            this.iv = this.iw[n3] instanceof c;
        }
    }

    public void do_setBlob(int n2, Blob blob) {
        if (blob == null) {
            this.setNullInner(n2, 12);
            return;
        }
        if (!this.prepareBindInParam(n2, 12)) {
            return;
        }
        int n3 = n2 - 1;
        Object object = this.iw[n3] = blob instanceof DmdbBlob ? b.a((DmdbBlob)blob, this.fa[n3], this.connection) : b.a(blob.getBinaryStream(), this.fa[n3], this.connection, -1L);
        if (!this.iv) {
            this.iv = this.iw[n3] instanceof c;
        }
    }

    public void do_setClob(int n2, Clob clob) {
        if (clob == null) {
            this.setNullInner(n2, 19);
            return;
        }
        if (!this.prepareBindInParam(n2, 19)) {
            return;
        }
        int n3 = n2 - 1;
        Object object = this.iw[n3] = clob instanceof DmdbClob ? b.a((DmdbClob)clob, this.fa[n3], this.connection) : b.a(clob.getCharacterStream(), this.fa[n3], this.connection, -1L);
        if (!this.iv) {
            this.iv = this.iw[n3] instanceof c;
        }
    }

    public void do_setArray(int n2, Array array) {
        if (array == null) {
            this.setNullInner(n2, 117);
            return;
        }
        if (!this.prepareBindInParam(n2, 117)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a((DmdbArray)array, this.fa[n3], this.connection);
        if (!this.iv) {
            this.iv = this.iw[n3] instanceof c;
        }
    }

    public void do_setStruct(int n2, Struct struct) {
        if (struct == null) {
            this.setNullInner(n2, 119);
            return;
        }
        if (!this.prepareBindInParam(n2, 119)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a((DmdbStruct)struct, this.fa[n3], this.connection);
        if (!this.iv) {
            this.iv = this.iw[n3] instanceof c;
        }
    }

    public void do_setObject(int n2, Object object) {
        this.do_setObject(n2, object, 0, -1);
    }

    public void do_setObject(int n2, Object object, int n3) {
        this.do_setObject(n2, object, n3, -1);
    }

    public void do_setObject(int n2, Object object, int n3, int n4) {
        this.do_setObject(n2, object, n3, (long)n4);
    }

    public void do_setObject(int n2, Object object, int n3, long l2) {
        if (l2 != -1L && (n3 == 3 || n3 == 2) && DmdbType.canCastToDecimal(object)) {
            String string = "";
            string = object instanceof Boolean ? ((Boolean)object != false ? "1" : "0") : String.valueOf(object);
            BigDecimal bigDecimal = new BigDecimal(string);
            object = bigDecimal.setScale((int)l2, 4);
        }
        if (object == null) {
            this.do_setNull(n2, n3);
        } else if (object instanceof Boolean) {
            this.do_setBoolean(n2, (Boolean)object);
        } else if (object instanceof Byte) {
            this.do_setByte(n2, (Byte)object);
        } else if (object instanceof Short) {
            this.do_setShort(n2, (Short)object);
        } else if (object instanceof Integer) {
            this.do_setInt(n2, (Integer)object);
        } else if (object instanceof Long) {
            this.do_setLong(n2, (Long)object);
        } else if (object instanceof Float) {
            this.do_setFloat(n2, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.do_setDouble(n2, (Double)object);
        } else if (object instanceof BigDecimal) {
            this.do_setBigDecimal(n2, (BigDecimal)object);
        } else if (object instanceof byte[]) {
            this.do_setBytes(n2, (byte[])object);
        } else if (object instanceof String) {
            this.do_setString(n2, (String)object);
        } else if (object instanceof Clob) {
            this.do_setClob(n2, (Clob)object);
        } else if (object instanceof Blob) {
            this.do_setBlob(n2, (Blob)object);
        } else if (object instanceof InputStream) {
            this.do_setBinaryStream(n2, (InputStream)object, l2);
        } else if (object instanceof Reader) {
            this.do_setCharacterStream(n2, (Reader)object, l2);
        } else if (object instanceof Array) {
            this.do_setArray(n2, (Array)object);
        } else if (object instanceof BigInteger) {
            this.do_setBigDecimal(n2, new BigDecimal((BigInteger)object));
        } else if (object instanceof Character) {
            this.do_setString(n2, object.toString());
        } else if (object instanceof DmdbBFile) {
            this.do_setString(n2, ((DmdbBFile)object).getFileName());
        } else if (object instanceof Struct) {
            this.do_setStruct(n2, (Struct)object);
        } else if (object instanceof SQLData) {
            this.do_setSQLData(n2, (SQLData)object);
        } else if (object instanceof RowId) {
            this.do_setRowId(n2, (RowId)object);
        } else if (object instanceof DmdbTimestamp) {
            this.do_setTIMESTAMP(n2, (DmdbTimestamp)object);
        } else if (object instanceof DmdbIntervalDT) {
            this.do_setINTERVALDT(n2, (DmdbIntervalDT)object);
        } else if (object instanceof DmdbIntervalYM) {
            this.do_setINTERVALYM(n2, (DmdbIntervalYM)object);
        } else if (object instanceof Date) {
            this.do_setDate(n2, (Date)object);
        } else if (object instanceof Time) {
            this.do_setTime(n2, (Time)object);
        } else if (object instanceof Timestamp) {
            this.do_setTimestamp(n2, (Timestamp)object);
        } else if (object instanceof java.util.Date) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((java.util.Date)object));
        } else if (object instanceof LocalDate) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((LocalDate)object));
        } else if (object instanceof LocalTime) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((LocalTime)object));
        } else if (object instanceof LocalDateTime) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((LocalDateTime)object));
        } else if (object instanceof ZonedDateTime) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((ZonedDateTime)object));
        } else if (object instanceof OffsetDateTime) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((OffsetDateTime)object));
        } else if (object instanceof OffsetTime) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((OffsetTime)object));
        } else {
            DBError.ECJDBC_UNSUPPORTED_TYPE.throwException(new String[0]);
        }
    }

    public void do_setSQLData(int n2, SQLData sQLData) {
        String string = sQLData.getSQLTypeName();
        if (this.connection.do_getTypeMap().containsKey(string) && sQLData.getClass() == this.connection.do_getTypeMap().get(string)) {
            p p2 = p.a(string, this.connection);
            DmdbSQLOutput dmdbSQLOutput = new DmdbSQLOutput();
            sQLData.writeSQL(dmdbSQLOutput);
            DmdbStruct dmdbStruct = new DmdbStruct(p2, this.connection, dmdbSQLOutput.getAttribs());
            this.do_setStruct(n2, dmdbStruct);
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
    }

    public void do_setURL(int n2, URL uRL) {
        if (uRL == null) {
            this.setNullInner(n2, 25);
            return;
        }
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_setRef(int n2, Ref ref) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public boolean isRetrunGeneratedKeys() {
        return this.it == 1;
    }

    public void do_setNString(int n2, String string) {
        this.do_setString(n2, string);
    }

    public void do_setNCharacterStream(int n2, Reader reader, long l2) {
        this.do_setCharacterStream(n2, reader, l2);
    }

    public void do_setNClob(int n2, Reader reader, long l2) {
        this.do_setClob(n2, reader, l2);
    }

    public void do_setNCharacterStream(int n2, Reader reader) {
        this.do_setCharacterStream(n2, reader);
    }

    public void do_setNClob(int n2, Reader reader) {
        this.do_setClob(n2, reader);
    }

    public void do_setRowId(int n2, RowId rowId) {
        if (rowId == null) {
            this.setNullInner(n2, 8);
        } else {
            long l2 = ((DmdbRowId)rowId).getValue();
            this.do_setLong(n2, l2);
        }
    }

    public void do_setNClob(int n2, NClob nClob) {
        this.do_setClob(n2, nClob);
    }

    public void do_setClob(int n2, Reader reader, long l2) {
        this.do_setCharacterStream(n2, reader, l2);
    }

    public void do_setBlob(int n2, InputStream inputStream, long l2) {
        this.do_setBinaryStream(n2, inputStream, l2);
    }

    public void do_setSQLXML(int n2, SQLXML sQLXML) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_setClob(int n2, Reader reader) {
        this.do_setCharacterStream(n2, reader);
    }

    public void do_setBlob(int n2, InputStream inputStream) {
        this.do_setBinaryStream(n2, inputStream);
    }

    public void do_setObject(int n2, Object object, SQLType sQLType, int n3) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_setObject(int n2, Object object, SQLType sQLType) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public long do_executeLargeUpdate() {
        try {
            this.beforeExecute();
            this.executeInner();
            if (!this.connection.compatibleOracle() && this.ks != null) {
                DBError.ECJDBC_INVALID_SQL_TYPE.throwException(new String[0]);
            }
            long l2 = this.do_getLargeUpdateCount();
            return l2;
        }
        finally {
            this.afterExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeQuery();
            }
            return this.filterChain.reset().PreparedStatement_executeQuery(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate();
            }
            return this.filterChain.reset().PreparedStatement_executeUpdate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeBatch();
            }
            return this.filterChain.reset().PreparedStatement_executeBatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeBatch();
            }
            return this.filterChain.reset().PreparedStatement_executeLargeBatch(this);
        }
    }

    @Override
    public void setNull(int n2, int n3) {
        if (this.filterChain == null) {
            this.do_setNull(n2, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setNull(this, n2, n3);
        }
    }

    @Override
    public void setBoolean(int n2, boolean bl) {
        if (this.filterChain == null) {
            this.do_setBoolean(n2, bl);
        } else {
            this.filterChain.reset().PreparedStatement_setBoolean(this, n2, bl);
        }
    }

    @Override
    public void setByte(int n2, byte by) {
        if (this.filterChain == null) {
            this.do_setByte(n2, by);
        } else {
            this.filterChain.reset().PreparedStatement_setByte(this, n2, by);
        }
    }

    @Override
    public void setShort(int n2, short s2) {
        if (this.filterChain == null) {
            this.do_setShort(n2, s2);
        } else {
            this.filterChain.reset().PreparedStatement_setShort(this, n2, s2);
        }
    }

    @Override
    public void setInt(int n2, int n3) {
        if (this.filterChain == null) {
            this.do_setInt(n2, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setInt(this, n2, n3);
        }
    }

    @Override
    public void setLong(int n2, long l2) {
        if (this.filterChain == null) {
            this.do_setLong(n2, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setLong(this, n2, l2);
        }
    }

    @Override
    public void setFloat(int n2, float f2) {
        if (this.filterChain == null) {
            this.do_setFloat(n2, f2);
        } else {
            this.filterChain.reset().PreparedStatement_setFloat(this, n2, f2);
        }
    }

    @Override
    public void setDouble(int n2, double d2) {
        if (this.filterChain == null) {
            this.do_setDouble(n2, d2);
        } else {
            this.filterChain.reset().PreparedStatement_setDouble(this, n2, d2);
        }
    }

    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) {
        if (this.filterChain == null) {
            this.do_setBigDecimal(n2, bigDecimal);
        } else {
            this.filterChain.reset().PreparedStatement_setBigDecimal(this, n2, bigDecimal);
        }
    }

    @Override
    public void setString(int n2, String string) {
        if (this.filterChain == null) {
            this.do_setString(n2, string);
        } else {
            this.filterChain.reset().PreparedStatement_setString(this, n2, string);
        }
    }

    @Override
    public void setBytes(int n2, byte[] byArray) {
        if (this.filterChain == null) {
            this.do_setBytes(n2, byArray);
        } else {
            this.filterChain.reset().PreparedStatement_setBytes(this, n2, byArray);
        }
    }

    @Override
    public void setDate(int n2, Date date) {
        if (this.filterChain == null) {
            this.do_setDate(n2, date);
        } else {
            this.filterChain.reset().PreparedStatement_setDate(this, n2, date);
        }
    }

    @Override
    public void setTime(int n2, Time time) {
        if (this.filterChain == null) {
            this.do_setTime(n2, time);
        } else {
            this.filterChain.reset().PreparedStatement_setTime(this, n2, time);
        }
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp) {
        if (this.filterChain == null) {
            this.do_setTimestamp(n2, timestamp);
        } else {
            this.filterChain.reset().PreparedStatement_setTimestamp(this, n2, timestamp);
        }
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) {
        if (this.filterChain == null) {
            this.do_setAsciiStream(n2, inputStream, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setAsciiStream(this, n2, inputStream, n3);
        }
    }

    @Override
    public void setUnicodeStream(int n2, InputStream inputStream, int n3) {
        if (this.filterChain == null) {
            this.do_setUnicodeStream(n2, inputStream, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setUnicodeStream(this, n2, inputStream, n3);
        }
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) {
        if (this.filterChain == null) {
            this.do_setBinaryStream(n2, inputStream, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setBinaryStream(this, n2, inputStream, n3);
        }
    }

    @Override
    public void clearParameters() {
        if (this.filterChain == null) {
            this.do_clearParameters();
        } else {
            this.filterChain.reset().PreparedStatement_clearParameters(this);
        }
    }

    @Override
    public void setObject(int n2, Object object, int n3) {
        if (this.filterChain == null) {
            this.do_setObject(n2, object, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setObject(this, n2, object, n3);
        }
    }

    @Override
    public void setObject(int n2, Object object) {
        if (this.filterChain == null) {
            this.do_setObject(n2, object);
        } else {
            this.filterChain.reset().PreparedStatement_setObject(this, n2, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute();
            }
            return this.filterChain.reset().PreparedStatement_execute(this);
        }
    }

    @Override
    public void addBatch() {
        if (this.filterChain == null) {
            this.do_addBatch();
        } else {
            this.filterChain.reset().PreparedStatement_addBatch(this);
        }
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) {
        if (this.filterChain == null) {
            this.do_setCharacterStream(n2, reader, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setCharacterStream(this, n2, reader, n3);
        }
    }

    @Override
    public void setRef(int n2, Ref ref) {
        if (this.filterChain == null) {
            this.do_setRef(n2, ref);
        } else {
            this.filterChain.reset().PreparedStatement_setRef(this, n2, ref);
        }
    }

    @Override
    public void setBlob(int n2, Blob blob) {
        if (this.filterChain == null) {
            this.do_setBlob(n2, blob);
        } else {
            this.filterChain.reset().PreparedStatement_setBlob(this, n2, blob);
        }
    }

    @Override
    public void setClob(int n2, Clob clob) {
        if (this.filterChain == null) {
            this.do_setClob(n2, clob);
        } else {
            this.filterChain.reset().PreparedStatement_setClob(this, n2, clob);
        }
    }

    @Override
    public void setArray(int n2, Array array) {
        if (this.filterChain == null) {
            this.do_setArray(n2, array);
        } else {
            this.filterChain.reset().PreparedStatement_setArray(this, n2, array);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() {
        if (this.filterChain == null) {
            return this.do_getMetaData();
        }
        return this.filterChain.reset().PreparedStatement_getMetaData(this);
    }

    @Override
    public void setDate(int n2, Date date, Calendar calendar) {
        if (this.filterChain == null) {
            this.do_setDate(n2, date, calendar);
        } else {
            this.filterChain.reset().PreparedStatement_setDate(this, n2, date, calendar);
        }
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) {
        if (this.filterChain == null) {
            this.do_setTime(n2, time, calendar);
        } else {
            this.filterChain.reset().PreparedStatement_setTime(this, n2, time, calendar);
        }
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) {
        if (this.filterChain == null) {
            this.do_setTimestamp(n2, timestamp, calendar);
        } else {
            this.filterChain.reset().PreparedStatement_setTimestamp(this, n2, timestamp, calendar);
        }
    }

    @Override
    public void setNull(int n2, int n3, String string) {
        if (this.filterChain == null) {
            this.do_setNull(n2, n3, string);
        } else {
            this.filterChain.reset().PreparedStatement_setNull(this, n2, n3, string);
        }
    }

    @Override
    public void setURL(int n2, URL uRL) {
        if (this.filterChain == null) {
            this.do_setURL(n2, uRL);
        } else {
            this.filterChain.reset().PreparedStatement_setURL(this, n2, uRL);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        if (this.filterChain == null) {
            return this.do_getParameterMetaData();
        }
        return this.filterChain.reset().PreparedStatement_getParameterMetaData(this);
    }

    @Override
    public void setRowId(int n2, RowId rowId) {
        if (this.filterChain == null) {
            this.do_setRowId(n2, rowId);
        } else {
            this.filterChain.reset().PreparedStatement_setRowId(this, n2, rowId);
        }
    }

    @Override
    public void setNString(int n2, String string) {
        if (this.filterChain == null) {
            this.do_setNString(n2, string);
        } else {
            this.filterChain.reset().PreparedStatement_setNString(this, n2, string);
        }
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setNCharacterStream(n2, reader, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setNCharacterStream(this, n2, reader, l2);
        }
    }

    @Override
    public void setNClob(int n2, NClob nClob) {
        if (this.filterChain == null) {
            this.do_setNClob(n2, nClob);
        } else {
            this.filterChain.reset().PreparedStatement_setNClob(this, n2, nClob);
        }
    }

    @Override
    public void setClob(int n2, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setClob(n2, reader, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setClob(this, n2, reader, l2);
        }
    }

    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) {
        if (this.filterChain == null) {
            this.do_setBlob(n2, inputStream, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setBlob(this, n2, inputStream, l2);
        }
    }

    @Override
    public void setNClob(int n2, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setNClob(n2, reader, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setNClob(this, n2, reader, l2);
        }
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) {
        if (this.filterChain == null) {
            this.do_setSQLXML(n2, sQLXML);
        } else {
            this.filterChain.reset().PreparedStatement_setSQLXML(this, n2, sQLXML);
        }
    }

    @Override
    public void setObject(int n2, Object object, int n3, int n4) {
        if (this.filterChain == null) {
            this.do_setObject(n2, object, n3, n4);
        } else {
            this.filterChain.reset().PreparedStatement_setObject(this, n2, object, n3, n4);
        }
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, long l2) {
        if (this.filterChain == null) {
            this.do_setAsciiStream(n2, inputStream, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setAsciiStream(this, n2, inputStream, l2);
        }
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, long l2) {
        if (this.filterChain == null) {
            this.do_setBinaryStream(n2, inputStream, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setBinaryStream(this, n2, inputStream, l2);
        }
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setCharacterStream(n2, reader, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setCharacterStream(this, n2, reader, l2);
        }
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) {
        if (this.filterChain == null) {
            this.do_setAsciiStream(n2, inputStream);
        } else {
            this.filterChain.reset().PreparedStatement_setAsciiStream(this, n2, inputStream);
        }
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream) {
        if (this.filterChain == null) {
            this.do_setBinaryStream(n2, inputStream);
        } else {
            this.filterChain.reset().PreparedStatement_setBinaryStream(this, n2, inputStream);
        }
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) {
        if (this.filterChain == null) {
            this.do_setCharacterStream(n2, reader);
        } else {
            this.filterChain.reset().PreparedStatement_setCharacterStream(this, n2, reader);
        }
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) {
        if (this.filterChain == null) {
            this.do_setNCharacterStream(n2, reader);
        } else {
            this.filterChain.reset().PreparedStatement_setNCharacterStream(this, n2, reader);
        }
    }

    @Override
    public void setClob(int n2, Reader reader) {
        if (this.filterChain == null) {
            this.do_setClob(n2, reader);
        } else {
            this.filterChain.reset().PreparedStatement_setClob(this, n2, reader);
        }
    }

    @Override
    public void setBlob(int n2, InputStream inputStream) {
        if (this.filterChain == null) {
            this.do_setBlob(n2, inputStream);
        } else {
            this.filterChain.reset().PreparedStatement_setBlob(this, n2, inputStream);
        }
    }

    @Override
    public void setNClob(int n2, Reader reader) {
        if (this.filterChain == null) {
            this.do_setNClob(n2, reader);
        } else {
            this.filterChain.reset().PreparedStatement_setNClob(this, n2, reader);
        }
    }

    @Override
    public void setObject(int n2, Object object, SQLType sQLType, int n3) {
        if (this.filterChain == null) {
            this.do_setObject(n2, object, sQLType, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setObject(this, n2, object, sQLType, n3);
        }
    }

    @Override
    public void setObject(int n2, Object object, SQLType sQLType) {
        if (this.filterChain == null) {
            this.do_setObject(n2, object, sQLType);
        } else {
            this.filterChain.reset().PreparedStatement_setObject(this, n2, object, sQLType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate();
            }
            return this.filterChain.reset().PreparedStatement_executeLargeUpdate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCompile(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_preCompile(string);
            } else {
                this.filterChain.reset().PreparedStatement_preCompile(this, string);
            }
        }
    }

    public void do_preCompile(String string) {
        try {
            this.beforeExecute();
            this.prepareSql(string);
        }
        finally {
            this.afterExecute();
        }
    }

    public void executeDirect() {
        this.execute();
    }

    public void setINTERVALDT(int n2, DmdbIntervalDT dmdbIntervalDT) {
        if (this.filterChain == null) {
            this.do_setINTERVALDT(n2, dmdbIntervalDT);
        } else {
            this.filterChain.reset().PreparedStatement_setINTERVALDT(this, n2, dmdbIntervalDT);
        }
    }

    public void do_setINTERVALDT(int n2, DmdbIntervalDT dmdbIntervalDT) {
        if (dmdbIntervalDT == null) {
            this.setNullInner(n2, 21);
            return;
        }
        if (!this.prepareBindInParam(n2, 21)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(dmdbIntervalDT, this.fa[n3], this.connection);
    }

    public void setINTERVALYM(int n2, DmdbIntervalYM dmdbIntervalYM) {
        if (this.filterChain == null) {
            this.do_setINTERVALYM(n2, dmdbIntervalYM);
        } else {
            this.filterChain.reset().PreparedStatement_setINTERVALYM(this, n2, dmdbIntervalYM);
        }
    }

    public void do_setINTERVALYM(int n2, DmdbIntervalYM dmdbIntervalYM) {
        if (dmdbIntervalYM == null) {
            this.setNullInner(n2, 20);
            return;
        }
        if (!this.prepareBindInParam(n2, 20)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(dmdbIntervalYM, this.fa[n3], this.connection);
    }

    public void setTIMESTAMP(int n2, DmdbTimestamp dmdbTimestamp) {
        if (this.filterChain == null) {
            this.do_setTIMESTAMP(n2, dmdbTimestamp);
        } else {
            this.filterChain.reset().PreparedStatement_setTIMESTAMP(this, n2, dmdbTimestamp);
        }
    }

    public void do_setTIMESTAMP(int n2, DmdbTimestamp dmdbTimestamp) {
        if (dmdbTimestamp == null) {
            this.setNullInner(n2, 16);
            return;
        }
        if (!this.prepareBindInParam(n2, dmdbTimestamp.ky)) {
            return;
        }
        int n3 = n2 - 1;
        this.iw[n3] = b.a(dmdbTimestamp, this.fa[n3], this.connection);
    }

    public l[] getParameters() {
        return this.fa;
    }

    public int getBatchSize() {
        return this.ix > 0 ? this.ix : 0;
    }
}

