/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.conversions;

import org.xmlmiddleware.conversions.ByteArray;
import org.xmlmiddleware.conversions.ConvertObject;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class SQLLiterals {
    public static String buildLiteral(int n, Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        object = ConvertObject.convertObject(object, n, stringFormatter);
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                StringBuffer stringBuffer = new StringBuffer();
                byte[] byArray = ((ByteArray)object).getBytes();
                stringBuffer.append('X');
                stringBuffer.append('\'');
                int n2 = 0;
                while (n2 < byArray.length) {
                    stringBuffer.append(SQLLiterals.toChar((byArray[n2] & 0xF0) >> 4));
                    stringBuffer.append(SQLLiterals.toChar(byArray[n2] & 0xF));
                    ++n2;
                }
                stringBuffer.append('\'');
                return stringBuffer.toString();
            }
            case -1: 
            case 1: 
            case 12: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('\'');
                char[] cArray = ((String)object).toCharArray();
                int n3 = 0;
                while (n3 < cArray.length) {
                    stringBuffer.append(cArray[n3]);
                    if (cArray[n3] == '\'') {
                        stringBuffer.append('\'');
                    }
                    ++n3;
                }
                stringBuffer.append('\'');
                return stringBuffer.toString();
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return object.toString();
            }
            case -7: {
                return object.toString().toUpperCase();
            }
            case 91: 
            case 92: 
            case 93: {
                return object.toString();
            }
        }
        throw new XMLMiddlewareException("Conversion to specified JDBC type not supported.");
    }

    private static char toChar(int n) {
        return (char)(n < 10 ? n + 48 : n + 55);
    }
}

