/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.session.util;

import com.trs.infra.session.SessionAccessor;
import javax.servlet.http.HttpSession;

public class ThreadContext
implements SessionAccessor {
    public static final int INDEX_LIMIT = 1;
    public static final int INDEX_SESSION = 0;
    private static final ThreadLocal TLS = new ThreadLocal();

    public static final Object[] getTLS() {
        Object[] values = (Object[])TLS.get();
        if (values == null) {
            values = new Object[1];
            TLS.set(values);
        }
        return values;
    }

    public static final void clearTLS() {
        int length;
        Object[] values = (Object[])TLS.get();
        if (values != null && (length = values.length) > 0) {
            int i = 0;
            while (i < length) {
                values[i] = null;
                ++i;
            }
        }
    }

    public static final HttpSession getSession() {
        Object[] values = (Object[])TLS.get();
        if (values == null) {
            return null;
        }
        return (HttpSession)values[0];
    }

    public void setSession(HttpSession session) {
        ThreadContext.getTLS()[0] = session;
    }

    public void clearSession() {
        ThreadContext.getTLS()[0] = null;
    }
}

