/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.TdsParam;
import com.sybase.jdbc2.tds.Token;
import java.io.IOException;
import java.sql.SQLException;

public class DataFormat
extends Token {
    public static final int MAX_DATAFMT_LENGTH = 136;
    protected String _name;
    protected int _status;
    protected int _usertype;
    protected int _datatype;
    protected int _length;
    protected int _precision;
    protected int _scale;
    protected String _locale;
    protected int _localeLen;
    protected int _nameLen;
    protected String _tableName;
    protected String _className = null;
    protected int _blobType;
    protected int _classIdLen;

    protected DataFormat() {
    }

    public DataFormat(TdsInputStream tdsInputStream) throws IOException {
        this.newDataFormat(tdsInputStream, true);
    }

    public DataFormat(TdsInputStream tdsInputStream, boolean bl) throws IOException {
        this.newDataFormat(tdsInputStream, bl);
    }

    public DataFormat(TdsParam tdsParam, TdsOutputStream tdsOutputStream) throws IOException {
        this._nameLen = 0;
        this._name = tdsParam._name;
        if (this._name != null) {
            this._nameLen = this._name.length();
        }
        this._status = tdsParam._inValue == null ? 32 : 0;
        this._status |= tdsParam._regType != -999 ? 1 : 0;
        this._usertype = 0;
        this._locale = null;
        int[] nArray = new int[4];
        ((TdsDataOutputStream)tdsOutputStream).dataTypeInfo(tdsParam, nArray);
        this._datatype = nArray[0];
        switch (this._datatype) {
            case 9217: {
                this._datatype = 36;
                this._blobType = 1;
                this._className = tdsParam._inValue != null ? (tdsParam._outParamClassName != null ? tdsParam._outParamClassName : tdsParam._inValue.getClass().getName()) : (tdsParam._outParamClassName != null ? tdsParam._outParamClassName : "");
                this._classIdLen = this._className.length();
                break;
            }
            case 9220: {
                this._datatype = 36;
                this._blobType = 4;
                break;
            }
            case 9219: {
                this._datatype = 36;
                this._blobType = 3;
                break;
            }
            case 225: {
                if (!tdsParam._parameterHoldsUnicharData) break;
                this._usertype = 35;
                break;
            }
        }
        this._length = DataFormat.maxLength(tdsParam, this._datatype, nArray[1]);
        this._precision = nArray[2];
        this._scale = nArray[3];
    }

    public static String getDataTypeString(int n) {
        switch (n) {
            case 34: {
                return "IMAGE";
            }
            case 35: {
                return "TEXT";
            }
            case 37: {
                return "VARBINARY";
            }
            case 38: {
                return "INTN";
            }
            case 45: {
                return "BINARY";
            }
            case 47: {
                return "CHAR";
            }
            case 50: {
                return "BIT";
            }
            case 61: {
                return "DATETIM";
            }
            case 58: {
                return "SHORTDATE";
            }
            case 111: {
                return "DATETIMN";
            }
            case 106: {
                return "DECN";
            }
            case 59: {
                return "FLT4";
            }
            case 62: {
                return "FLT8";
            }
            case 109: {
                return "FLTN";
            }
            case 48: {
                return "INT1";
            }
            case 52: {
                return "INT2";
            }
            case 56: {
                return "INT4";
            }
            case 225: {
                return "LONGBINARY";
            }
            case 175: {
                return "LONGCHAR";
            }
            case 60: {
                return "MONEY";
            }
            case 122: {
                return "SHORTMONEY";
            }
            case 110: {
                return "MONEYN";
            }
            case 108: {
                return "NUMN";
            }
            case 103: {
                return "SENSITIVITY";
            }
            case 104: {
                return "BOUNDARY";
            }
            case 39: {
                return "VARCHAR";
            }
            case 36: {
                return "BLOB";
            }
            case 31: {
                return "VOID";
            }
            case 255: {
                return "UNKNOWN";
            }
        }
        return "<unrecognized>";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int length() {
        int n = 8 + (this._name == null ? 0 : this._name.length()) + DataFormat.lengthSize(this._datatype) + (this._locale == null ? 0 : this._locale.length());
        switch (this._datatype) {
            case 106: 
            case 108: {
                n += 2;
                return n;
            }
            case 36: 
            case 9217: {
                switch (this._blobType) {
                    case 1: 
                    case 3: 
                    case 4: {
                        n += 3 + this._classIdLen;
                        return n;
                    }
                    default: {
                        return n;
                    }
                }
            }
            case 34: 
            case 35: {
                n += 2 + (this._name == null ? 0 : this._name.length());
                return n;
            }
        }
        return n;
    }

    protected static int lengthSize(int n) {
        switch (n) {
            case 36: 
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 122: 
            case 9219: 
            case 9220: {
                return 0;
            }
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return 1;
            }
            case 34: 
            case 35: 
            case 175: 
            case 225: {
                return 4;
            }
        }
        return -1;
    }

    protected static int maxLength(TdsParam tdsParam, int n, int n2) {
        switch (n) {
            case 48: 
            case 50: {
                return 1;
            }
            case 52: {
                return 2;
            }
            case 56: 
            case 58: 
            case 59: 
            case 122: {
                return 4;
            }
            case 38: 
            case 60: 
            case 61: 
            case 62: {
                return n2 > 0 ? n2 : 4;
            }
            case 110: 
            case 111: {
                return n2 > 0 ? n2 : 8;
            }
            case 109: {
                if (n2 > 0) {
                    return n2;
                }
                if (tdsParam._sqlType == 7) {
                    return 4;
                }
                return 8;
            }
            case 37: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: {
                return 255;
            }
            case 106: 
            case 108: {
                return 33;
            }
            case 34: 
            case 35: 
            case 36: 
            case 175: 
            case 225: 
            case 9219: 
            case 9220: {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    protected void newDataFormat(TdsInputStream tdsInputStream, boolean bl) throws IOException {
        try {
            this.readMetaInfo(tdsInputStream);
            this.readStatus(tdsInputStream);
            this._usertype = tdsInputStream.readInt();
            this._datatype = tdsInputStream.readUnsignedByte();
            this._precision = 0;
            this._scale = 0;
            this._length = 0;
            block2 : switch (this._datatype) {
                case 48: 
                case 50: {
                    this._length = 1;
                    break;
                }
                case 52: {
                    this._length = 2;
                    break;
                }
                case 56: 
                case 58: 
                case 59: 
                case 122: {
                    this._length = 4;
                    break;
                }
                case 60: 
                case 61: 
                case 62: {
                    this._length = 8;
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 45: 
                case 47: 
                case 103: 
                case 104: 
                case 109: 
                case 110: 
                case 111: {
                    this._length = tdsInputStream.readUnsignedByte();
                    break;
                }
                case 106: 
                case 108: {
                    this._length = tdsInputStream.readUnsignedByte();
                    this._precision = tdsInputStream.readUnsignedByte();
                    this._scale = tdsInputStream.readUnsignedByte();
                    break;
                }
                case 175: 
                case 225: {
                    this._length = tdsInputStream.readInt();
                    break;
                }
                case 34: 
                case 35: {
                    this._length = tdsInputStream.readInt();
                    this._tableName = tdsInputStream.readString(tdsInputStream.readUnsignedShort());
                    break;
                }
                case 36: {
                    this._blobType = tdsInputStream.readUnsignedByte();
                    this._classIdLen = tdsInputStream.readShort();
                    switch (this._blobType) {
                        case 1: {
                            this._className = tdsInputStream.readString(this._classIdLen);
                            break block2;
                        }
                        case 3: 
                        case 4: {
                            tdsInputStream.skip(this._classIdLen);
                            break block2;
                        }
                    }
                    tdsInputStream.skip(this._classIdLen);
                    break;
                }
            }
            if (this._className == null) {
                try {
                    this._className = TdsJdbcInputStream.getObjectClassName(this._datatype, this._blobType, this._length);
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.getMessage());
                }
            }
            if (bl) {
                int n = tdsInputStream.readUnsignedByte();
                this._locale = n > 0 ? tdsInputStream.readString(n) : "";
            }
            switch (this._datatype) {
                case 60: 
                case 110: 
                case 122: {
                    this._scale = 4;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            Token.readSQE(iOException);
        }
    }

    protected void readMetaInfo(TdsInputStream tdsInputStream) throws IOException {
        try {
            this._nameLen = tdsInputStream.readUnsignedByte();
            this._name = this._nameLen > 0 ? tdsInputStream.readString(this._nameLen) : "";
        }
        catch (IOException iOException) {
            Token.readSQE(iOException);
        }
    }

    protected void readStatus(TdsInputStream tdsInputStream) throws IOException {
        this._status = tdsInputStream.readUnsignedByte();
    }

    /*
     * Unable to fully structure code
     */
    public void send(TdsOutputStream var1_1) throws IOException {
        this.sendMetaInfo(var1_1);
        this.sendStatus(var1_1);
        var1_1.writeInt(this._usertype);
        switch (this._datatype) {
            case 9219: {
                this._blobType = 3;
                var1_1.writeByte(36);
                break;
            }
            case 9220: {
                this._blobType = 4;
                var1_1.writeByte(36);
                break;
            }
            default: {
                var1_1.writeByte(this._datatype);
            }
        }
        switch (this._datatype) {
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 103: 
            case 104: 
            case 109: 
            case 110: 
            case 111: {
                var1_1.writeByte(this._length);
                ** break;
            }
            case 106: 
            case 108: {
                var1_1.writeByte(this._length);
                var1_1.writeByte(this._precision);
                var1_1.writeByte(this._scale);
                ** break;
            }
            case 175: 
            case 225: {
                var1_1.writeInt(this._length);
                ** break;
            }
            case 36: 
            case 9219: 
            case 9220: {
                var1_1.writeByte(this._blobType);
                switch (this._blobType) {
                    case 1: {
                        var2_2 = var1_1.stringToByte(this._className);
                        if (var2_2 == null) {
                            var1_1.writeShort(0);
                            ** break;
                        }
                        var1_1.writeShort(var2_2.length);
                        var1_1.write(var2_2);
                        ** break;
                    }
                    case 3: 
                    case 4: {
                        var1_1.writeShort(0);
                        ** break;
                    }
                    default: {
                        ** if (this._locale != null) goto lbl-1000
                    }
                }
            }
            case 34: 
            case 35: {
                var1_1.writeInt(this._length);
                var2_2 = var1_1.stringToByte(this._tableName);
                var1_1.writeShort(var2_2.length);
                var1_1.write(var2_2);
                ** break;
            }
        }
lbl49:
        // 8 sources

        if (this._locale == null) lbl-1000:
        // 2 sources

        {
            var1_1.writeByte(0);
        } else lbl-1000:
        // 2 sources

        {
            var3_3 = (var2_2 = var1_1.stringToByte(this._locale)).length > 255 ? 255 : var2_2.length;
            var1_1.writeByte(var3_3);
            var1_1.write(var2_2, 0, var3_3);
        }
    }

    protected void sendMetaInfo(TdsOutputStream tdsOutputStream) throws IOException {
        byte[] byArray = tdsOutputStream.stringToByte(this._name);
        if (byArray == null) {
            tdsOutputStream.writeByte(0);
        } else {
            tdsOutputStream.writeByte(byArray.length);
            tdsOutputStream.write(byArray);
        }
    }

    protected void sendStatus(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(this._status);
    }
}

