/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.xmlserver.server;

import com.trs.infra.util.XmlCharCheckedInputStream;
import com.trs.webframework.context.ServiceContext;
import com.trs.webframework.xmlserver.parser.StreamBuddy;
import com.trs.webframework.xmlserver.server.IRequestProcessor;
import com.trs.webframework.xmlserver.server.InvocationObserver;
import com.trs.webframework.xmlserver.server.XMLDataProcessingHandler;
import com.trs.webframework.xmlserver.server.XMLParsingPausedException;
import java.io.InputStream;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RequestXMLDataProcessor
implements IRequestProcessor {
    private static Logger logger = Logger.getLogger(RequestXMLDataProcessor.class);
    private InputStream m_oDataInputStream;
    private ServiceContext m_oServiceContext = null;

    public RequestXMLDataProcessor(ServiceContext serviceContext, InputStream inputStream) {
        this.m_oServiceContext = serviceContext;
        if (inputStream != null) {
            this.m_oDataInputStream = new XmlCharCheckedInputStream(inputStream);
        }
    }

    public RequestXMLDataProcessor(InputStream inputStream) {
        this.m_oServiceContext = new ServiceContext();
        if (inputStream != null) {
            this.m_oDataInputStream = new XmlCharCheckedInputStream(inputStream);
        }
    }

    public Object excute() throws Throwable {
        XMLDataProcessingHandler xMLDataProcessingHandler = new XMLDataProcessingHandler(this.m_oServiceContext);
        xMLDataProcessingHandler.attachObserver(new InvocationObserver(this.m_oServiceContext));
        InputSource inputSource = StreamBuddy.getInputSource(this.m_oDataInputStream, "UTF-8");
        this.doDataProcessing(inputSource, xMLDataProcessingHandler, false);
        return xMLDataProcessingHandler.getResult();
    }

    protected void doDataProcessing(InputSource inputSource, DefaultHandler defaultHandler, boolean bl) throws Throwable {
        Exception exception;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            sAXParserFactory.newSAXParser().parse(inputSource, defaultHandler);
        }
        catch (SAXException sAXException) {
            exception = sAXException.getException();
            if (exception == null) {
                throw sAXException;
            }
            throw exception;
        }
        finally {
            if (exception instanceof XMLParsingPausedException) {
                if (logger.isDebugEnabled()) {
                    logger.info((Object)"Completed processing before time!");
                }
                return;
            }
        }
    }
}

