/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.DefaultSaveLogger;
import com.trs.webframework.ServiceExcuteLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class DefaultDeleteLogger
extends AbstractLogger
implements ServiceExcuteLogger {
    private static final Logger LOG = Logger.getLogger(DefaultSaveLogger.class);
    private static final int COUNT_PER_SAVE = 5;

    public int startLog(MethodConfig methodConfig, MethodContext methodContext) {
        try {
            String string = methodConfig.getLogObjClassName();
            if (CMyString.isEmpty(string)) {
                LOG.warn((Object)"no objklass provide ,execute log fail!");
                return 0;
            }
            Class<?> clazz = Class.forName(string);
            if (!CMSOBJS_KLASS.isAssignableFrom(clazz) && !CMSOBJS_KLASS.isAssignableFrom(clazz = Class.forName(string + "s"))) {
                LOG.warn((Object)"only log cmsobjs delete execute default");
                return 0;
            }
            String string2 = methodContext.getValue("ObjectIds");
            if (CMyString.isEmpty(string2)) {
                string2 = methodContext.getValue("ObjectId");
            }
            if (CMyString.isEmpty(string2)) {
                LOG.warn((Object)"Not default delete execute.");
                return 0;
            }
            User user = ContextHelper.getLoginUser();
            CMSBaseObjs cMSBaseObjs = CMSBaseObjs.findWCMObjsByIds(user, clazz, string2);
            if (cMSBaseObjs.isEmpty()) {
                return 0;
            }
            StringBuffer stringBuffer = new StringBuffer(128);
            int n = cMSBaseObjs.size();
            BaseObj baseObj = null;
            for (int i = 0; baseObj == null && i < n; ++i) {
                baseObj = cMSBaseObjs.getAt(i);
            }
            if (baseObj == null) {
                return 0;
            }
            if (n > 1) {
                stringBuffer.append("\u6279\u91cf");
            }
            if (methodContext.getValue("Drop", false)) {
                stringBuffer.append(I18NMessage.get(DefaultDeleteLogger.class, "DefaultDeleteLogger.label2", "\u5f7b\u5e95"));
            }
            stringBuffer.append(I18NMessage.get(DefaultDeleteLogger.class, "DefaultDeleteLogger.label3", "\u5220\u9664"));
            if (n > 1) {
                stringBuffer.append(WCMTypes.getObjName(baseObj.getWCMType(), true));
                stringBuffer.append("Ids=").append(string2);
            } else {
                stringBuffer.append(baseObj);
            }
            return this.log(methodConfig, stringBuffer.toString(), baseObj);
        }
        catch (Exception exception) {
            LOG.error((Object)"execute log fail", (Throwable)exception);
            return 0;
        }
    }
}

