/*
 * Decompiled with CFR 0.152.
 */
package com.trs.update.wcm;

import com.trs.cms.ContextHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyUnzip;
import com.trs.update.wcm.ConflictFilesOfWCMMaker;
import com.trs.update.wcm.UpdateConfigManager;
import com.trs.update.wcm.WCMUpdateProcessInfo;
import com.trs.update.wcm.WCMUpdaterConstants;
import com.trs.util.CMyString;
import com.trs.util.ExecSQLFileByAnt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WCMFixUpdater {
    private static Logger logger = Logger.getLogger(WCMFixUpdater.class);
    private String m_sFixName = null;
    private String m_sFixIdFile = null;
    private String m_sWCMPath = null;
    private String m_sFixParentPath = null;
    private String m_sFixPath = null;
    private String m_sTimestamp = null;
    private String m_sAbsolutBackupPath = null;
    private String m_sManualWorkInfo = null;
    private String m_sAntDBBuildFilePath = null;
    private static String m_sAntPath = null;
    private StringBuffer m_sbErrorInfo = new StringBuffer();

    public WCMFixUpdater(String _sFixName, String _sTimestamp) throws Exception {
        this.m_sFixName = _sFixName;
        this.m_sTimestamp = _sTimestamp;
        this.m_sFixIdFile = String.valueOf(WCMUpdaterConstants.PATH_FIX_ID) + this.m_sFixName + "." + WCMUpdaterConstants.EXT_FIX_ID;
        this.m_sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        if (!CMyFile.fileExists(this.m_sWCMPath)) {
            throw new Exception("\u8bf7\u4fee\u6539WEB-INF/classes/TRSWCMApp.ini\u6587\u4ef6\uff0c\u786e\u4fddWCM_Path\u8bbe\u7f6e\u6b63\u786e\uff01\u76ee\u524d\u914d\u7f6e\u4e3a\u3010" + this.m_sWCMPath + "\u3011");
        }
        this.m_sWCMPath = WCMUpdaterConstants.setStrEndWithPathFlag(this.m_sWCMPath);
        this.m_sFixParentPath = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_FIXS_EXTRACT;
        this.m_sFixPath = String.valueOf(this.m_sFixParentPath) + this.m_sFixName + File.separatorChar;
        this.m_sAbsolutBackupPath = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_BACKUP + _sTimestamp;
        this.m_sAntDBBuildFilePath = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.ANT_BUILD_DB_FILE;
        m_sAntPath = UpdateConfigManager.getCmdAnt();
    }

    public String getManualWorkInfo() {
        return this.m_sManualWorkInfo;
    }

    public String getErrInfo() {
        if (this.m_sbErrorInfo == null || this.m_sbErrorInfo.length() == 0) {
            return null;
        }
        return this.m_sbErrorInfo.toString();
    }

    public String update() throws Exception {
        if (CMyFile.fileExists(String.valueOf(this.m_sWCMPath) + this.m_sFixIdFile)) {
            return "\u7cfb\u7edf\u5df2\u7ecf\u505a\u8fc7\u66f4\u65b0";
        }
        try {
            this.updateDB();
        }
        catch (Exception e) {
            logger.error((Object)(String.valueOf(this.m_sFixName) + " \u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25\uff01"), (Throwable)e);
            String sSQLPath = String.valueOf(WCMUpdaterConstants.PATH_FIXS_EXTRACT) + File.separator + this.m_sFixName + File.separator + "db" + File.separatorChar;
            this.m_sbErrorInfo.append("\u6570\u636e\u5e93\u66f4\u65b0\u6267\u884c\u5931\u8d25\uff0c\u6709\u53ef\u80fd\u662f\u591a\u6b21\u6267\u884c\u5bfc\u81f4;\n\u4e5f\u53ef\u80fd\u662fant\u73af\u5883\u6ca1\u6709\u914d\u7f6e\u597d\n\u8bf7\u624b\u5de5\u6267\u884c\u5e94\u7528\u76ee\u5f55\u4e2d\u7684SQL\u6587\u4ef6\uff01\n\u76ee\u5f55[" + sSQLPath + "]\n" + "\u5982\u679c\u8fd8\u6709\u95ee\u9898\uff0c\u8bf7\u5c06WCM\u65e5\u5fd7\u63d0\u4f9b\u7ed9\u7814\u53d1\u4eba\u5458\u89e3\u51b3\uff01\n" + "\u6267\u884c\u8fc7\u7a0b\u4e2d\u7684\u9519\u8bef\u4fe1\u606f\u3010" + e.getMessage() + "\u3011\n");
        }
        this.updateClasses();
        this.updateApp();
        this.m_sManualWorkInfo = this.readManualWork();
        String sFinishContent = String.valueOf(ContextHelper.getLoginUser().getName()) + " \u4e8e\u3010" + CMyDateTime.now() + "\u3011 \u66f4\u65b0\u4e86Fix\u3010" + this.m_sFixName + "\u3011\uff01";
        CMyFile.writeFile(String.valueOf(this.m_sWCMPath) + this.m_sFixIdFile, sFinishContent);
        WCMUpdateProcessInfo.setCurrInfo(sFinishContent);
        return String.valueOf(this.m_sFixName) + " \u66f4\u65b0\u5b8c\u6210\uff01";
    }

    private void updateApp() throws Exception {
        WCMUpdateProcessInfo.setCurrInfo(String.valueOf(this.m_sFixName) + ".\u66f4\u65b0\u5e94\u7528.......");
        String sUpdateAppPath = String.valueOf(this.m_sFixPath) + WCMUpdaterConstants.FLAG_PATH_WEBAPP + File.separatorChar;
        if (!CMyFile.fileExists(sUpdateAppPath)) {
            return;
        }
        CMyFile.copyFileDir(sUpdateAppPath, this.m_sWCMPath, false);
        ConflictFilesOfWCMMaker oConflictFilesOfWCMMaker = new ConflictFilesOfWCMMaker();
        oConflictFilesOfWCMMaker.updateMD5Properties(this.m_sTimestamp, sUpdateAppPath);
    }

    public void backUpFix() throws Exception {
        String sUpdateClassesPath;
        String sUpdateAppPath = String.valueOf(this.m_sFixPath) + WCMUpdaterConstants.FLAG_PATH_WEBAPP + File.separatorChar;
        if (CMyFile.fileExists(sUpdateAppPath)) {
            this.backupFile(sUpdateAppPath, this.m_sWCMPath, this.m_sAbsolutBackupPath);
        }
        if (CMyFile.fileExists(sUpdateClassesPath = String.valueOf(this.m_sFixPath) + WCMUpdaterConstants.FLAG_PATH_TRSWCMJAR + File.separatorChar)) {
            String sDstUpdatePath = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_CLASS_UPDATE;
            String sBackupPath = String.valueOf(this.m_sAbsolutBackupPath) + WCMUpdaterConstants.PATH_CLASS_UPDATE;
            this.backupFile(sUpdateClassesPath, sDstUpdatePath, sBackupPath);
        }
    }

    private void updateClasses() throws Exception {
        WCMUpdateProcessInfo.setCurrInfo(String.valueOf(this.m_sFixName) + ".\u66f4\u65b0Classes.......");
        String sUpdateClassesPath = String.valueOf(this.m_sFixPath) + WCMUpdaterConstants.FLAG_PATH_TRSWCMJAR + File.separatorChar;
        if (!CMyFile.fileExists(sUpdateClassesPath)) {
            return;
        }
        String sDstUpdatePath = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_CLASS_UPDATE;
        CMyFile.copyFileDir(sUpdateClassesPath, sDstUpdatePath, false);
        ConflictFilesOfWCMMaker oConflictFilesOfWCMMaker = new ConflictFilesOfWCMMaker();
        oConflictFilesOfWCMMaker.updateMD5Properties(this.m_sTimestamp, sUpdateClassesPath);
    }

    private void updateDB() throws Exception {
        String sAlreadyUpdateSQL;
        String sUpdateDBSQLFilePath = String.valueOf(this.m_sFixPath) + WCMUpdaterConstants.FLAG_PATH_DB + File.separatorChar;
        if (!CMyFile.fileExists(sUpdateDBSQLFilePath)) {
            return;
        }
        DBManager dbMgr = DBManager.getDBManager();
        if (dbMgr.sqlExecuteIntQuery(sAlreadyUpdateSQL = "select 1 from WCMDBUpdate where UpdInfo='" + this.m_sFixName + "'") == 1) {
            return;
        }
        WCMUpdateProcessInfo.setCurrInfo(String.valueOf(this.m_sFixName) + ".\u66f4\u65b0\u6570\u636e\u5e93.......");
        ExecSQLFileByAnt dbUpdater = new ExecSQLFileByAnt();
        String sUpdateDBLog = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_LOGS + this.m_sTimestamp + "_db.log";
        dbUpdater.execSQLFile(sUpdateDBSQLFilePath, sUpdateDBLog, this.m_sAntDBBuildFilePath, m_sAntPath, this.m_sFixName);
        String sDBUpdateLog = "insert into WCMDBUpdate(UPDVERSION, UPDINFO, UPDUSER, UPDTIME) values(?, ?, ?, ?)";
        Object[] pParameters = new Object[]{Integer.valueOf("14304"), this.m_sFixName, ContextHelper.getLoginUser().getName(), CMyDateTime.now()};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{"insert into WCMDBUpdate(UPDVERSION, UPDINFO, UPDUSER, UPDTIME) values(?, ?, ?, ?)"}, pParameters);
    }

    public void validFix() throws Exception {
        File oFixPath;
        File[] pChildFiles;
        WCMUpdateProcessInfo.setCurrInfo(String.valueOf(this.m_sFixName) + ".\u9a8c\u8bc1\u3010" + this.m_sFixPath + "\u3011\u5408\u6cd5\u6027..........");
        StringBuffer sbErrorInfo = new StringBuffer();
        if (!CMyFile.fileExists(String.valueOf(this.m_sFixPath) + WCMUpdaterConstants.FILE_README)) {
            sbErrorInfo.append("\u6574\u7406\u7684FIX\u6709\u95ee\u9898\uff0c\u6839\u76ee\u5f55\u4e0b\u6ca1\u6709\u3010" + WCMUpdaterConstants.FILE_README + "\u3011\u6587\u4ef6]\n");
        }
        if ((pChildFiles = (oFixPath = new File(this.m_sFixPath)).listFiles()) == null) {
            sbErrorInfo.append("\u6574\u7406\u7684FIX\u6709\u95ee\u9898\uff0c \u8bf7\u786e\u8ba4\u5305\u540d\u79f0\u548c\u6839\u76ee\u5f55\u662f\u5426\u7b26\u5408\u89c4\u8303\uff0c\u53ef\u80fd\u662f\u76ee\u5f55\u540d\u6ca1\u6709\u5927\u5199 \n");
            throw new WCMException(sbErrorInfo.toString());
        }
        int i = 0;
        while (i < pChildFiles.length) {
            File oChildFile = pChildFiles[i];
            if (oChildFile.isDirectory()) {
                String sFixChildPath = WCMUpdaterConstants.setStrEndWithPathFlag(oChildFile.getAbsolutePath());
                String sPathName = oChildFile.getName();
                if (!sPathName.equals(WCMUpdaterConstants.FLAG_PATH_WEBAPP)) {
                    if (sPathName.equals(WCMUpdaterConstants.FLAG_PATH_TRSWCMJAR)) {
                        if (!new File(String.valueOf(sFixChildPath) + "com" + File.separatorChar).exists()) {
                            sbErrorInfo.append("\u6574\u7406\u7684FIX\u6709\u95ee\u9898\uff0ctrswcmv6.jar\u6ca1\u6709com\u76ee\u5f55\uff01[" + sFixChildPath + "com]\n");
                        }
                    } else if (sPathName.equals(WCMUpdaterConstants.FLAG_PATH_DB)) {
                        String[] pDBFiles = new String[]{"db2.sql", "mysql.sql", "sqlserver.sql", "sybase.sql", "oracle.sql"};
                        int nDBFileIndex = 0;
                        while (nDBFileIndex < pDBFiles.length) {
                            String sDBFile = pDBFiles[nDBFileIndex];
                            if (!new File(String.valueOf(sFixChildPath) + sDBFile).exists()) {
                                sbErrorInfo.append("\u6574\u7406\u7684FIX\u6709\u95ee\u9898\uff0cdb\u76ee\u5f55\u4e2d\u6ca1\u6709\u6587\u4ef6[" + sDBFile + "]\uff01[" + sFixChildPath + sDBFile + "]\n");
                            }
                            ++nDBFileIndex;
                        }
                    } else {
                        sbErrorInfo.append("\u6574\u7406\u7684FIX\u6709\u95ee\u9898\uff0c\u76ee\u5f55\u540d[" + sPathName + "]\u4e0d\u7b26\u5408\u89c4\u8303\uff01\n");
                    }
                }
            }
            ++i;
        }
        if (sbErrorInfo.length() > 0) {
            throw new WCMException(sbErrorInfo.toString());
        }
    }

    public void createtFixFiles() throws Exception {
        File file = new File(this.m_sFixPath);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        String sFixZIPFile = String.valueOf(this.m_sWCMPath) + WCMUpdaterConstants.PATH_FIXS_DOWNLOAD + this.m_sFixName + ".zip";
        file = new File(sFixZIPFile);
        if (!file.exists()) {
            if (CMyString.isEmpty((String)WCMUpdaterConstants.URL_GET_FIX)) {
                throw new WCMException("\u5f53\u524d\u6a21\u5f0f\u4e3a\u79bb\u7ebf\u6a21\u5f0f\uff0c\u8bf7\u624b\u5de5\u4e0b\u8f7d\u5f53\u524d\u66f4\u65b0\u5305[" + this.m_sFixName + ".zip]!");
            }
            String sURL = String.valueOf(WCMUpdaterConstants.URL_GET_FIX) + this.m_sFixName + ".zip";
            WCMUpdateProcessInfo.setCurrInfo(String.valueOf(this.m_sFixName) + ".Download " + sURL + "..........");
            boolean bDownload = CMy3WLib.getFile(sURL, sFixZIPFile);
            WCMUpdateProcessInfo.setCurrInfo(String.valueOf(this.m_sFixName) + ".Download " + sURL + " end![" + bDownload + "]");
            if (!bDownload) {
                throw new WCMException("\u4e0b\u8f7dFIX\u6587\u4ef6\u5931\u8d25[" + sURL + "]\uff0c\u53ef\u80fd\u7f51\u7edc\u539f\u56e0\uff0c\u9700\u8981\u624b\u5de5\u4e0b\u8f7d!");
            }
        }
        WCMUpdateProcessInfo.setCurrInfo(String.valueOf(this.m_sFixName) + ".Extract " + sFixZIPFile + "..........");
        CMyUnzip.unzip(sFixZIPFile, this.m_sFixParentPath, true);
        WCMUpdateProcessInfo.setCurrInfo(String.valueOf(this.m_sFixName) + ".Extract " + sFixZIPFile + " end!");
    }

    private void backupFile(String _sSrcFilePath, String _sUpdateDstFilePath, String _sBackupFilePath) throws Exception {
        _sSrcFilePath = WCMUpdaterConstants.setStrEndWithPathFlag(_sSrcFilePath);
        _sUpdateDstFilePath = WCMUpdaterConstants.setStrEndWithPathFlag(_sUpdateDstFilePath);
        _sBackupFilePath = WCMUpdaterConstants.setStrEndWithPathFlag(_sBackupFilePath);
        File[] pNewFiles = new File(_sSrcFilePath).listFiles();
        int nNewFileIndex = 0;
        while (nNewFileIndex < pNewFiles.length) {
            File oFile = pNewFiles[nNewFileIndex];
            String sCurrFileOrPathName = oFile.getName();
            String sUpdateDstSubFileOrPath = String.valueOf(_sUpdateDstFilePath) + sCurrFileOrPathName;
            boolean bDstExists = CMyFile.fileExists(sUpdateDstSubFileOrPath);
            if (bDstExists) {
                if (oFile.isDirectory()) {
                    this.backupFile(oFile.getAbsolutePath(), sUpdateDstSubFileOrPath, String.valueOf(_sBackupFilePath) + sCurrFileOrPathName);
                } else if (!CMyFile.fileExists(String.valueOf(_sBackupFilePath) + sCurrFileOrPathName)) {
                    CMyFile.copyFile(sUpdateDstSubFileOrPath, String.valueOf(_sBackupFilePath) + sCurrFileOrPathName, true);
                }
            }
            ++nNewFileIndex;
        }
    }

    private String readManualWork() throws Exception {
        StringBuffer sbResult = new StringBuffer();
        String sResult = "";
        String sReadMeFile = String.valueOf(this.m_sFixPath) + WCMUpdaterConstants.FILE_README;
        InputStreamReader fileReader = null;
        FileInputStream fis = null;
        BufferedReader buffReader = null;
        try {
            try {
                String sLine;
                fis = new FileInputStream(sReadMeFile);
                buffReader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                boolean bFindStartPos = false;
                while ((sLine = buffReader.readLine()) != null) {
                    if (sLine == null || (sLine = sLine.trim()).length() == 0) continue;
                    if (sLine.startsWith("#############\u66f4\u65b0\u540e\u624b\u5de5\u64cd\u4f5c\u8bf4\u660e#")) {
                        if (bFindStartPos) break;
                        bFindStartPos = true;
                        continue;
                    }
                    if (!bFindStartPos) continue;
                    sbResult.append(sLine);
                    sbResult.append("\n");
                }
                sResult = this.autoAddLink(sbResult.toString());
            }
            catch (FileNotFoundException ex) {
                throw new CMyException(55, "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230", ex);
            }
            catch (IOException ex) {
                throw new CMyException(53, "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef", ex);
            }
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        if (sResult.length() > 0) {
            return sResult;
        }
        return null;
    }

    private String autoAddLink(String _sContent) {
        if (_sContent == null || _sContent.trim().length() == 0) {
            return _sContent;
        }
        Pattern oPattern = Pattern.compile("##(http|ftp|https)://[a-zA-Z0-9\\.\\-]+(:\\d+)?(/[a-zA-Z0-9\\.\\-~!@#$%^&*+?:_/=<>]*)?##");
        Matcher oMatcher = oPattern.matcher(_sContent);
        ArrayList<String> result = new ArrayList<String>();
        while (oMatcher.find()) {
            result.add(oMatcher.group());
        }
        if (result.size() <= 0) {
            return _sContent;
        }
        int i = 0;
        while (i < result.size()) {
            String sCurrLink = result.get(i).toString();
            sCurrLink = sCurrLink.substring(2, sCurrLink.length() - 2);
            String sNewStr = "<a href='" + sCurrLink + "' target='_blank'>" + sCurrLink + "</a>";
            _sContent = CMyString.replaceStr((String)_sContent, (String)((String)result.get(i)), (String)sNewStr);
            ++i;
        }
        return _sContent;
    }
}

