/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.tools.MediaFilesMD5Digest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Set;

public class ModifiedFilesCollector {
    private static final int BUFFER_LENGTH = 4096;
    private final byte[] BUFFER = new byte[4096];
    private String m_sAppDir;
    private int m_nAppDirLength;
    private String m_sDigestStoreFile;
    private String m_sCollectDir;
    private File m_fCollectDir;
    private boolean m_bCollectAddedFiles;

    public ModifiedFilesCollector(String string, String string2) {
        this.m_sAppDir = string;
        this.m_sDigestStoreFile = string2;
    }

    public void setCollectDir(String string) {
        this.m_sCollectDir = string;
    }

    public void setCollectAddedFiles(boolean bl) {
        this.m_bCollectAddedFiles = bl;
    }

    public void collect() throws Exception {
        if (this.isEmpty(this.m_sDigestStoreFile)) {
            this.m_sDigestStoreFile = new File(this.m_sAppDir, "media_digest.txt").getAbsolutePath();
        }
        MediaFilesMD5Digest mediaFilesMD5Digest = new MediaFilesMD5Digest(this.m_sAppDir, this.m_sDigestStoreFile);
        System.out.println("collecting changed files.");
        Set set = mediaFilesMD5Digest.getDifference();
        if (set.isEmpty()) {
            System.out.println("No files changed.");
            return;
        }
        if (this.isEmpty(this.m_sCollectDir)) {
            this.m_sCollectDir = System.getProperty("java.io.tmpdir");
        }
        this.m_fCollectDir = new File(this.m_sCollectDir, "wcmmodifies_" + System.currentTimeMillis());
        if (!this.m_fCollectDir.exists()) {
            this.m_fCollectDir.mkdirs();
        }
        this.m_nAppDirLength = new File(this.m_sAppDir).getAbsolutePath().length();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MediaFilesMD5Digest.DifferenceRecord differenceRecord = (MediaFilesMD5Digest.DifferenceRecord)iterator.next();
            if (!differenceRecord.isModified() && !this.m_bCollectAddedFiles) continue;
            this.copyFile(differenceRecord.getName());
            ++n;
        }
        if (n == 0) {
            System.out.println("Total [" + set.size() + "] files are added.");
            return;
        }
        System.out.println("Total [" + n + "] files.");
        System.out.println("Done. Files collect in :" + this.m_fCollectDir.getAbsolutePath());
    }

    protected boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String string) throws Exception {
        Exception exception3;
        FileInputStream fileInputStream;
        block13: {
            fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                File file = new File(this.m_fCollectDir, string.substring(this.m_nAppDirLength));
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                fileOutputStream = new FileOutputStream(file);
                int n = -1;
                while ((n = fileInputStream.read(this.BUFFER, 0, 4096)) != -1) {
                    fileOutputStream.write(this.BUFFER, 0, n);
                }
                fileOutputStream.flush();
                Object var7_6 = null;
                if (fileOutputStream == null) break block13;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var7_7 = null;
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception3) {}
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: ");
            System.out.println("\t1.App files dir");
            System.out.println("\t2.Digest file(optional, default: media_digest.txt)");
            System.out.println("\t3.Collect dir(optional, default: system tempdir)");
            System.out.println("\t4.Wether collect addedfiles or not(optional, defualt: no)");
            return;
        }
        try {
            String string = stringArray[0];
            String string2 = null;
            if (stringArray.length > 1) {
                string2 = stringArray[1];
            }
            ModifiedFilesCollector modifiedFilesCollector = new ModifiedFilesCollector(string, string2);
            if (stringArray.length > 2) {
                modifiedFilesCollector.setCollectDir(stringArray[2]);
            }
            if (stringArray.length > 3) {
                modifiedFilesCollector.setCollectAddedFiles("true".equals(stringArray[3]));
            }
            modifiedFilesCollector.collect();
        }
        catch (Exception exception) {
            System.out.println("collect modified files failed.");
            exception.printStackTrace(System.out);
        }
    }
}

