/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.DebugTimer;
import com.trs.tools.BlockCommentLocaleChecker;
import com.trs.tools.FCKLANGLocaleChecker;
import com.trs.tools.HTMLCommentLocaleChecker;
import com.trs.tools.ILocaleChecker;
import com.trs.tools.JSPCommentLocaleChecker;
import com.trs.tools.LocaleInfo;
import com.trs.tools.LocaleServerLocaleChecker;
import com.trs.tools.ScriptLineCommentLocaleChecker;
import com.trs.tools.StyleLocaleChecker;
import com.trs.tools.WCMAntParamLocaleChecker;
import com.trs.tools.wcmLANGLocaleChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LocaleAnalyzer {
    private static Logger logger = Logger.getLogger(LocaleAnalyzer.class);
    private static Pattern chinesePattern = Pattern.compile("([\u4e00-\u9fbb])");
    private String m_sRootPath;
    private String m_sOutputFile;
    private ILocaleChecker[] m_oLocaleCheckers;
    private StringBuffer m_sbResult;
    private String[] m_sFileType = new String[]{".jsp,", ".html", ".htm", ".js"};

    public LocaleAnalyzer(String string, String string2, String string3) {
        this.m_sRootPath = new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        this.m_sOutputFile = string2.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (!CMyString.isEmpty(string3)) {
            this.m_sFileType = string3.split(",");
        }
    }

    public static void main(String[] stringArray) throws CMyException {
        if (stringArray.length < 2) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u4e24\u4e2a\u53c2\u6570\n");
            stringBuffer.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u76ee\u5f55\uff1a\n");
            stringBuffer.append("\t\t\u5982\uff1a\n");
            stringBuffer.append("E:/MyWorkspace/TRS.WCM.V6.1.Std/SourceCode/WebApp/app");
            stringBuffer.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u751f\u6210\u7684\u8d44\u6e90\u6587\u4ef6\u5168\u8def\u5f84\uff1a\n");
            stringBuffer.append("\t\t\u5982\uff1a\n");
            stringBuffer.append("E:/localeAnalyzer.txt");
            logger.error((Object)stringBuffer);
            return;
        }
        LocaleAnalyzer localeAnalyzer = new LocaleAnalyzer(stringArray[0], stringArray[1], stringArray.length > 2 ? stringArray[2] : null);
        localeAnalyzer.analyze();
    }

    public void analyze() throws CMyException {
        DebugTimer debugTimer = new DebugTimer();
        debugTimer.start();
        this.m_sbResult = new StringBuffer(500);
        File file = new File(this.m_sRootPath);
        this.analyzeDir(file);
        CMyFile.writeFile(this.m_sOutputFile, this.m_sbResult.toString());
        debugTimer.stop();
        logger.info((Object)("\u6b64\u6b21\u5206\u6790\u5171\u7528\u65f6[" + debugTimer.getTime() + "]ms"));
    }

    private void analyzeDir(File file) {
        if (!this.isAccept(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.analyzeDir(fileArray[i]);
            }
            return;
        }
        this.analyzeFile(file);
    }

    private boolean isAccept(File file) {
        String string = file.getAbsolutePath().toLowerCase();
        if (file.isDirectory()) {
            if (string.endsWith(".svn") || string.endsWith("cvs")) {
                return false;
            }
            if (string.indexOf("locale") >= 0) {
                return false;
            }
            if (string.indexOf("lang") >= 0) {
                return false;
            }
            if (string.indexOf("easyexample") >= 0) {
                return false;
            }
            if (string.indexOf("metaresource") >= 0) {
                return false;
            }
            if (string.indexOf("video") >= 0) {
                return false;
            }
            if (string.indexOf("39") >= 0) {
                return false;
            }
            if (string.endsWith("special") || string.endsWith("stat")) {
                return true;
            }
            return true;
        }
        if (string.endsWith("cn.js") || string.endsWith("en.js")) {
            return false;
        }
        for (int i = 0; i < this.m_sFileType.length; ++i) {
            if (!string.endsWith(this.m_sFileType[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeFile(File file) {
        String string = file.getAbsolutePath();
        String string2 = CharsetDetector.detect(string);
        BufferedReader bufferedReader = null;
        String string3 = CMyFile.readFile(string, string2);
        int n = 0;
        int n2 = 0;
        int n3 = "\n".length();
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string2));
        String string4 = bufferedReader.readLine();
        while (string4 != null) {
            ++n2;
            Matcher matcher = chinesePattern.matcher(string4);
            if (matcher.find()) {
                int n4 = matcher.start();
                LocaleInfo localeInfo = new LocaleInfo();
                localeInfo.setContent(string3);
                localeInfo.setFileName(string);
                localeInfo.setIndexInContent(n + n4);
                localeInfo.setIndexInLine(n4);
                localeInfo.setLine(string4.toLowerCase());
                if (!this.accept(localeInfo)) {
                    this.m_sbResult.append(string).append("\n");
                    this.m_sbResult.append(n2).append(":");
                    this.m_sbResult.append(string4).append("\n\n");
                }
            }
            n += string4.length() + n3;
            string4 = bufferedReader.readLine();
        }
        Object var14_14 = null;
        if (bufferedReader == null) return;
        try {
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var14_15 = null;
                if (bufferedReader == null) return;
                try {
                    bufferedReader.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean accept(LocaleInfo localeInfo) {
        ILocaleChecker[] iLocaleCheckerArray = this.getLocaleCheckers();
        for (int i = 0; i < iLocaleCheckerArray.length; ++i) {
            if (!iLocaleCheckerArray[i].accept(localeInfo)) continue;
            return true;
        }
        return false;
    }

    private ILocaleChecker[] getLocaleCheckers() {
        if (this.m_oLocaleCheckers == null) {
            this.m_oLocaleCheckers = new ILocaleChecker[]{new LocaleServerLocaleChecker(), new wcmLANGLocaleChecker(), new FCKLANGLocaleChecker(), new ScriptLineCommentLocaleChecker(), new WCMAntParamLocaleChecker(), new BlockCommentLocaleChecker(), new HTMLCommentLocaleChecker(), new JSPCommentLocaleChecker(), new StyleLocaleChecker()};
        }
        return this.m_oLocaleCheckers;
    }
}

