/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.domain;

import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import java.io.File;
import java.util.ArrayList;

public class XTemplateExporter {
    private static final String DIRNAME_SRCFILE = "images";

    public String export(Templates templates) throws WCMException {
        Object object;
        if (templates == null || templates.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(XTemplateExporter.class, "XTemplateExporter.label1", "\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u7684\u6a21\u677f,\u65e0\u6cd5\u5b8c\u6210\u5bfc\u51fa!"));
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String string = filesMan.getNextFilePathName("ST", "zip");
        String string2 = filesMan.mapFilePath(string, 0);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            object = null;
            String string3 = null;
            for (int i = 0; i < templates.size(); ++i) {
                object = (Template)templates.getAt(i);
                string3 = this.export((Template)object, string2);
                if (arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(XTemplateExporter.class, "XTemplateExporter.label2", "\u5bfc\u51fa\u6a21\u677f\u65f6,\u751f\u6210\u76f8\u5173\u6587\u4ef6\u53d1\u751f\u5f02\u5e38!"), cMyException);
        }
        try {
            int n;
            object = new CMyZip();
            ((CMyZip)object).setZipFileName(string);
            for (n = 0; n < arrayList.size(); ++n) {
                String string4 = (String)arrayList.get(n);
                File[] fileArray = new File(string4).listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file = fileArray[i];
                    if (file.isDirectory()) {
                        File[] fileArray2 = file.listFiles();
                        for (int j = 0; j < fileArray2.length; ++j) {
                            ((CMyZip)object).addToZip(fileArray2[j].getPath(), true);
                        }
                        continue;
                    }
                    ((CMyZip)object).addToZip(file.getPath(), false);
                }
            }
            ((CMyZip)object).setZipWithChildDirPath(true);
            ((CMyZip)object).done();
            for (n = 0; n < arrayList.size(); ++n) {
                String string5 = (String)arrayList.get(n);
                CMyFile.deleteDir(string5);
            }
        }
        catch (Exception exception) {
            try {
                filesMan.deleteFile(string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new WCMException(1100, I18NMessage.get(XTemplateExporter.class, "XTemplateExporter.label3", "\u5bfc\u51fa\u6a21\u677f\u65f6,\u538b\u7f29\u6587\u4ef6\u53d1\u751f\u5f02\u5e38!"), exception);
        }
        return CMyFile.extractFileName(string);
    }

    private String export(Template template, String string) throws WCMException, CMyException {
        Object object;
        String string2 = template.getTextWithImgFilter("./images/", true, false);
        HierarchyEntity hierarchyEntity = this.makeHierarchicalDir4Template(template);
        String string3 = string + hierarchyEntity.getBaseDir();
        String string4 = template.getOutputFileExt();
        string4 = !CMyString.isEmpty(string4) ? "." + string4 : "";
        String string5 = string + hierarchyEntity.getFullDir() + template.getName() + string4;
        try {
            object = this.getTemplateFileWriteEncoding(template);
            CMyFile.writeFile(string5, string2, (String)object);
        }
        catch (CMyException cMyException) {
            throw new WCMException(1100, I18NMessage.get(XTemplateExporter.class, "XTemplateExporter.label4", "\u6839\u636e\u6a21\u677f\u7684\u5185\u5bb9\u521b\u5efa\u76f8\u5bf9\u5e94\u7684\u6a21\u677f\u6587\u4ef6\u53d1\u751f\u5f02\u5e38!"), cMyException);
        }
        object = template.getAppendixes(ContextHelper.getLoginUser());
        String string6 = FilesMan.getFilesMan().getTemplateAppendixPath(template.getRootType(), template.getRootId(), 0, true);
        String string7 = null;
        String string8 = null;
        for (int i = 0; i < ((BaseObjs)object).size(); ++i) {
            TempAppendix tempAppendix = (TempAppendix)((BaseObjs)object).getAt(i);
            if (tempAppendix == null) continue;
            string8 = string6 + tempAppendix.getFile();
            string7 = string + hierarchyEntity.getFullDir() + DIRNAME_SRCFILE + File.separator + tempAppendix.getFile();
            if (!CMyFile.fileExists(string8)) continue;
            CMyFile.copyFile(string8, string7);
        }
        return string3;
    }

    private String getTemplateFileWriteEncoding(Template template) {
        String string = null;
        try {
            IPublishFolder iPublishFolder = template.getRoot();
            string = iPublishFolder.getEncoding();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public HierarchyEntity makeHierarchicalDir4Template(Template template) throws WCMException {
        Object[] objectArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (template.getFolderType() == 103) {
            String string = WebSite.findById(template.getRootId()).getName() + File.separator;
            return new HierarchyEntity(string, string);
        }
        Channel channel = Channel.findById(template.getFolderId());
        arrayList.add(channel.getName());
        for (objectArray = channel.getParent(); objectArray != null; objectArray = objectArray.getParent()) {
            arrayList.add(objectArray.getName());
        }
        arrayList.add(channel.getSite().getName());
        objectArray = new String[arrayList.size()];
        int n = objectArray.length;
        while (n > 0) {
            objectArray[--n] = (String)arrayList.get(objectArray.length - 1 - n);
        }
        String string = CMyString.join(objectArray, File.separator);
        return new HierarchyEntity(channel.getSite().getName() + File.separator, string + File.separator);
    }

    public class HierarchyEntity {
        private String m_sBaseDir;
        private String m_sFullDir;

        public HierarchyEntity() {
        }

        public HierarchyEntity(String string, String string2) {
            this.m_sBaseDir = string;
            this.m_sFullDir = string2;
        }

        public String getBaseDir() {
            return this.m_sBaseDir;
        }

        public void setBaseDir(String string) {
            this.m_sBaseDir = string;
        }

        public String getFullDir() {
            return this.m_sFullDir;
        }

        public void setFullDir(String string) {
            this.m_sFullDir = string;
        }
    }
}

